/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringWizardOpenOperation_NonForking;
import org.eclipse.xtext.ui.refactoring.ui.RenameElementWizard;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringExecuter;
import org.eclipse.xtext.ui.refactoring.ui.SaveHelper;

public class DefaultRenameSupport
implements IRenameSupport {
    private static final Logger LOG = Logger.getLogger(DefaultRenameSupport.class);
    @Inject(optional=true)
    private Provider<RenameRefactoringExecuter> executerProvider;
    @Inject(optional=true)
    private IRenameRefactoringProvider renameRefactoringProvider;
    private ProcessorBasedRefactoring renameRefactoring;
    private IRenameElementContext renameElementContext;
    @Inject
    private SaveHelper saveHelper;

    protected boolean initialize(IRenameElementContext renameElementContext, String newName) {
        if (this.executerProvider != null && this.renameRefactoringProvider != null) {
            this.renameRefactoring = this.renameRefactoringProvider.getRenameRefactoring(renameElementContext);
            if (this.renameRefactoring != null && this.renameRefactoring.getProcessor() instanceof AbstractRenameProcessor) {
                ((AbstractRenameProcessor)this.renameRefactoring.getProcessor()).setNewName(newName);
                this.renameElementContext = renameElementContext;
                return true;
            }
        }
        return false;
    }

    public void startRefactoringWithDialog(final boolean previewOnly) throws InterruptedException {
        RenameElementWizard renameElementWizard = new RenameElementWizard(this.renameRefactoring, this.saveHelper, this.renameElementContext){

            protected void addUserInputPages() {
                if (!previewOnly) {
                    super.addUserInputPages();
                }
            }
        };
        if (previewOnly) {
            renameElementWizard.setForcePreviewReview(true);
        }
        RefactoringWizardOpenOperation_NonForking openOperation = new RefactoringWizardOpenOperation_NonForking(renameElementWizard);
        openOperation.run(this.renameElementContext.getTriggeringEditor().getSite().getShell(), "Rename Element");
    }

    public void startDirectRefactoring() throws InterruptedException {
        this.saveHelper.saveEditors(this.renameElementContext);
        RenameRefactoringExecuter renameRefactoringExecuter = (RenameRefactoringExecuter)this.executerProvider.get();
        renameRefactoringExecuter.execute(this.renameElementContext.getTriggeringEditor(), this.renameRefactoring);
    }

    public static class Factory
    implements IRenameSupport.Factory {
        @Inject
        private IGlobalServiceProvider globalServiceProvider;

        public IRenameSupport create(Object context, String newName) {
            IRenameElementContext renameElementContext;
            DefaultRenameSupport renameSupport;
            if (context instanceof IRenameElementContext && (renameSupport = this.getDefaultRenameSupport(renameElementContext = (IRenameElementContext)context)) != null && renameSupport.initialize(renameElementContext, newName)) {
                return renameSupport;
            }
            return null;
        }

        protected DefaultRenameSupport getDefaultRenameSupport(IRenameElementContext renameElementContext) {
            try {
                DefaultRenameSupport renameSupport = (DefaultRenameSupport)this.globalServiceProvider.findService(renameElementContext.getTargetElementURI(), DefaultRenameSupport.class);
                return renameSupport;
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting refactoring components from declaring language", (Throwable)e);
                return null;
            }
        }
    }
}

