/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.ui.containers.AbstractStorage2UriMapperClient;
import org.eclipse.xtext.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAllContainersState
extends AbstractStorage2UriMapperClient
implements IResourceChangeListener,
IAllContainersState {
    private static final Logger log = Logger.getLogger(AbstractAllContainersState.class);
    private Map<URI, String> uriToHandle;
    private ListMultimap<String, String> handleToVisibleHandles;
    private SetMultimap<String, URI> handleToContent;
    private Set<String> emptyHandles;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    protected AbstractAllContainersState() {
        this.initialize();
        this.registerAsListener();
    }

    protected void registerAsListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    public void unregisterAsListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void initialize() {
        try {
            this.writeLock.lock();
            this.uriToHandle = Collections.synchronizedMap(Maps.newHashMap());
            this.handleToVisibleHandles = ArrayListMultimap.create();
            this.handleToContent = LinkedHashMultimap.create();
            this.emptyHandles = Collections.synchronizedSet(Sets.newHashSet());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getContainerHandle(URI uri) {
        String result = null;
        try {
            this.readLock.lock();
            result = this.uriToHandle.get(uri);
        }
        finally {
            this.readLock.unlock();
        }
        if (result == null) {
            result = this.initHandle(uri);
        }
        return result;
    }

    protected String initHandle(URI uri) {
        String result = this.doInitHandle(uri);
        try {
            this.writeLock.lock();
            this.uriToHandle.put(uri, result);
            String string = result;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract String doInitHandle(URI var1);

    public Collection<URI> getContainedURIs(String containerHandle) {
        Set result = null;
        try {
            this.readLock.lock();
            if (this.emptyHandles.contains(containerHandle)) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            result = this.handleToContent.get((Object)containerHandle);
            if (!result.isEmpty()) {
                Set set = result;
                return set;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.initContainedURIs(containerHandle, result);
    }

    public boolean isEmpty(String containerHandle) {
        Set uris = null;
        try {
            this.readLock.lock();
            if (this.emptyHandles.contains(containerHandle)) {
                return true;
            }
            uris = this.handleToContent.get((Object)containerHandle);
            if (!uris.isEmpty()) {
                return false;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.initContainedURIs(containerHandle, uris).isEmpty();
    }

    protected Collection<URI> initContainedURIs(String containerHandle, Collection<URI> result) {
        Collection<URI> uris = this.doInitContainedURIs(containerHandle);
        try {
            this.writeLock.lock();
            if (uris.isEmpty()) {
                this.emptyHandles.add(containerHandle);
                List<URI> list = Collections.emptyList();
                return list;
            }
            if (result.isEmpty()) {
                result.addAll(uris);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    protected abstract Collection<URI> doInitContainedURIs(String var1);

    public List<String> getVisibleContainerHandles(String handle) {
        List visibleHandles = null;
        try {
            this.readLock.lock();
            visibleHandles = this.handleToVisibleHandles.get((Object)handle);
            if (!visibleHandles.isEmpty()) {
                List list = visibleHandles;
                return list;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.initVisibleContainerHandles(handle, visibleHandles);
    }

    protected List<String> initVisibleContainerHandles(String handle, List<String> result) {
        List<String> visibleHandles = this.doInitVisibleHandles(handle);
        if (visibleHandles.isEmpty()) {
            return visibleHandles;
        }
        try {
            this.writeLock.lock();
            if (result.isEmpty()) {
                result.addAll(visibleHandles);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    protected abstract List<String> doInitVisibleHandles(String var1);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2 || event.getType() == 4) {
            this.initialize();
            return;
        }
        if (event.getDelta() != null) {
            IResourceDelta delta = event.getDelta();
            final Wrapper clear = Wrapper.wrap((Object)Boolean.FALSE);
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (((Boolean)clear.get()).booleanValue()) {
                            return false;
                        }
                        if (delta.getResource() != null && AbstractAllContainersState.this.isIgnoredResource(delta.getResource())) {
                            return false;
                        }
                        if (AbstractAllContainersState.this.isAffectingContainerState(delta)) {
                            clear.set((Object)Boolean.TRUE);
                            return false;
                        }
                        return true;
                    }
                });
                if (((Boolean)clear.get()).booleanValue()) {
                    this.initialize();
                }
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.initialize();
            }
        }
    }

    protected boolean isAffectingContainerState(IResourceDelta delta) {
        return delta.getKind() == 1 || delta.getKind() == 2 ? delta.getResource() instanceof IStorage && this.getUri((IStorage)delta.getResource()) != null : delta.getKind() == 4 && delta.getResource() instanceof IProject && (delta.getFlags() & 0x80000) != 0;
    }

    protected boolean isIgnoredResource(IResource resource) {
        return false;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

