/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.AbstractXtypeReferenceVisitorWithParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeParameterSubstitutor
extends AbstractXtypeReferenceVisitorWithParameter<Set<JvmTypeParameter>, JvmTypeReference> {
    private final Map<JvmTypeParameter, JvmTypeReference> typeParameterMapping;
    private final CommonTypeComputationServices services;

    public TypeParameterSubstitutor(Map<JvmTypeParameter, JvmTypeReference> typeParameterMapping, CommonTypeComputationServices services) {
        this.services = services;
        this.typeParameterMapping = Maps.newHashMap(typeParameterMapping);
    }

    protected Map<JvmTypeParameter, JvmTypeReference> getTypeParameterMapping() {
        return this.typeParameterMapping;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected JvmTypeReference handleNullReference(Set<JvmTypeParameter> visiting) {
        return null;
    }

    public void enhanceMapping(Map<JvmTypeParameter, JvmTypeReference> typeParameterMapping) {
        this.typeParameterMapping.putAll(typeParameterMapping);
    }

    @Override
    public JvmTypeReference doVisitFunctionTypeReference(XFunctionTypeRef reference, Set<JvmTypeParameter> visiting) {
        XFunctionTypeRef result = this.services.getXtypeFactory().createXFunctionTypeRef();
        JvmTypeReference equivalent = (JvmTypeReference)reference.eGet((EStructuralFeature)TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT, false);
        if (equivalent != null) {
            result.setEquivalent((JvmTypeReference)this.visit(equivalent, visiting));
        }
        result.setType(reference.getType());
        result.setInstanceContext(reference.isInstanceContext());
        for (JvmTypeReference paramType : reference.getParamTypes()) {
            result.getParamTypes().add((Object)((JvmTypeReference)this.visit(paramType, visiting)));
        }
        result.setReturnType((JvmTypeReference)this.visit(reference.getReturnType(), visiting));
        return result;
    }

    public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmTypeReference result;
        JvmTypeReference mappedReference;
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter && (mappedReference = this.typeParameterMapping.get(type)) != null && mappedReference != reference && (result = (JvmTypeReference)this.visit(mappedReference, visiting)) != null) {
            return result;
        }
        JvmParameterizedTypeReference result2 = this.services.getTypesFactory().createJvmParameterizedTypeReference();
        result2.setType(type);
        for (JvmTypeReference argument : reference.getArguments()) {
            JvmTypeReference copiedArgument = (JvmTypeReference)this.visit(argument, visiting);
            result2.getArguments().add((Object)copiedArgument);
        }
        return result2;
    }

    public JvmTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmWildcardTypeReference result = this.services.getTypesFactory().createJvmWildcardTypeReference();
        for (JvmTypeConstraint constraint : reference.getConstraints()) {
            JvmTypeReference copiedConstraintReference = (JvmTypeReference)this.visit(constraint.getTypeReference(), visiting);
            JvmTypeConstraint copiedConstraint = (JvmTypeConstraint)EcoreUtil.create((EClass)constraint.eClass());
            copiedConstraint.setTypeReference(copiedConstraintReference);
            result.getConstraints().add((Object)copiedConstraint);
        }
        return result;
    }

    public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmTypeReference copiedComponent = (JvmTypeReference)this.visit(reference.getComponentType(), visiting);
        JvmGenericArrayTypeReference result = this.services.getTypesFactory().createJvmGenericArrayTypeReference();
        result.setComponentType(copiedComponent);
        return result;
    }

    public JvmTypeReference doVisitAnyTypeReference(JvmAnyTypeReference reference, Set<JvmTypeParameter> visiting) {
        return this.services.getTypesFactory().createJvmAnyTypeReference();
    }

    public JvmTypeReference doVisitMultiTypeReference(JvmMultiTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmMultiTypeReference result = this.services.getTypesFactory().createJvmMultiTypeReference();
        for (JvmTypeReference component : reference.getReferences()) {
            result.getReferences().add((Object)((JvmTypeReference)this.visit(component, visiting)));
        }
        return result;
    }

    public JvmTypeReference doVisitSynonymTypeReference(JvmSynonymTypeReference reference, Set<JvmTypeParameter> visiting) {
        JvmSynonymTypeReference result = this.services.getTypesFactory().createJvmSynonymTypeReference();
        for (JvmTypeReference component : reference.getReferences()) {
            result.getReferences().add((Object)((JvmTypeReference)this.visit(component, visiting)));
        }
        return result;
    }

    public JvmTypeReference doVisitUnknownTypeReference(JvmUnknownTypeReference reference, Set<JvmTypeParameter> visiting) {
        return this.services.getTypesFactory().createJvmUnknownTypeReference();
    }

    public JvmTypeReference substitute(JvmTypeReference original) {
        if (this.typeParameterMapping.isEmpty()) {
            return original;
        }
        JvmTypeReference result = (JvmTypeReference)this.visit(original, Sets.newHashSet());
        return result;
    }
}

