/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.DelegatingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectationTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.NoTypeResult;
import org.eclipse.xtext.xbase.typesystem.internal.ResolutionBasedComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ReturnExpectationTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeCheckpointComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithNonVoidExpectation;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractTypeComputationState
implements ITypeComputationState,
ITypeComputationState.Fork {
    private final ResolvedTypes resolvedTypes;
    private IFeatureScopeSession featureScopeSession;
    private final DefaultReentrantTypeResolver reentrantTypeResolver;

    protected AbstractTypeComputationState(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, DefaultReentrantTypeResolver reentrantTypeResolver) {
        this.resolvedTypes = resolvedTypes;
        this.featureScopeSession = featureScopeSession;
        this.reentrantTypeResolver = reentrantTypeResolver;
    }

    protected ResolvedTypes getResolvedTypes() {
        return this.resolvedTypes;
    }

    protected IFeatureScopeSession getFeatureScopeSession() {
        return this.featureScopeSession;
    }

    protected CommonTypeComputationServices getServices() {
        return this.reentrantTypeResolver.getServices();
    }

    protected TypeReferences getTypeReferences() {
        return this.getServices().getTypeReferences();
    }

    protected ITypeComputer getTypeComputer() {
        return this.reentrantTypeResolver.getTypeComputer();
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.reentrantTypeResolver;
    }

    protected BoundTypeArgumentMerger getTypeArgumentMerger() {
        return this.reentrantTypeResolver.getTypeArgumentMerger();
    }

    @Override
    public ITypeComputationResult computeTypes(@Nullable XExpression expression) {
        ResolvedTypes types = this.computeTypes(expression, true);
        if (types != null) {
            return new ResolutionBasedComputationResult(expression, types);
        }
        return new NoTypeResult();
    }

    @Nullable
    protected ResolvedTypes computeTypes(@Nullable XExpression expression, boolean mergeAll) {
        if (expression != null) {
            StackedResolvedTypes stackedResolvedTypes = new StackedResolvedTypes(this.resolvedTypes);
            ExpressionTypeComputationState state = this.createExpressionComputationState(expression, stackedResolvedTypes);
            this.getResolver().getTypeComputer().computeTypes(expression, state);
            ResolvedTypes result = mergeAll ? stackedResolvedTypes.mergeIntoParent() : stackedResolvedTypes;
            return result;
        }
        return null;
    }

    @Nullable
    protected StackedResolvedTypes computeTypesWithoutMerge(@Nullable XExpression expression) {
        return (StackedResolvedTypes)this.computeTypes(expression, false);
    }

    protected ExpressionTypeComputationState createExpressionComputationState(XExpression expression, StackedResolvedTypes typeResolution) {
        return new ExpressionTypeComputationState(typeResolution, this.featureScopeSession, this.reentrantTypeResolver, this, expression);
    }

    protected abstract JvmTypeReference acceptType(AbstractTypeExpectation var1, JvmTypeReference var2, ConformanceHint var3, boolean var4);

    @Override
    public AbstractTypeComputationState fork() {
        return this;
    }

    @Override
    public AbstractTypeComputationState withExpectation(JvmTypeReference expectation) {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this, expectation);
    }

    @Override
    public AbstractTypeComputationState withNonVoidExpectation() {
        return new TypeComputationStateWithNonVoidExpectation(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this);
    }

    @Override
    public AbstractTypeComputationState withoutExpectation() {
        return new NoExpectationTypeComputationState(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this);
    }

    @Override
    public AbstractTypeComputationState withReturnExpectation() {
        return new ReturnExpectationTypeComputationState(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this);
    }

    @Override
    public AbstractTypeComputationState withoutImmediateExpectation() {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this, null);
    }

    @Override
    public AbstractTypeComputationState withTypeCheckpoint() {
        return new TypeCheckpointComputationState(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this);
    }

    @Override
    public AbstractTypeComputationState assignType(JvmIdentifiableElement element, JvmTypeReference type) {
        TypeAssigner assigner = this.assignTypes();
        assigner.assignType(element, type);
        return assigner.getForkedState();
    }

    @Override
    public void addLocalToCurrentScope(JvmIdentifiableElement element) {
        this.featureScopeSession = this.featureScopeSession.addLocalElement(QualifiedName.create((String)element.getSimpleName()), element);
    }

    @Override
    public TypeAssigner assignTypes() {
        TypeCheckpointComputationState state = new TypeCheckpointComputationState(this.resolvedTypes, this.featureScopeSession, this.reentrantTypeResolver, this);
        return this.createTypeAssigner(state);
    }

    protected TypeAssigner createTypeAssigner(AbstractTypeComputationState state) {
        return new TypeAssigner(state);
    }

    @Override
    public final List<ITypeExpectation> getImmediateExpectations() {
        return this.getImmediateExpectations(this);
    }

    @Override
    public final List<ITypeExpectation> getReturnExpectations() {
        return this.getReturnExpectations(this);
    }

    protected abstract List<ITypeExpectation> getImmediateExpectations(AbstractTypeComputationState var1);

    protected abstract List<ITypeExpectation> getReturnExpectations(AbstractTypeComputationState var1);

    @Override
    public void acceptActualType(JvmTypeReference type) {
        for (ITypeExpectation expectation : this.getImmediateExpectations()) {
            expectation.acceptActualType(type, ConformanceHint.EXPECTATION_INDEPENDENT);
        }
    }

    @Override
    @Nullable
    public JvmTypeReference getType(JvmIdentifiableElement element) {
        return this.resolvedTypes.getActualType(element);
    }

    @Override
    public void reassignType(XExpression object, JvmTypeReference type) {
        JvmIdentifiableElement refinable = this.getTypeComputer().getRefinableCandidate(object, this);
        if (refinable != null) {
            this.resolvedTypes.reassignType(refinable, type);
        }
    }

    @Override
    public void discardReassignedTypes(XExpression object) {
        JvmIdentifiableElement refinable = this.getTypeComputer().getRefinableCandidate(object, this);
        if (refinable != null) {
            this.resolvedTypes.reassignType(refinable, null);
        }
    }

    @Override
    public List<IFeatureLinkingCandidate> getLinkingCandidates(XAbstractFeatureCall featureCall) {
        IFeatureLinkingCandidate result = this.resolvedTypes.getFeature(featureCall);
        if (result != null) {
            return Collections.singletonList(result);
        }
        DelegatingResolvedTypes demandResolvedTypes = new DelegatingResolvedTypes(this.resolvedTypes){
            private Map<XExpression, StackedResolvedTypes> demandComputedTypes;

            @Nullable
            public JvmTypeReference getActualType(@Nullable XExpression expression) {
                JvmTypeReference type = super.getActualType(expression);
                if (type == null && expression != null) {
                    StackedResolvedTypes previouslyComputed;
                    if (this.demandComputedTypes == null) {
                        this.demandComputedTypes = Maps.newHashMapWithExpectedSize((int)2);
                    }
                    if ((previouslyComputed = this.demandComputedTypes.get(expression)) != null) {
                        return previouslyComputed.getActualType(expression);
                    }
                    AbstractTypeComputationState expressionState = AbstractTypeComputationState.this.fork().withNonVoidExpectation();
                    StackedResolvedTypes result = expressionState.computeTypesWithoutMerge(expression);
                    if (result != null) {
                        this.demandComputedTypes.put(expression, result);
                        return result.getActualType(expression);
                    }
                    return null;
                }
                return type;
            }
        };
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, this.featureScopeSession, demandResolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(featureCall, description));
        }
        if (resultList.isEmpty()) {
            throw new UnsupportedOperationException("TODO Add error candidate");
        }
        return resultList;
    }

    protected IFeatureLinkingCandidate createCandidate(XAbstractFeatureCall featureCall, IEObjectDescription description) {
        return new FeatureLinkingCandidate(featureCall, description, this);
    }

    @Override
    public List<IConstructorLinkingCandidate> getLinkingCandidates(XConstructorCall constructorCall) {
        IConstructorLinkingCandidate result = this.resolvedTypes.getConstructor(constructorCall);
        if (result != null) {
            return Collections.singletonList(result);
        }
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, this.featureScopeSession, this.resolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(constructorCall, description));
        }
        if (resultList.isEmpty()) {
            throw new UnsupportedOperationException("TODO Add error candidate");
        }
        return resultList;
    }

    protected IConstructorLinkingCandidate createCandidate(XConstructorCall constructorCall, IEObjectDescription description) {
        return new ConstructorLinkingCandidate(constructorCall, description, this);
    }

    protected static class TypeAssigner
    implements ITypeAssigner {
        private final AbstractTypeComputationState state;

        protected TypeAssigner(AbstractTypeComputationState state) {
            this.state = state;
        }

        public AbstractTypeComputationState getForkedState() {
            return this.state;
        }

        public void assignType(JvmIdentifiableElement element, @Nullable JvmTypeReference declaredType, @Nullable JvmTypeReference expectedType) {
            if (declaredType != null) {
                this.state.getResolvedTypes().setType(element, declaredType);
            } else {
                this.state.getResolvedTypes().setType(element, expectedType);
            }
            this.state.addLocalToCurrentScope(element);
        }

        public void assignType(JvmIdentifiableElement element, @Nullable JvmTypeReference declaredType) {
            this.state.getResolvedTypes().setType(element, declaredType);
            this.state.addLocalToCurrentScope(element);
        }
    }
}

