/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.linking;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.linking.FeatureCallChecker;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.validation.IssueCodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestMatchingJvmFeatureScope
implements IScope {
    protected final EObject context;
    protected final EReference reference;
    private TypeConformanceComputer conformanceComputer;
    private IScope delegate;
    private FeatureCallChecker featureCallChecker;
    private IRawTypeHelper rawTypeHelper;

    public BestMatchingJvmFeatureScope(TypeConformanceComputer conformanceComputer, EObject context, EReference ref, IScope delegate, FeatureCallChecker featureCallChecker, IRawTypeHelper rawTypeHelper) {
        this.conformanceComputer = conformanceComputer;
        this.context = context;
        this.reference = ref;
        this.delegate = delegate;
        this.featureCallChecker = featureCallChecker;
        this.rawTypeHelper = rawTypeHelper;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        throw new UnsupportedOperationException();
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        throw new UnsupportedOperationException();
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        Iterable unsorted = this.delegate.getElements(name);
        return this.setImplicitReceiverAndIsValid(this.getBestMatch(unsorted));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IEObjectDescription setImplicitReceiverAndIsValid(IEObjectDescription bestMatch) {
        if (!(bestMatch instanceof IValidatedEObjectDescription)) return bestMatch;
        if (this.reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)this.context;
            IValidatedEObjectDescription validated = (IValidatedEObjectDescription)bestMatch;
            featureCall.eSetDeliver(false);
            try {
                XExpression implicitArgument;
                featureCall.setInvalidFeatureIssueCode(validated.getIssueCode());
                if (!(validated instanceof JvmFeatureDescription)) return bestMatch;
                XExpression implicitReceiver = ((JvmFeatureDescription)validated).getImplicitReceiver();
                if (implicitReceiver != null) {
                    featureCall.setImplicitReceiver((XExpression)EcoreUtil2.clone((EObject)implicitReceiver));
                }
                if ((implicitArgument = ((JvmFeatureDescription)validated).getImplicitArgument()) == null) return bestMatch;
                featureCall.setImplicitFirstArgument((XExpression)EcoreUtil2.clone((EObject)implicitArgument));
                return bestMatch;
            }
            finally {
                featureCall.eSetDeliver(true);
            }
        }
        if (this.reference != XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR) return bestMatch;
        XConstructorCall constructorCall = (XConstructorCall)this.context;
        constructorCall.eSetDeliver(false);
        try {
            constructorCall.setInvalidFeatureIssueCode(((IValidatedEObjectDescription)bestMatch).getIssueCode());
            return bestMatch;
        }
        finally {
            constructorCall.eSetDeliver(true);
        }
    }

    protected IEObjectDescription getBestMatch(Iterable<IEObjectDescription> iterable) {
        IEObjectDescription bestMatch = null;
        for (IEObjectDescription description : iterable) {
            this.featureCallChecker.checkWithoutTypes(description);
            bestMatch = bestMatch == null ? description : this.getBestMatch(bestMatch, description);
        }
        return bestMatch;
    }

    protected IEObjectDescription getBestMatch(IEObjectDescription a, IEObjectDescription b) {
        if (a instanceof IValidatedEObjectDescription && b instanceof IValidatedEObjectDescription) {
            boolean again;
            IValidatedEObjectDescription descA = (IValidatedEObjectDescription)a;
            IValidatedEObjectDescription descB = (IValidatedEObjectDescription)b;
            IValidatedEObjectDescription result = this.selectByIssueCode(descA, descB);
            if (result != null) {
                return result;
            }
            this.featureCallChecker.checkTypesWithoutGenerics(a);
            this.featureCallChecker.checkTypesWithoutGenerics(b);
            do {
                if ((result = this.selectByIssueCode(descA, descB)) != null) {
                    return result;
                }
                again = this.featureCallChecker.checkTypesWithGenerics(a);
            } while (again = this.featureCallChecker.checkTypesWithGenerics(b) || again);
            if (a instanceof JvmFeatureDescription && b instanceof JvmFeatureDescription) {
                JvmFeatureDescription potentialResult;
                JvmFeatureDescription featureDescriptionA = (JvmFeatureDescription)descA;
                JvmFeatureDescription featureDescriptionB = (JvmFeatureDescription)descB;
                if (featureDescriptionA.isValid() && featureDescriptionB.isValid() && (potentialResult = this.getBestConformanceMatch(featureDescriptionA, featureDescriptionB)) != null) {
                    return potentialResult;
                }
                if (descA.getEObjectOrProxy() instanceof JvmExecutable && descB.getEObjectOrProxy() instanceof JvmExecutable) {
                    JvmExecutable opA = (JvmExecutable)descA.getEObjectOrProxy();
                    JvmExecutable opB = (JvmExecutable)descB.getEObjectOrProxy();
                    if (descA.isValid() && descB.isValid()) {
                        if (opA.isVarArgs()) {
                            if (!opB.isVarArgs()) {
                                return b;
                            }
                        } else if (opB.isVarArgs()) {
                            return a;
                        }
                    }
                    ITypeArgumentContext contextA = featureDescriptionA.getRawTypeContext();
                    ITypeArgumentContext contextB = featureDescriptionB.getRawTypeContext();
                    int numParamsA = opA.getParameters().size();
                    int numParamsB = opB.getParameters().size();
                    int i = 0;
                    while (i < Math.min(numParamsA, numParamsB)) {
                        JvmTypeReference pA = ((JvmFormalParameter)opA.getParameters().get(numParamsA - i - 1)).getParameterType();
                        pA = contextA.getLowerBound(pA);
                        pA = this.rawTypeHelper.getRawTypeReference(pA, this.context.eResource());
                        JvmTypeReference pB = ((JvmFormalParameter)opB.getParameters().get(numParamsB - i - 1)).getParameterType();
                        pB = contextB.getLowerBound(pB);
                        if (!this.conformanceComputer.isConformant(pB = this.rawTypeHelper.getRawTypeReference(pB, this.context.eResource()), pA, true)) {
                            return b;
                        }
                        ++i;
                    }
                    return a;
                }
            }
        }
        return a;
    }

    protected IValidatedEObjectDescription selectByIssueCode(IValidatedEObjectDescription descA, IValidatedEObjectDescription descB) {
        if (!descA.isSameValidationState(descB)) {
            return null;
        }
        if (descA.isValid()) {
            if (!descB.isValid()) {
                return descA;
            }
        } else {
            if (descB.isValid()) {
                return descB;
            }
            if (!descA.isValid() && !descB.isValid() && descA.getIssueCode() != null && descB.getIssueCode() != null) {
                int issueCodeComparison = IssueCodes.compareIssueCodes(descA.getIssueCode(), descB.getIssueCode());
                if (issueCodeComparison < 0) {
                    return descA;
                }
                if (issueCodeComparison > 0) {
                    return descB;
                }
            }
        }
        return null;
    }

    protected JvmFeatureDescription getBestConformanceMatch(JvmFeatureDescription featureDescriptionA, JvmFeatureDescription featureDescriptionB) {
        List<EnumSet<Object>> allHintsB;
        List<EnumSet<Object>> allHintsA = featureDescriptionA.getArgumentConversionHints();
        if (allHintsA == null) {
            allHintsA = Collections.emptyList();
        }
        if ((allHintsB = featureDescriptionB.getArgumentConversionHints()) == null) {
            allHintsB = Collections.emptyList();
        }
        int aIsBetter = 0;
        int bIsBetter = 0;
        int i = 0;
        while (i < allHintsA.size() && i < allHintsB.size()) {
            EnumSet<Object> hintsA = allHintsA.get(i);
            EnumSet<Object> hintsB = allHintsB.get(i);
            TypeConformanceResult.Kind[] kindArray = TypeConformanceResult.Kind.values();
            int n = kindArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeConformanceResult.Kind kind = kindArray[n2];
                if (hintsA.contains(kind)) {
                    if (!hintsB.contains(kind)) {
                        ++aIsBetter;
                        break;
                    }
                } else if (hintsB.contains(kind)) {
                    ++bIsBetter;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        if (aIsBetter == bIsBetter) {
            return null;
        }
        if (aIsBetter > bIsBetter) {
            return featureDescriptionA;
        }
        return featureDescriptionB;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " -> " + this.delegate;
    }
}

