/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.formatting.MemberFromSuperImplementor;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendImport;
import org.eclipse.xtend.ide.buildpath.XtendLibClasspathAdder;
import org.eclipse.xtend.ide.contentassist.ReplacingAppendable;
import org.eclipse.xtend.ide.edit.OrganizeImportsHandler;
import org.eclipse.xtend.ide.quickfix.XtendTypeReferenceSerializer;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.common.types.xtext.ui.JdtVariableCompletions;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.model.edit.SemanticModificationWrapper;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendQuickfixProvider
extends DefaultQuickfixProvider {
    private static final Logger logger = Logger.getLogger(XtendQuickfixProvider.class);
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private MemberFromSuperImplementor superMemberImplementor;
    @Inject
    private XtendGrammarAccess grammarAccess;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private OrganizeImportsHandler organizeImportsHandler;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private XtendTypeReferenceSerializer typeRefSerializer;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private XtendLibClasspathAdder xtendLibAdder;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private VisibilityService visibilityService;
    @Inject
    private Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private JdtVariableCompletions jdtVariableCompletions;
    @Inject
    private Primitives primitives;
    @Inject
    private CommonTypeComputationServices computationServices;

    public boolean hasResolutionFor(String issueCode) {
        if ("org.eclipse.xtend.core.linking.XtendLinkingDiagnosticMessageProvider.Linking".equals(issueCode)) {
            return true;
        }
        return super.hasResolutionFor(issueCode);
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        StopWatch stopWatch = new StopWatch(logger);
        try {
            if ("org.eclipse.xtend.core.linking.XtendLinkingDiagnosticMessageProvider.Linking".equals(issue.getCode())) {
                IssueResolutionAcceptor issueResolutionAcceptor = (IssueResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
                this.createXtendLinkingIssueResolutions(issue, issueResolutionAcceptor);
                List list = issueResolutionAcceptor.getIssueResolutions();
                return list;
            }
            List list = super.getResolutions(issue);
            return list;
        }
        finally {
            stopWatch.resetAndLog("#getResolutions");
        }
    }

    protected void createXtendLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        String elementName;
        final IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (issue.getData() != null && xtextDocument != null && (elementName = issue.getData()[0]) != null) {
            xtextDocument.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    EObject eObject = state.getEObject(issue.getUriToProblem().fragment());
                    if (eObject instanceof XAbstractFeatureCall) {
                        ICompositeNode callNode;
                        XAbstractFeatureCall call = (XAbstractFeatureCall)eObject;
                        EList explicitArguments = call.getExplicitArguments();
                        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable(new ImportManager(true));
                        XtendQuickfixProvider.this.computeTypeArguments((XExpression)call, (List<JvmTypeReference>)call.getTypeArguments(), (IAppendable)appendable);
                        JvmTypeReference expectedType = XtendQuickfixProvider.this.typeProvider.getExpectedType((XExpression)call);
                        TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(Collections.emptyMap(), XtendQuickfixProvider.this.computationServices);
                        JvmTypeReference resolvedExpectedType = substitutor.substitute(expectedType);
                        if (resolvedExpectedType != null && resolvedExpectedType.getType() != null) {
                            XtendQuickfixProvider.this.typeRefSerializer.serialize(resolvedExpectedType, (EObject)call, (IAppendable)appendable);
                            appendable.append((CharSequence)" ");
                        }
                        appendable.append((CharSequence)elementName);
                        XtendQuickfixProvider.this.computeArgumentString(call, false, (IAppendable)appendable);
                        boolean isExtension = false;
                        if (call instanceof XMemberFeatureCall) {
                            isExtension = ((XMemberFeatureCall)call).getMemberCallTarget() != null;
                        }
                        boolean isSetter = false;
                        if (call instanceof XAssignment) {
                            isSetter = true;
                        }
                        XtendQuickfixProvider.this.createNewXtendFunction(elementName, appendable.toString(), isExtension, isSetter, resolvedExpectedType, issue, issueResolutionAcceptor, modificationContext);
                        if (resolvedExpectedType != null && resolvedExpectedType.getType() != null && explicitArguments.size() == 0 && (callNode = NodeModelUtils.getNode((EObject)call)) != null && !callNode.getText().endsWith(")")) {
                            XtendQuickfixProvider.this.createNewXtendField(elementName, resolvedExpectedType, call, issue, issueResolutionAcceptor, modificationContext);
                            XtendQuickfixProvider.this.createNewLocalVariable(elementName, resolvedExpectedType, issue, issueResolutionAcceptor, modificationContext);
                        }
                    }
                }
            });
        }
    }

    protected void createNewLocalVariable(final @NonNull String elementName, @NonNull JvmTypeReference expectedType, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IModificationContext modificationContext) {
        StringBuilderBasedAppendable localVarDescriptionBuilder = new StringBuilderBasedAppendable();
        localVarDescriptionBuilder.append((CharSequence)"...").newLine();
        final String defaultValueLiteral = this.getDefaultValueLiteral(expectedType);
        localVarDescriptionBuilder.append((CharSequence)"val ").append((CharSequence)elementName).append((CharSequence)" = ").append((CharSequence)defaultValueLiteral);
        localVarDescriptionBuilder.newLine().append((CharSequence)"...");
        IssueResolution issueResolutionlocalVarInType = new IssueResolution("create local variable " + elementName, localVarDescriptionBuilder.toString(), "fix_local_var.png", modificationContext, (IModification)new SemanticModificationWrapper(issue.getUriToProblem(), new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendFunction xtendFunction;
                if (element != null && (xtendFunction = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)element, XtendFunction.class)) != null) {
                    int offset = XtendQuickfixProvider.this.getFirstOffsetOfKeyword((EObject)xtendFunction, "{");
                    IXtextDocument xtextDocument = context.getXtextDocument();
                    if (offset != -1 && xtextDocument != null) {
                        ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(xtextDocument, element, offset, 0, 1, false);
                        appendable.newLine().append((CharSequence)"val ").append((CharSequence)elementName).append((CharSequence)" = ").append((CharSequence)defaultValueLiteral);
                        appendable.commitChanges();
                    }
                }
            }
        }));
        issueResolutionAcceptor.getIssueResolutions().add(issueResolutionlocalVarInType);
    }

    protected String getDefaultValueLiteral(JvmTypeReference type) {
        if (this.primitives.isPrimitive(type)) {
            Primitives.Primitive primitiveKind = this.primitives.primitiveKind((JvmPrimitiveType)type.getType());
            if (primitiveKind == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "0 as " + type.getSimpleName();
        }
        return "null";
    }

    protected void createNewXtendFunction(final @NonNull String elementName, @NonNull String callText, boolean isExtension, final boolean isSetter, final JvmTypeReference expectedType, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IModificationContext modificationContext) {
        StringBuilderBasedAppendable methodDescriptionBuilder = new StringBuilderBasedAppendable();
        StringBuilderBasedAppendable methodLabelBuilder = new StringBuilderBasedAppendable();
        methodDescriptionBuilder.append((CharSequence)"...").newLine().append((CharSequence)"def ");
        methodLabelBuilder.append((CharSequence)"create ");
        if (isExtension) {
            methodLabelBuilder.append((CharSequence)"extension ");
        }
        methodLabelBuilder.append((CharSequence)"method ");
        if (isSetter) {
            methodLabelBuilder.append((CharSequence)"set");
            methodDescriptionBuilder.append((CharSequence)"set");
        }
        methodLabelBuilder.append((CharSequence)elementName);
        methodDescriptionBuilder.append((CharSequence)callText).append((CharSequence)" {}").newLine().append((CharSequence)"...");
        IssueResolution issueResolutionMethodInType = new IssueResolution(methodLabelBuilder.toString(), methodDescriptionBuilder.toString(), "fix_public_function.png", modificationContext, (IModification)new SemanticModificationWrapper(issue.getUriToProblem(), new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element != null) {
                    XAbstractFeatureCall call = (XAbstractFeatureCall)element;
                    XtendClass xtendClazz = (XtendClass)EcoreUtil2.getContainerOfType((EObject)element, XtendClass.class);
                    IXtextDocument xtextDocument = context.getXtextDocument();
                    XtendQuickfixProvider.this.doCreateNewFunctionInClazz(call, xtendClazz, expectedType, isSetter, xtextDocument, elementName);
                }
            }
        }));
        issueResolutionAcceptor.getIssueResolutions().add(issueResolutionMethodInType);
    }

    protected void doCreateNewFunctionInClazz(@NonNull XAbstractFeatureCall call, XtendClass xtendClazz, @Nullable JvmTypeReference expectedType, boolean isSetter, IXtextDocument xtextDocument, @NonNull String functionName) throws BadLocationException {
        ICompositeNode node;
        XtendFunction function = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)call, XtendFunction.class);
        int offset = this.superMemberImplementor.getFunctionInsertOffset(xtendClazz);
        if (function != null && (node = NodeModelUtils.getNode((EObject)function)) != null) {
            offset = node.getTotalEndOffset();
        }
        ReplacingAppendable appendable = this.appendableFactory.get(xtextDocument, (EObject)call, offset, 0, 1, false);
        appendable.newLine().increaseIndentation().append((CharSequence)"def ");
        this.computeTypeArguments((XExpression)call, (List<JvmTypeReference>)call.getTypeArguments(), (IAppendable)appendable);
        if (expectedType != null && expectedType.getType() != null) {
            this.typeRefSerializer.serialize(expectedType, (EObject)call, (IAppendable)appendable);
            appendable.append(" ");
        }
        if (isSetter) {
            appendable.append("set");
        }
        appendable.append(functionName);
        this.computeArgumentString(call, true, (IAppendable)appendable);
        appendable.append(" { }").decreaseIndentation().decreaseIndentation().newLine();
        appendable.commitChanges();
    }

    protected void createNewXtendField(final @NonNull String elementName, final @NonNull JvmTypeReference expectedType, XAbstractFeatureCall call, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IModificationContext modificationContext) {
        StringBuilderBasedAppendable fieldDescriptionBuilder = new StringBuilderBasedAppendable(new ImportManager(true));
        fieldDescriptionBuilder.append((CharSequence)"...").newLine();
        this.typeRefSerializer.serialize(expectedType, (EObject)call, (IAppendable)fieldDescriptionBuilder);
        fieldDescriptionBuilder.append((CharSequence)" ").append((CharSequence)elementName).newLine().append((CharSequence)"...");
        IssueResolution issueResolutionField = new IssueResolution("create field " + elementName, fieldDescriptionBuilder.toString(), "fix_private_field.png", modificationContext, (IModification)new SemanticModificationWrapper(issue.getUriToProblem(), new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XAbstractFeatureCall call = (XAbstractFeatureCall)element;
                XtendClass xtendClazz = (XtendClass)EcoreUtil2.getContainerOfType((EObject)element, XtendClass.class);
                IXtextDocument xtextDocument = context.getXtextDocument();
                int openingBraceOffset = XtendQuickfixProvider.this.getFirstOffsetOfKeyword((EObject)xtendClazz, "{");
                if (openingBraceOffset != -1 && xtextDocument != null && call != null) {
                    XtendQuickfixProvider.this.doCreateNewFieldInClazz(elementName, call, expectedType, xtextDocument, openingBraceOffset);
                }
            }
        }));
        issueResolutionAcceptor.getIssueResolutions().add(issueResolutionField);
    }

    protected void doCreateNewFieldInClazz(@NonNull String elementName, @NonNull XAbstractFeatureCall call, @NonNull JvmTypeReference expectedType, @NonNull IXtextDocument xtextDocument, int openingBraceOffset) throws BadLocationException {
        ReplacingAppendable appendable = this.appendableFactory.get(xtextDocument, (EObject)call, openingBraceOffset, 0, 1, false);
        appendable.newLine();
        this.typeRefSerializer.serialize(expectedType, (EObject)call, (IAppendable)appendable);
        appendable.append(" ").append((CharSequence)elementName);
        appendable.commitChanges();
    }

    protected int getFirstOffsetOfKeyword(EObject object, String keyword) {
        ICompositeNode node;
        int offset = -1;
        if (object != null && (node = NodeModelUtils.getNode((EObject)object)) != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (!(leafNode.getGrammarElement() instanceof Keyword) || !Strings.equal((String)keyword, (String)((Keyword)leafNode.getGrammarElement()).getValue())) continue;
                return leafNode.getOffset() + 1;
            }
        }
        return offset;
    }

    protected void computeArgumentString(XAbstractFeatureCall call, boolean paramNames, IAppendable appendable) {
        Iterator iterator = call.getExplicitArguments().iterator();
        HashSet notallowed = Sets.newHashSet();
        appendable.append((CharSequence)"(");
        while (iterator.hasNext()) {
            XExpression expression = (XExpression)iterator.next();
            JvmTypeReference typeRef = this.typeProvider.getType(expression);
            if (typeRef != null) {
                this.typeRefSerializer.serialize(typeRef, (EObject)call, appendable);
                appendable.append((CharSequence)" ");
                VariableNameAcceptor acceptor = new VariableNameAcceptor(notallowed);
                this.jdtVariableCompletions.getVariableProposals(typeRef.getIdentifier(), (EObject)call, JdtVariableCompletions.VariableType.PARAMETER, (Set)notallowed, (JdtVariableCompletions.CompletionDataAcceptor)acceptor);
                appendable.append((CharSequence)acceptor.getVariableName());
            }
            if (!iterator.hasNext()) continue;
            appendable.append((CharSequence)", ");
        }
        appendable.append((CharSequence)")");
    }

    protected void computeTypeArguments(XExpression expression, List<JvmTypeReference> typeArguments, IAppendable appendable) {
        if (typeArguments.size() > 0) {
            appendable.append((CharSequence)"<");
            Iterator<JvmTypeReference> iterator = typeArguments.iterator();
            while (iterator.hasNext()) {
                JvmTypeReference next = iterator.next();
                this.typeRefSerializer.serialize(next, (EObject)expression, appendable);
                if (!iterator.hasNext()) continue;
                appendable.append((CharSequence)", ");
            }
            appendable.append((CharSequence)">").append((CharSequence)" ");
        }
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    EObject target = state.getEObject(issue.getUriToProblem().fragment());
                    EReference reference = XtendQuickfixProvider.this.getUnresolvedEReference(issue, target);
                    if (reference == null) {
                        return;
                    }
                    String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                    IScope scope = XtendQuickfixProvider.this.getScopeProvider().getScope(target, reference);
                    boolean useJavaSearch = false;
                    if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (useJavaSearch) {
                        XtendClass xtendClass = (XtendClass)EcoreUtil2.getContainerOfType((EObject)target, XtendClass.class);
                        JvmGenericType jvmType = xtendClass != null ? XtendQuickfixProvider.this.associations.getInferredType(xtendClass) : null;
                        IJavaSearchScope javaSearchScope = XtendQuickfixProvider.this.getJavaSearchScope(target);
                        XtendQuickfixProvider.this.createImportProposals((JvmDeclaredType)jvmType, issue, issueString, javaSearchScope, issueResolutionAcceptor);
                        scope = XtendQuickfixProvider.this.getImportedTypesScope(target, issueString, scope, javaSearchScope);
                    }
                    ArrayList discardedDescriptions = Lists.newArrayList();
                    HashSet qualifiedNames = Sets.newHashSet();
                    int addedDescriptions = 0;
                    int checkedDescriptions = 0;
                    for (IEObjectDescription referableElement : XtendQuickfixProvider.this.queryScope(scope)) {
                        String referableElementQualifiedName = XtendQuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getQualifiedName());
                        if (useJavaSearch || XtendQuickfixProvider.this.getSimilarityMatcher().isSimilar(issueString, XtendQuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getName()))) {
                            ++addedDescriptions;
                            this.createResolution(issueString, referableElement);
                            qualifiedNames.add(referableElementQualifiedName);
                        } else if (qualifiedNames.add(referableElementQualifiedName)) {
                            discardedDescriptions.add(referableElement);
                        }
                        if (++checkedDescriptions > 100) break;
                    }
                    if (discardedDescriptions.size() + addedDescriptions <= 5) {
                        for (IEObjectDescription referableElement : discardedDescriptions) {
                            this.createResolution(issueString, referableElement);
                        }
                    }
                }

                public void createResolution(String issueString, IEObjectDescription solution) {
                    String replacement = XtendQuickfixProvider.this.getQualifiedNameConverter().toString(solution.getName());
                    String replaceLabel = XtendQuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
                    issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, XtendQuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), (IModification)new ReplaceModification(issue, replacement));
                }
            });
        }
    }

    protected IJavaSearchScope getJavaSearchScope(EObject model) {
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return null;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        return searchScope;
    }

    protected IScope getImportedTypesScope(EObject model, final String misspelled, final IScope actualScope, IJavaSearchScope scope) {
        if (scope == null) {
            return IScope.NULLSCOPE;
        }
        try {
            XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)model, XtendFile.class);
            HashSet visiblePackages = Sets.newHashSet((Object[])new String[]{"java.lang"});
            visiblePackages.add("");
            if (xtendFile.getPackage() != null) {
                visiblePackages.add(xtendFile.getPackage());
            }
            HashSet importedTypes = Sets.newHashSet();
            final HashSet seen = Sets.newHashSet();
            for (XtendImport importedNamespace : xtendFile.getImports()) {
                if (importedNamespace.getImportedNamespace() == null) continue;
                String importedAsString = importedNamespace.getImportedNamespace();
                if (importedNamespace.isWildcard()) {
                    importedAsString = importedAsString.substring(0, importedAsString.length() - 2);
                    if (!importedNamespace.isStatic()) {
                        visiblePackages.add(importedAsString);
                        continue;
                    }
                    importedTypes.add(importedAsString);
                    continue;
                }
                importedTypes.add(importedAsString);
            }
            SearchEngine searchEngine = new SearchEngine();
            final ArrayList validProposals = Lists.newArrayList();
            for (String importedType : importedTypes) {
                QualifiedName qualifiedName;
                Iterator iterator;
                if (validProposals.size() > 5 || !seen.add(importedType)) continue;
                int dot = importedType.lastIndexOf(46);
                if (dot != -1) {
                    importedType = importedType.substring(dot + 1);
                }
                if (!this.isSimilarTypeName(misspelled, importedType) || !(iterator = actualScope.getElements(qualifiedName = this.getQualifiedNameConverter().toQualifiedName(importedType)).iterator()).hasNext()) continue;
                IEObjectDescription element = (IEObjectDescription)iterator.next();
                validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
            }
            for (String visiblePackage : visiblePackages) {
                if (validProposals.size() > 5) continue;
                searchEngine.searchAllTypeNames(visiblePackage.toCharArray(), 0, null, 0, 0, scope, new TypeNameRequestor(){

                    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        QualifiedName qualifiedName;
                        Iterator iterator;
                        String fqNameAsString;
                        StringBuilder typeNameBuilder = new StringBuilder(simpleTypeName.length);
                        char[][] cArray = enclosingTypeNames;
                        int n = enclosingTypeNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] enclosingType = cArray[n2];
                            typeNameBuilder.append(enclosingType);
                            typeNameBuilder.append('$');
                            ++n2;
                        }
                        typeNameBuilder.append(simpleTypeName);
                        String typeName = typeNameBuilder.toString();
                        if (XtendQuickfixProvider.this.isSimilarTypeName(misspelled, typeName) && seen.add(fqNameAsString = XtendQuickfixProvider.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName)) && (iterator = actualScope.getElements(qualifiedName = XtendQuickfixProvider.this.getQualifiedNameConverter().toQualifiedName(typeName)).iterator()).hasNext()) {
                            IEObjectDescription element = (IEObjectDescription)iterator.next();
                            validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
                        }
                    }
                }, 3, (IProgressMonitor)new NullProgressMonitor(){

                    public boolean isCanceled() {
                        return validProposals.size() > 5;
                    }
                });
            }
            return new SimpleScope((Iterable)validProposals);
        }
        catch (JavaModelException jme) {
            return IScope.NULLSCOPE;
        }
    }

    protected boolean isSimilarTypeName(String s0, String s1) {
        double levenshteinDistance = StringUtils.getLevenshteinDistance((String)s0, (String)s1);
        return levenshteinDistance <= 3.0;
    }

    protected String getQualifiedTypeName(char[] packageName, char[][] enclosingTypeNames, char[] simpleTypeName) {
        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
        if (packageName.length != 0) {
            fqName.append(packageName);
            fqName.append('.');
        }
        char[][] cArray = enclosingTypeNames;
        int n = enclosingTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] enclosingType = cArray[n2];
            fqName.append(enclosingType);
            fqName.append('$');
            ++n2;
        }
        fqName.append(simpleTypeName);
        String fqNameAsString = fqName.toString();
        return fqNameAsString;
    }

    protected void createImportProposals(final JvmDeclaredType contextType, final Issue issue, String typeSimpleName, IJavaSearchScope searchScope, final IssueResolutionAcceptor acceptor) throws JavaModelException {
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames(null, 0, typeSimpleName.toCharArray(), 0, 0, searchScope, new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                final String qualifiedTypeName = XtendQuickfixProvider.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName);
                JvmType importType = XtendQuickfixProvider.this.typeReferences.findDeclaredType(qualifiedTypeName, (Notifier)contextType);
                if (importType instanceof JvmDeclaredType && XtendQuickfixProvider.this.visibilityService.isVisible((JvmMember)((JvmDeclaredType)importType), contextType)) {
                    StringBuilder label = new StringBuilder("Import '");
                    label.append(new String(simpleTypeName));
                    label.append("' (");
                    label.append(new String(packageName));
                    if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        boolean isFirst = true;
                        char[][] cArray = enclosingTypeNames;
                        int n = enclosingTypeNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] enclosingTypeName = cArray[n2];
                            if (isFirst) {
                                label.append(".");
                            } else {
                                label.append("$");
                            }
                            isFirst = false;
                            label.append(new String(enclosingTypeName));
                            ++n2;
                        }
                    }
                    label.append(")");
                    acceptor.accept(issue, label.toString(), label.toString(), "fix_indent.gif", new ISemanticModification(){

                        public void apply(EObject element, IModificationContext context) throws Exception {
                            ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), element, 0, 0);
                            appendable.append(XtendQuickfixProvider.this.typeReferences.findDeclaredType(qualifiedTypeName, (Notifier)element));
                            appendable.insertNewImports();
                        }
                    });
                }
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor());
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.inconsistent_indentation")
    public void fixIndentation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Correct indentation", "Correctly indents this line in this rich string", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.import_duplicate")
    public void fixDuplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.import_wildcard_deprecated")
    public void fixDuplicateWildcardUse(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.import_unsued")
    public void fixUnusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    protected void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Organize Imports.", "Organizes the whole import section. Removes wildcard imports as well as duplicates and unused ones.", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.organizeImportsHandler.doOrganizeImports(context.getXtextDocument());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_override")
    public void fixMissingOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'def' to 'override'", "Marks this function as 'override'", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMemberAccess().findKeywords(new String[]{"def"}).get(0), "override", element, context.getXtextDocument());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.obsolete_override")
    public void fixObsoleteOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'override' to 'def'", "Removes 'override' from this function", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.replaceKeyword((Keyword)XtendQuickfixProvider.this.grammarAccess.getMemberAccess().findKeywords(new String[]{"override"}).get(0), "def", element, context.getXtextDocument());
            }
        });
    }

    protected void replaceKeyword(Keyword keyword, String replacement, EObject container, IXtextDocument document) throws BadLocationException {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)container);
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                if (leafNode.getGrammarElement() != keyword) continue;
                String actualReplacement = replacement;
                if (!Character.isWhitespace(document.getChar(leafNode.getOffset() - 1))) {
                    actualReplacement = " " + replacement;
                }
                document.replace(leafNode.getOffset(), leafNode.getLength(), actualReplacement);
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_constructor")
    public void addConstuctorFromSuper(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null) {
            int i = 0;
            while (i < issue.getData().length) {
                final URI constructorURI = URI.createURI((String)issue.getData()[i]);
                String signature = issue.getData()[i + 1];
                acceptor.accept(issue, "Add constructor " + signature, "Add constructor " + signature, "fix_indent.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        XtendClass clazz = (XtendClass)element;
                        ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)clazz, XtendQuickfixProvider.this.superMemberImplementor.getConstructorInsertOffset(clazz), 0);
                        EObject constructor = clazz.eResource().getResourceSet().getEObject(constructorURI, true);
                        if (constructor instanceof JvmConstructor) {
                            XtendQuickfixProvider.this.superMemberImplementor.appendConstructorFromSuper(clazz, (JvmConstructor)constructor, (IAppendable)appendable);
                        }
                        appendable.commitChanges();
                    }
                });
                i += 2;
            }
        }
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.class_must_be_defined_abstract")
    public void implementAbstractMethods(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add unimplemented methods", "Add unimplemented methods", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendClass clazz = (XtendClass)element;
                    IXtextDocument document = context.getXtextDocument();
                    ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(document, (EObject)clazz, XtendQuickfixProvider.this.superMemberImplementor.getFunctionInsertOffset(clazz), 0);
                    appendable.increaseIndentation();
                    String[] stringArray = issue.getData();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String operationUriAsString = stringArray[n2];
                        URI operationURI = URI.createURI((String)operationUriAsString);
                        EObject overridden = clazz.eResource().getResourceSet().getEObject(operationURI, true);
                        if (overridden instanceof JvmOperation) {
                            appendable.newLine();
                            XtendQuickfixProvider.this.superMemberImplementor.appendOverrideFunction(clazz, (JvmOperation)overridden, (IAppendable)appendable);
                            appendable.newLine();
                        }
                        ++n2;
                    }
                    appendable.decreaseIndentation();
                    appendable.newLine();
                    appendable.commitChanges();
                }
            });
        }
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void addThrowsDeclaration(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add throws declaration", "Add throws declaration", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    URI exceptionURI = URI.createURI((String)issue.getData()[0]);
                    XtendFunction xtendFunction = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)element, XtendFunction.class);
                    XtextResource xtextResource = (XtextResource)xtendFunction.eResource();
                    EObject exception = xtextResource.getResourceSet().getEObject(exceptionURI, true);
                    if (exception instanceof JvmType) {
                        EList thrownExceptions;
                        int insertPosition;
                        JvmType exceptionType = (JvmType)exception;
                        if (xtendFunction.getExpression() == null) {
                            ICompositeNode functionNode = NodeModelUtils.findActualNodeFor((EObject)xtendFunction);
                            if (functionNode == null) {
                                throw new IllegalStateException("functionNode may not be null");
                            }
                            insertPosition = functionNode.getOffset() + functionNode.getLength();
                        } else {
                            ICompositeNode expressionNode = NodeModelUtils.findActualNodeFor((EObject)xtendFunction.getExpression());
                            if (expressionNode == null) {
                                throw new IllegalStateException("expressionNode may not be null");
                            }
                            insertPosition = expressionNode.getOffset();
                        }
                        ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)xtendFunction, insertPosition, 0);
                        if (xtendFunction.getExpression() == null) {
                            appendable.append(" ");
                        }
                        if ((thrownExceptions = xtendFunction.getExceptions()).isEmpty()) {
                            appendable.append("throws ");
                        } else {
                            appendable.append(", ");
                        }
                        XtendQuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)XtendQuickfixProvider.this.typeRefs.createTypeRef(exceptionType, new JvmTypeReference[0]), (EObject)xtendFunction, (IAppendable)appendable);
                        if (xtendFunction.getExpression() != null) {
                            appendable.append(" ");
                        }
                        appendable.commitChanges();
                    }
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void surroundWithTryCatch(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 1) {
            acceptor.accept(issue, "Surround with try/catch block", "Surround with try/catch block", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    URI exceptionURI = URI.createURI((String)issue.getData()[0]);
                    URI childURI = URI.createURI((String)issue.getData()[1]);
                    XtextResource xtextResource = (XtextResource)element.eResource();
                    EObject exception = xtextResource.getResourceSet().getEObject(exceptionURI, true);
                    if (exception instanceof JvmType) {
                        JvmType exceptionType = (JvmType)exception;
                        EObject childThrowingException = xtextResource.getResourceSet().getEObject(childURI, true);
                        XExpression toBeSurrounded = XtendQuickfixProvider.this.findContainerExpressionInBlockExpression(childThrowingException);
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        if (toBeSurrounded != null) {
                            ICompositeNode toBeSurroundedNode = NodeModelUtils.findActualNodeFor((EObject)toBeSurrounded);
                            if (toBeSurroundedNode == null) {
                                throw new IllegalStateException("toBeSurroundedNode may not be null");
                            }
                            ReplacingAppendable appendable = XtendQuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), childThrowingException, toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength());
                            appendable.append("try {").increaseIndentation().newLine().append((CharSequence)xtextDocument.get(toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength())).decreaseIndentation().newLine().append((CharSequence)"} catch (");
                            XtendQuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)XtendQuickfixProvider.this.typeRefs.createTypeRef(exceptionType, new JvmTypeReference[0]), childThrowingException, (IAppendable)appendable);
                            appendable.append(" ");
                            String exceptionVar = appendable.declareVariable(exceptionType, "exc");
                            appendable.append(exceptionVar).append((CharSequence)") {").increaseIndentation().newLine().append((CharSequence)"throw new RuntimeException(\"auto-generated try/catch\")").decreaseIndentation().newLine().append((CharSequence)"}").closeScope();
                            appendable.commitChanges();
                        }
                    }
                }
            });
        }
    }

    protected XExpression findContainerExpressionInBlockExpression(EObject expr) {
        if (expr == null) {
            return null;
        }
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression) {
            return (XExpression)expr;
        }
        return this.findContainerExpressionInBlockExpression(container);
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath")
    public void putXtendOnClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xtend libs to classpath", "Add Xtend libs to classpath", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = XtendQuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                XtendQuickfixProvider.this.xtendLibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    @Fix(value="org.eclipse.xtend.core.validation.IssueCodes.missing_abstract")
    public void makeClassAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Make class abstract", "Make class abstract", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XtendQuickfixProvider.this.internalDoAddAbstractKeyword(element, context);
            }
        });
    }

    protected void internalDoAddAbstractKeyword(EObject element, IModificationContext context) throws BadLocationException {
        if (element instanceof XtendFunction) {
            element = element.eContainer();
        }
        if (element instanceof XtendClass) {
            XtendClass clazz = (XtendClass)element;
            IXtextDocument document = context.getXtextDocument();
            ICompositeNode clazzNode = NodeModelUtils.findActualNodeFor((EObject)clazz);
            if (clazzNode == null) {
                throw new IllegalStateException("Cannot determine node for clazz " + clazz.getName());
            }
            int offset = -1;
            for (ILeafNode leafNode : clazzNode.getLeafNodes()) {
                if (!leafNode.getText().equals("class")) continue;
                offset = leafNode.getOffset();
            }
            ReplacingAppendable appendable = this.appendableFactory.get(document, (EObject)clazz, offset, 0);
            appendable.append("abstract ");
            appendable.commitChanges();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VariableNameAcceptor
    implements JdtVariableCompletions.CompletionDataAcceptor {
        private final Set<String> notallowed;
        Set<String> variableNames = Sets.newHashSet();

        private VariableNameAcceptor(Set<String> notallowed) {
            this.notallowed = notallowed;
        }

        public void accept(String replaceText, StyledString label, Image img) {
            this.variableNames.add(replaceText);
            this.notallowed.add(replaceText);
        }

        public String getVariableName() {
            ArrayList candidates = Lists.newArrayList(this.variableNames);
            Collections.sort(candidates, new Comparator<String>(){

                @Override
                public int compare(String left, String right) {
                    if (left.length() < right.length()) {
                        return -1;
                    }
                    if (left.length() > right.length()) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (candidates.size() > 0) {
                return (String)candidates.get(0);
            }
            return "";
        }
    }
}

