/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtend.core.resource.DescriptionFlags;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;

public class XtendDescriptionLabelProvider
extends DefaultDescriptionLabelProvider {
    @Inject
    private XtendImages images;
    @Inject
    private DescriptionFlags descriptionFlags;

    public Object image(IEObjectDescription element) {
        EClass eClass = element.getEClass();
        boolean isStatic = this.descriptionFlags.isStatic(element);
        if (eClass == XtendPackage.Literals.XTEND_FILE) {
            return this.images.forFile();
        }
        if (eClass == XtendPackage.Literals.XTEND_IMPORT) {
            return this.images.forImport();
        }
        if (eClass == XtendPackage.Literals.XTEND_CLASS || eClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            return this.images.forClass(JvmVisibility.PUBLIC);
        }
        if (eClass == XtendPackage.Literals.XTEND_FUNCTION) {
            return this.images.forOperation(JvmVisibility.PUBLIC, isStatic);
        }
        if (eClass == XtendPackage.Literals.XTEND_FIELD) {
            return this.images.forField(JvmVisibility.PUBLIC, isStatic, false);
        }
        if (eClass == TypesPackage.Literals.JVM_OPERATION) {
            return this.descriptionFlags.isDispatcherOperation(element) ? this.images.forDispatcherFunction(JvmVisibility.PUBLIC, isStatic) : this.images.forOperation(JvmVisibility.PUBLIC, isStatic);
        }
        return super.image(element);
    }
}

