/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.formatting2;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.ExceptionAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class ContentFormatter
implements IContentFormatter {
    private static final Logger LOG = Logger.getLogger(FormattingUnitOfWork.class);
    @Inject
    private Provider<IFormatter2> formatterProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;
    @Inject
    @FormatterPreferences
    private IPreferenceValuesProvider preferencesProvider;
    @Inject
    private Provider<FormatterRequest> requestProvider;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    protected TextEdit createTextEdit(List<ITextReplacement> replacements) {
        MultiTextEdit mte = new MultiTextEdit();
        for (ITextReplacement tr : replacements) {
            mte.addChild((TextEdit)new ReplaceEdit(tr.getOffset(), tr.getLength(), tr.getReplacementText()));
        }
        return mte;
    }

    protected TextEdit exec(IXtextDocument document, IRegion region, XtextResource resource) throws Exception {
        try {
            IParseResult parseResult = resource.getParseResult();
            if (parseResult != null && parseResult.getRootASTElement() != null) {
                FormatterRequest request = (FormatterRequest)this.requestProvider.get();
                this.initRequest(document, region, resource, request);
                IFormatter2 formatter = (IFormatter2)this.formatterProvider.get();
                List replacements = formatter.format(request);
                TextEdit mte = this.createTextEdit(replacements);
                return mte;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error formatting " + String.valueOf(resource.getURI()) + ": " + e.getMessage()), (Throwable)e);
        }
        return new MultiTextEdit();
    }

    public void format(IDocument document, IRegion region) {
        IXtextDocument doc = this.xtextDocumentUtil.getXtextDocument(document);
        TextEdit r = (TextEdit)doc.priorityReadOnly(new FormattingUnitOfWork(doc, region));
        try {
            if (r != null) {
                r.apply(document);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        return null;
    }

    public IPreferenceValuesProvider getPreferencesProvider() {
        return this.preferencesProvider;
    }

    protected void initRequest(IXtextDocument document, IRegion region, XtextResource resource, FormatterRequest request) {
        TextRegion textRegion = new TextRegion(region.getOffset(), region.getLength());
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        request.setRegions(Collections.singletonList(textRegion));
        ITextRegionAccess tokenAccess = this.regionBuilder.forNodeModel(resource).create();
        IPreferenceValues preferenceValues = this.preferencesProvider.getPreferenceValues((Resource)resource);
        request.setPreferences(TypedPreferenceValues.castOrWrap((IPreferenceValues)preferenceValues));
        request.setTextRegionAccess(tokenAccess);
        if (tokenAccess.hasSyntaxError()) {
            request.setExceptionHandler((IAcceptor)ExceptionAcceptor.IGNORING);
        } else {
            request.setExceptionHandler((IAcceptor)ExceptionAcceptor.LOGGING);
        }
    }

    public void setPreferencesProvider(IPreferenceValuesProvider cfgProvider) {
        this.preferencesProvider = cfgProvider;
    }

    public class FormattingUnitOfWork
    implements IUnitOfWork<TextEdit, XtextResource> {
        private final IXtextDocument document;
        private final IRegion region;

        public FormattingUnitOfWork(IXtextDocument document, IRegion region) {
            this.document = document;
            this.region = region;
        }

        public TextEdit exec(XtextResource state) throws Exception {
            return ContentFormatter.this.exec(this.document, this.region, state);
        }
    }
}

