/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.pages;

import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.actions.FilterTypesAction;
import org.eclipse.papyrus.uml.search.ui.providers.ResultContentProvider;
import org.eclipse.papyrus.uml.search.ui.providers.ResultLabelProvider;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.scope.IScopeEntry;
import org.eclipse.papyrus.views.search.utils.MatchUtils;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.eclipse.uml2.uml.Element;

public class PapyrusSearchResultPage
extends AbstractTextSearchViewPage {
    private static final String ID_VIEW_MODELEXPLORER = "org.eclipse.papyrus.views.modelexplorer.navigation.target";
    ResultContentProvider fContentProvider = null;
    private IAction fFiltertypesAction = null;
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;

    public PapyrusSearchResultPage() {
        super(2);
        this.setElementLimit(1000);
        this.fFiltertypesAction = new FilterTypesAction(this);
    }

    public Match[] getDisplayedMatches(Object element) {
        Set results = MatchUtils.getMatches((AbstractTextSearchResult)this.getInput(), (boolean)true);
        if (element instanceof AbstractResultEntry) {
            AbstractResultEntry resultEntry = (AbstractResultEntry)element;
            if (results.contains(resultEntry)) {
                return new Match[]{resultEntry};
            }
            return new Match[0];
        }
        return super.getDisplayedMatches(element);
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof AbstractResultEntry) {
            AbstractResultEntry resultEntry = (AbstractResultEntry)element;
            Set results = MatchUtils.getMatches((AbstractTextSearchResult)this.getInput(), (boolean)true);
            if (results.contains(resultEntry)) {
                return 1;
            }
            return 0;
        }
        return super.getDisplayedMatchCount(element);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        tbm.appendToGroup("group.removeMatches", this.fFiltertypesAction);
    }

    protected void handleOpen(OpenEvent event) {
        AbstractResultEntry resultEntry;
        IScopeEntry scopeEntry;
        Object firstElement;
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof AbstractResultEntry && (scopeEntry = (IScopeEntry)(resultEntry = (AbstractResultEntry)firstElement).getElement()) != null && scopeEntry.getServicesRegistry() != null) {
            Object source = resultEntry.getSource();
            if (source instanceof Element) {
                try {
                    NavigationService navigationService = (NavigationService)ServiceUtilsForEObject.getInstance().getService(NavigationService.class, (Object)((Element)source));
                    navigationService.navigate(source, ID_VIEW_MODELEXPLORER);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            } else {
                try {
                    OpenElementService service = (OpenElementService)scopeEntry.getServicesRegistry().getService(OpenElementService.class);
                    resultEntry.openElement(service);
                }
                catch (ServiceException service) {
                }
                catch (PartInitException e) {
                    Activator.log.error(Messages.PapyrusSearchResultPage_1, (Throwable)e);
                }
            }
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void evaluateChangedElements(Match[] matches, Set changedElements) {
        int i = 0;
        while (i < matches.length) {
            changedElements.add(matches[i]);
            ++i;
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ResultContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider());
        this.fContentProvider = (ResultContentProvider)viewer.getContentProvider();
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public void dispose() {
        super.dispose();
    }
}

