/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.handler;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.DynamicContribution;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class DynamicDiagramsMenuContribution
extends DynamicContribution {
    public DynamicDiagramsMenuContribution() {
    }

    public DynamicDiagramsMenuContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        final EObject selection = this.getSelection();
        if (selection == null) {
            return new IContributionItem[0];
        }
        ArrayList<ViewPrototype> data = new ArrayList<ViewPrototype>();
        for (ViewPrototype proto : PolicyChecker.getFor((EObject)selection).getPrototypesFor(selection)) {
            if (!(proto.getRepresentationKind() instanceof PapyrusDiagram)) continue;
            data.add(proto);
        }
        Collections.sort(data, new ViewPrototype.Comp());
        ArrayList<String> labels = new ArrayList<String>(data.size());
        String last = null;
        boolean first = true;
        for (ViewPrototype item : data) {
            String label = item.getLabel();
            if (last != null && last.equals(label)) {
                if (first) {
                    labels.set(labels.size() - 1, ((ViewPrototype)data.get(labels.size() - 1)).getFullLabel());
                    first = false;
                }
                labels.add(item.getFullLabel());
                continue;
            }
            labels.add(label);
            last = label;
            first = true;
        }
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(data.size());
        int i = 0;
        while (i != data.size()) {
            final ViewPrototype proto = (ViewPrototype)data.get(i);
            String label = (String)labels.get(i);
            items.add(new ActionContributionItem((IAction)new Action(label, proto.getIconDescriptor()){

                public void run() {
                    proto.instantiateOn(selection);
                }
            }));
            ++i;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }
}

