/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.MetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentSetupParticipant;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.ColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.IQVTColors;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.OverlayPreferenceStore;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingReconciler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

class QVTColorsConfigurationBlock {
    private final String fMain = Messages.ColorConfigBlock_QVTCategory;
    private final Object[] fMainColors;
    private final String fDocumentation = Messages.ColorConfigBlock_DocCategory;
    private final QVTColorManager.ColorDescriptor[] fDocColors;
    private final String fComments = Messages.ColorConfigBlock_CommentsCategory;
    private final Object[] fCommentColors;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private TreeViewer fTreeViewer;
    private FontMetrics fFontMetrics;
    private ColorManager fColorManager;
    private QVTColorManager fQVTColorManager;
    private QvtEditor.SrcViewer fPreviewViewer;
    private List<QVTColorManager.ColorDescriptor> fColorList = new ArrayList<QVTColorManager.ColorDescriptor>();
    private String[] fSyntaxColorListModel = new String[]{IQVTColors.DEFAULT, IQVTColors.KEYWORD, IQVTColors.STRING, IQVTColors.NUMBER, IQVTColors.MODEL_PARAMETER, IQVTColors.RESULT_VARIABLE, IQVTColors.SELF_VARIABLE, IQVTColors.MODULE_ELEMENT, IQVTColors.USER_MODEL_ELEMENT, IQVTColors.STDLIB_ELEMENT, IQVTColors.INTERMEDIATE_DATA, IQVTColors.FATAL_ASSERT};
    private String[] fDocColorListModel = new String[]{IQVTColors.DOC_TAG, IQVTColors.DOC_OTHERS};
    private String[] fCommentColorListModel = new String[]{IQVTColors.MULTILINE_COMMENT, IQVTColors.LINE_COMMENT, IQVTColors.TASK_TAG};
    private IPreferenceStore fStore;

    public QVTColorsConfigurationBlock(OverlayPreferenceStore store) {
        QVTColorManager.ColorDescriptor color;
        String nextKey;
        this.fStore = store;
        this.fColorManager = new ColorManager(false);
        this.fQVTColorManager = new QVTColorManager(this.fStore, this.fColorManager);
        String[] stringArray = this.fSyntaxColorListModel;
        int n = this.fSyntaxColorListModel.length;
        int n2 = 0;
        while (n2 < n) {
            nextKey = stringArray[n2];
            color = this.fQVTColorManager.getColor(nextKey);
            if (color != null) {
                this.fColorList.add(color);
            } else {
                Activator.log(Activator.createStatus(4, "Missing syntax color key: " + nextKey, null));
            }
            ++n2;
        }
        this.fMainColors = this.fColorList.toArray();
        stringArray = this.fCommentColorListModel;
        n = this.fCommentColorListModel.length;
        n2 = 0;
        while (n2 < n) {
            nextKey = stringArray[n2];
            color = this.fQVTColorManager.getColor(nextKey);
            if (color != null) {
                this.fColorList.add(color);
            }
            ++n2;
        }
        this.fCommentColors = this.fColorList.subList(this.fSyntaxColorListModel.length, this.fColorList.size()).toArray(new QVTColorManager.ColorDescriptor[this.fCommentColorListModel.length]);
        stringArray = this.fDocColorListModel;
        n = this.fDocColorListModel.length;
        n2 = 0;
        while (n2 < n) {
            nextKey = stringArray[n2];
            color = this.fQVTColorManager.getColor(nextKey);
            if (color != null) {
                this.fColorList.add(color);
            }
            ++n2;
        }
        this.fDocColors = this.fColorList.subList(this.fSyntaxColorListModel.length + this.fDocColorListModel.length + 1, this.fColorList.size()).toArray(new QVTColorManager.ColorDescriptor[this.fDocColorListModel.length]);
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        int n = this.fColorList.size();
        while (i < n) {
            QVTColorManager.ColorDescriptor item = this.fColorList.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item.canBeDisabled()) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getEnabledKey()));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        return this.createSyntaxPage(parent);
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public void initialize() {
        this.fTreeViewer.setInput(this.fColorList);
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fMain));
    }

    public void performDefaults() {
        this.handleSyntaxColorListSelection();
    }

    public void dispose() {
        this.fQVTColorManager.dispose();
        this.fColorManager.dispose();
    }

    private void handleSyntaxColorListSelection() {
        QVTColorManager.ColorDescriptor item = this.getColorDescriptor();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item.canBeDisabled()) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.getPreferenceStore().getBoolean(item.getEnabledKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Button createCheckBox(Composite composite, String text) {
        Button result = new Button(composite, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, 0).span(2, 1).applyTo((Control)result);
        result.setText(text);
        return result;
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().hint(100, 100).applyTo((Control)colorComposite);
        GridLayoutFactory.fillDefaults().applyTo(colorComposite);
        this.createHeader(colorComposite);
        Label label = new Label(colorComposite, 16384);
        label.setText(Messages.ColorConfigBlock_Element);
        label.setLayoutData((Object)new GridData(768));
        this.createEditorControls(colorComposite);
        label = new Label(colorComposite, 16384);
        label.setText(Messages.ColorConfigBlock_Preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(35);
        gd.heightHint = this.convertHeightInCharsToPixels(25);
        previewer.setLayoutData((Object)gd);
        return colorComposite;
    }

    private void createEditorControls(Composite colorComposite) {
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorComposite);
        this.createViewer(editorComposite);
        this.createSylesControls(editorComposite);
    }

    private void createViewer(Composite editorComposite) {
        this.fTreeViewer = new TreeViewer(editorComposite, 2564);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fTreeViewer.getControl());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fTreeViewer.setAutoExpandLevel(1);
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (QVTColorsConfigurationBlock.this.fMain.equals(element)) {
                    return 0;
                }
                if (QVTColorsConfigurationBlock.this.fDocumentation.equals(element)) {
                    return 1;
                }
                if (QVTColorsConfigurationBlock.this.fComments.equals(element)) {
                    return 2;
                }
                return 0;
            }
        });
        this.installDoubleClickListener();
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QVTColorsConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
    }

    private void createSylesControls(Composite editorComposite) {
        Composite stylesComposite = new Composite(editorComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(stylesComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 1).applyTo((Control)stylesComposite);
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(2, 1).applyTo((Control)this.fEnableCheckbox);
        this.fEnableCheckbox.setText(Messages.ColorConfigBlock_Enable);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, 1).applyTo((Control)this.fColorEditorLabel);
        this.fColorEditorLabel.setText(Messages.ColorConfigBlock_Color);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fSyntaxForegroundColorEditor.getButton());
        this.fBoldCheckBox = this.createCheckBox(stylesComposite, Messages.ColorConfigBlock_FontBold);
        this.fItalicCheckBox = this.createCheckBox(stylesComposite, Messages.ColorConfigBlock_FontItalic);
        this.fStrikethroughCheckBox = this.createCheckBox(stylesComposite, Messages.ColorConfigBlock_FontStrike);
        this.fUnderlineCheckBox = this.createCheckBox(stylesComposite, Messages.ColorConfigBlock_FontUnderLine);
        this.fSyntaxForegroundColorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                PreferenceConverter.setValue((IPreferenceStore)QVTColorsConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)QVTColorsConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                if (item.canBeDisabled()) {
                    boolean enable = QVTColorsConfigurationBlock.this.fEnableCheckbox.getSelection();
                    QVTColorsConfigurationBlock.this.getPreferenceStore().setValue(item.getEnabledKey(), enable);
                    QVTColorsConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    QVTColorsConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    QVTColorsConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    QVTColorsConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    QVTColorsConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    QVTColorsConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    QVTColorsConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                }
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                QVTColorsConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), QVTColorsConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                QVTColorsConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), QVTColorsConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                QVTColorsConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), QVTColorsConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QVTColorManager.ColorDescriptor item = QVTColorsConfigurationBlock.this.getColorDescriptor();
                QVTColorsConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), QVTColorsConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
    }

    private void createHeader(final Composite colorComposite) {
        Link link = new Link(colorComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).applyTo((Control)link);
        link.setText(Messages.ColorConfigBlock_PageMainText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)colorComposite.getShell(), (String)e.text, null, null);
            }
        });
        this.addFiller(colorComposite, 1);
    }

    private void installDoubleClickListener() {
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (QVTColorsConfigurationBlock.this.fTreeViewer.isExpandable(element)) {
                    QVTColorsConfigurationBlock.this.fTreeViewer.setExpandedState(element, !QVTColorsConfigurationBlock.this.fTreeViewer.getExpandedState(element));
                }
            }
        });
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private QVTColorManager.ColorDescriptor getColorDescriptor() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (QVTColorManager.ColorDescriptor)element;
    }

    private void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private Control createPreviewer(Composite parent) {
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), Activator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()});
        this.fPreviewViewer = new QvtEditor.SrcViewer(parent, null, null, false, 2816);
        QvtConfiguration configuration = new QvtConfiguration(this.fQVTColorManager, (IPreferenceStore)store);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.fPreviewViewer.setEditable(false);
        this.fPreviewViewer.getTextWidget().setCursor(this.fPreviewViewer.getTextWidget().getDisplay().getSystemCursor(0));
        this.fPreviewViewer.getTextWidget().setCaret(null);
        URI uri = URI.createPlatformPluginURI((String)"/org.eclipse.m2m.qvt.oml.editor.ui/preview/ColorSettingPreviewCode.qvto", (boolean)true);
        IDocument document = this.createPreviewDocument(uri);
        new QvtDocumentSetupParticipant().setup(document);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.setDocument(document);
        UnitProxy findUnit = UnitResolverFactory.Registry.INSTANCE.getUnit(uri);
        assert (findUnit != null);
        try {
            QVTOCompiler compiler = new QVTOCompiler((IMetamodelRegistryProvider)new MetamodelRegistryProvider());
            final CompiledUnit compiledPreviewUnit = compiler.compile(findUnit, new QvtCompilerOptions(), null);
            SemanticHighlightingManager semanticHighlightingManager = new SemanticHighlightingManager(){

                protected SemanticHighlightingReconciler createReconciler() {
                    return new SemanticHighlightingReconciler(){

                        protected CompiledUnit getModel() {
                            return compiledPreviewUnit;
                        }
                    };
                }
            };
            semanticHighlightingManager.install(this.fPreviewViewer, this.fQVTColorManager, (IPreferenceStore)store);
            semanticHighlightingManager.getReconciler().reconciled(compiledPreviewUnit, (IProgressMonitor)new NullProgressMonitor());
            this.fPreviewViewer.invalidateTextPresentation();
            this.hookPreviewUpdater((SourceViewer)this.fPreviewViewer, (IPreferenceStore)store, this.fQVTColorManager);
        }
        catch (MdaException e) {
            Activator.log(e);
        }
        return this.fPreviewViewer.getControl();
    }

    private void hookPreviewUpdater(final SourceViewer viewer, final IPreferenceStore preferenceStore, final QVTColorManager colorManager) {
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jface.textfont")) {
                    Font font = JFaceResources.getTextFont();
                    viewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                colorManager.propertyChange(event);
                viewer.invalidateTextPresentation();
            }
        };
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                preferenceStore.removePropertyChangeListener(propertyChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
    }

    private IDocument createPreviewDocument(URI uri) {
        StringWriter wr = new StringWriter();
        try {
            InputStream is = URIConverter.INSTANCE.createInputStream(uri);
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(is));
            int c = 0;
            while ((c = reader.read()) != -1) {
                wr.write((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(wr));
        }
        return new Document(wr.getBuffer().toString());
    }

    protected final IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new String[]{QVTColorsConfigurationBlock.this.fMain, QVTColorsConfigurationBlock.this.fDocumentation, QVTColorsConfigurationBlock.this.fComments};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                if (QVTColorsConfigurationBlock.this.fMain.equals(entry)) {
                    return QVTColorsConfigurationBlock.this.fMainColors;
                }
                if (QVTColorsConfigurationBlock.this.fComments.equals(entry)) {
                    return QVTColorsConfigurationBlock.this.fCommentColors;
                }
                if (QVTColorsConfigurationBlock.this.fDocumentation.equals(entry)) {
                    return QVTColorsConfigurationBlock.this.fDocColors;
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (QVTColorsConfigurationBlock.this.fColorList.indexOf(element) < QVTColorsConfigurationBlock.this.fSyntaxColorListModel.length) {
                return QVTColorsConfigurationBlock.this.fMain;
            }
            return QVTColorsConfigurationBlock.this.fComments;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((QVTColorManager.ColorDescriptor)element).getDisplayName();
        }
    }

    static class PixelConverter {
        private final FontMetrics fFontMetrics;

        public PixelConverter(Control control) {
            this(control.getFont());
        }

        public PixelConverter(Font font) {
            GC gc = new GC((Drawable)font.getDevice());
            gc.setFont(font);
            this.fFontMetrics = gc.getFontMetrics();
            gc.dispose();
        }

        public int convertHeightInCharsToPixels(int chars) {
            return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertVerticalDLUsToPixels(int dlus) {
            return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
    }
}

