/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.project.CompiledTransformation;
import org.eclipse.m2m.internal.qvt.oml.common.project.Pair;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformationRegistry {
    public static final Filter EMPTY_FILTER = new Filter(){

        public boolean accept(IConfigurationElement element) {
            return true;
        }
    };
    public static final Filter TRANSFORMATION_FILTER = new Filter(){

        public boolean accept(IConfigurationElement element) {
            return "transformation".equals(element.getName());
        }
    };
    private final String myPoint;

    protected TransformationRegistry(String point) {
        this.myPoint = point;
    }

    public List<CompiledTransformation> getTransformations(Filter filter) {
        ArrayList<CompiledTransformation> transformations = new ArrayList<CompiledTransformation>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.myPoint);
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            try {
                if (filter == null || filter.accept(element)) {
                    CompiledTransformation transformation = this.makeTransformation(element);
                    transformations.add(transformation);
                }
            }
            catch (MdaException e) {
                Logger.getLogger().log(Logger.SEVERE, "Failed to parse extension " + element, e);
            }
            ++i;
        }
        return transformations;
    }

    public CompiledTransformation getSingleTransformationById(final String id) {
        List<CompiledTransformation> transformations = this.getTransformations(new Filter(){

            public boolean accept(IConfigurationElement element) {
                return id.equals(element.getAttribute("id"));
            }
        });
        return transformations.isEmpty() ? null : transformations.get(0);
    }

    @Deprecated
    public List<CompiledTransformation> getTransformationsByInput(EClass input) {
        return this.getTransformations(new InputFilter(input));
    }

    public List<CompiledTransformation> getTransformations() {
        return this.getTransformations(null);
    }

    protected abstract CompiledTransformation makeTransformation(IConfigurationElement var1) throws MdaException;

    protected static EClass getEClassElement(IConfigurationElement parent, String name) throws MdaException {
        Pair<String, String> eCl = TransformationRegistry.parseEClassElement(parent, name);
        return TransformationRegistry.getEClassElement(eCl.getFirst(), eCl.getSecond());
    }

    private static Pair<String, String> parseEClassElement(IConfigurationElement parent, String name) throws MdaException, InvalidRegistryObjectException {
        IConfigurationElement elem = TransformationRegistry.getSingleElement(parent, name);
        String metamodel = elem.getAttribute("metamodel");
        if (metamodel == null) {
            throw new MdaException(NLS.bind((String)Messages.TransformationRegistry_MissingMetamodelAttr, (Object)parent));
        }
        String metaclass = elem.getAttribute("metaclass");
        if (metaclass == null) {
            throw new MdaException(NLS.bind((String)Messages.TransformationRegistry_MissingMetaclassAttr, (Object)parent));
        }
        return new Pair<String, String>(metamodel, metaclass);
    }

    private static boolean checkEClassElement(IConfigurationElement parent, String name, EClass eClass) throws MdaException {
        Pair<String, String> eCl = TransformationRegistry.parseEClassElement(parent, name);
        String metamodel = eCl.getFirst();
        String metaclass = eCl.getSecond();
        String[] components = metaclass.split("/");
        if (components[components.length - 1].equals(eClass.getName())) {
            EPackage ePack = eClass.getEPackage();
            int pack = components.length - 2;
            while (pack >= 0) {
                if (ePack == null) {
                    return false;
                }
                if (!components[pack].equals(ePack.getName())) {
                    return false;
                }
                if (pack == 0) {
                    return metamodel.equals(ePack.getNsURI());
                }
                ePack = ePack.getESuperPackage();
                --pack;
            }
        }
        return false;
    }

    private static EClass getEClassElement(String metamodel, String metaclass) throws MdaException {
        EPackage pack = EPackage.Registry.INSTANCE.getEPackage(metamodel);
        if (pack == null) {
            throw new MdaException(NLS.bind((String)Messages.TransformationRegistry_UnknownMetamodel, (Object)metamodel));
        }
        String[] components = metaclass.split("/");
        try {
            EClass cls = EmfUtil.getEClass((EPackage)pack, (String[])components);
            return cls;
        }
        catch (EmfException e) {
            throw new MdaException(e);
        }
    }

    private static IConfigurationElement getSingleElement(IConfigurationElement parent, String name) throws MdaException {
        IConfigurationElement[] elems = parent.getChildren(name);
        if (elems == null || elems.length == 0) {
            throw new MdaException(NLS.bind((String)Messages.TransformationRegistry_NoElements, (Object)name, (Object)parent));
        }
        return elems[0];
    }

    public static interface Filter {
        public boolean accept(IConfigurationElement var1);
    }

    @Deprecated
    public static class InputFilter
    implements Filter {
        private List<EClass> myInput = new ArrayList<EClass>();

        @Deprecated
        public InputFilter(EClass input) {
            this.myInput.add(input);
            this.myInput.addAll((Collection<EClass>)input.getEAllSuperTypes());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean accept(IConfigurationElement element) {
            try {
                EClass cl;
                if (element.getChildren("input").length == 0) {
                    return false;
                }
                Iterator<EClass> iterator = this.myInput.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!TransformationRegistry.checkEClassElement(element, "input", cl = iterator.next()));
                return true;
            }
            catch (MdaException e) {
                return false;
            }
        }
    }
}

