/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilationUnitDescriptor {
    public static final String URI_SCHEME = "qvto";
    public static final String URI_AUTHORITY = "blackbox";
    private URI fURI;
    private String fQualifiedName;
    private String fDescription;
    private AbstractBlackboxProvider fProvider;

    protected AbstractCompilationUnitDescriptor(AbstractBlackboxProvider provider, String qualifiedName, String ... uriSegments) {
        if (provider == null || qualifiedName == null) {
            throw new IllegalArgumentException("null 'qualified name' or 'provider'");
        }
        if (uriSegments == null || uriSegments.length == 0) {
            throw new IllegalArgumentException("Invalid unit uri segments");
        }
        this.fProvider = provider;
        this.fQualifiedName = qualifiedName;
        this.fURI = URI.createHierarchicalURI((String)URI_SCHEME, (String)URI_AUTHORITY, null, (String[])uriSegments, null, null);
    }

    protected AbstractCompilationUnitDescriptor(AbstractBlackboxProvider provider, String qualifiedName) {
        this(provider, qualifiedName, qualifiedName);
    }

    protected AbstractBlackboxProvider getProvider() {
        return this.fProvider;
    }

    protected void setDescription(String description) {
        this.fDescription = description;
    }

    public final URI getURI() {
        return this.fURI;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getQualifiedName() {
        return this.fQualifiedName;
    }

    public String toString() {
        return "Descriptor: " + this.fQualifiedName + " - " + this.getProvider().toString();
    }

    public abstract Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation var1, QvtOperationalModuleEnv var2);

    public abstract Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation var1, QvtOperationalModuleEnv var2);
}

