/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.QvtRuntimePlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtLaunchUtil {
    private QvtLaunchUtil() {
    }

    public static ILaunchConfigurationType getInMemoryLaunchConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation");
        if (type == null) {
            throw new RuntimeException("No launch configuration for id org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation");
        }
        return type;
    }

    public static List<TargetUriData> getTargetUris(ILaunchConfiguration configuration) throws CoreException {
        int elemCount = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", 0);
        ArrayList<TargetUriData> targetUris = new ArrayList<TargetUriData>(elemCount);
        int i = 0;
        while (i < elemCount) {
            TargetUriData targetData = QvtLaunchUtil.getTargetUriData(configuration, i + 1);
            targetUris.add(targetData);
            ++i;
        }
        return targetUris;
    }

    public static String getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", null);
    }

    public static String getTraceFileURI(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", null);
    }

    public static boolean shouldGenerateTraceFile(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
    }

    public static TargetUriData getTargetUriData(ILaunchConfiguration configuration, int index) throws CoreException {
        TargetUriData.TargetType targetType = TargetUriData.TargetType.NEW_MODEL;
        try {
            targetType = TargetUriData.TargetType.valueOf((String)configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetType", index), "NEW_MODEL"));
        }
        catch (Exception e) {
            targetType = TargetUriData.TargetType.NEW_MODEL;
        }
        String uri = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetModel", index), "");
        String feature = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.featureName", index), "");
        boolean clearContents = configuration.getAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.clearContents", index), true);
        return new TargetUriData(targetType, uri, feature, clearContents);
    }

    public static void saveTargetUriData(ILaunchConfigurationWorkingCopy configuration, List<TargetUriData> targetData) {
        int index = 1;
        for (TargetUriData targetUri : targetData) {
            QvtLaunchUtil.saveTargetUriData(configuration, targetUri, index);
            ++index;
        }
    }

    public static void saveTargetUriData(ILaunchConfigurationWorkingCopy configuration, TargetUriData targetData, int index) {
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetType", index), targetData.getTargetType().toString());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.targetModel", index), targetData.getUriString());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.featureName", index), targetData.getFeature());
        configuration.setAttribute(QvtLaunchUtil.getIndexedName("org.eclipse.m2m.qvt.oml.interpreter.clearContents", index), targetData.isClearContents());
    }

    public static String getTraceFileName(URI uri) {
        IFile file = URIUtils.getFile((URI)uri);
        if (file == null) {
            return null;
        }
        Path traceFilePath = new Path(file.getParent().getFullPath() + "/" + file.getName() + ".qvtotrace");
        return URI.createPlatformResourceURI((String)traceFilePath.toOSString().toString(), (boolean)false).toString();
    }

    public static Map<String, Object> getConfigurationProperty(ILaunchConfiguration configuration) {
        return QvtLaunchUtil.loadConfigurationProperties(configuration);
    }

    public static Context createContext(ILaunchConfiguration configuration) {
        Map<String, Object> configProps = QvtLaunchUtil.getConfigurationProperty(configuration);
        return QvtLaunchUtil.createContext(configProps);
    }

    public static Context createContext(Map<String, Object> configProps) {
        Context context = new Context();
        if (configProps != null) {
            for (String name : configProps.keySet()) {
                context.setConfigProperty(name, configProps.get(name));
            }
        }
        return context;
    }

    public static Map<String, Object> loadConfigurationProperties(ILaunchConfiguration configuration) {
        Map<String, Object> map;
        try {
            Map configProps = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", Collections.emptyMap());
            map = new LinkedHashMap(configProps);
        }
        catch (CoreException e) {
            map = Collections.emptyMap();
            QvtRuntimePlugin.getDefault().getLog().log(MiscUtil.makeErrorStatus((Exception)((Object)e)));
        }
        return map;
    }

    private static String getIndexedName(String name, int index) {
        if (index == 0) {
            return name;
        }
        return String.valueOf(name) + index;
    }
}

