/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugElement;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMEventListener;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResumeRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMSuspendEvent;

public class QVTOThread
extends QVTODebugElement
implements IThread,
VMEventListener {
    private List<QVTOStackFrame> fFrames = new ArrayList<QVTOStackFrame>();
    private List<VMStackFrame> fUnderlyingFrames;
    private VMStackFrame fLastSuspendedFrame;
    private boolean fIsStepping = false;

    public QVTOThread(IQVTODebugTarget target) {
        super(target);
        target.addVMEventListener(this);
        this.fireCreationEvent();
    }

    public boolean isDeferredExecution() {
        return false;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.fFrames.size() == 0) {
            this.fillFrames();
        }
        return this.fFrames.toArray(new QVTOStackFrame[this.fFrames.size()]);
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (!this.hasStackFrames()) {
            return null;
        }
        IStackFrame[] frames = this.getStackFrames();
        return frames.length > 0 ? frames[0] : null;
    }

    public String getName() throws DebugException {
        return "QVTOThread";
    }

    public IBreakpoint[] getBreakpoints() {
        IBreakpoint[] hostBreakpoints = new IBreakpoint[]{};
        return hostBreakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().resume();
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(1);
        this.getQVTODebugTarget().sendRequest(new VMResumeRequest(1));
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(2);
        this.getQVTODebugTarget().sendRequest(new VMResumeRequest(2));
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(4);
        this.getQVTODebugTarget().sendRequest(new VMResumeRequest(4));
    }

    public boolean isStepping() {
        return this.fIsStepping;
    }

    private void setStepping(boolean isStepping) {
        this.fIsStepping = isStepping;
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
        this.fFrames.clear();
    }

    public void handleEvent(VMEvent event) {
        if (event instanceof VMSuspendEvent) {
            VMSuspendEvent suspendEvent = (VMSuspendEvent)event;
            if (!this.isStepping()) {
                this.fFrames.clear();
            } else {
                VMStackFrame suspendedAtLocation = suspendEvent.stackFrames[0];
                if (this.fLastSuspendedFrame != null && suspendedAtLocation != null && suspendedAtLocation.id == this.fLastSuspendedFrame.id && !this.fFrames.isEmpty()) {
                    this.fFrames.get(0).setLocation(suspendedAtLocation);
                } else {
                    this.fFrames.clear();
                }
            }
            this.fUnderlyingFrames = Arrays.asList(suspendEvent.stackFrames);
            this.setStepping(false);
            DebugEvent debugEvent = new DebugEvent((Object)this, 2, suspendEvent.detail);
            debugEvent.setData((Object)suspendEvent.location);
            this.fireEvent(debugEvent);
        }
    }

    private void fillFrames() {
        if (this.fUnderlyingFrames == null) {
            return;
        }
        for (VMStackFrame frame : this.fUnderlyingFrames) {
            this.fFrames.add(new QVTOStackFrame(this, frame));
        }
        if (!this.fUnderlyingFrames.isEmpty()) {
            this.fLastSuspendedFrame = this.fUnderlyingFrames.get(0);
        }
    }
}

