/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.emf.ExtendedEmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TraceUtil;
import org.eclipse.m2m.internal.qvt.oml.trace.EValue;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;
import org.eclipse.osgi.util.NLS;

public class TraceSerializer {
    private final Trace myTrace;
    private final List<EObject> myUnboundObjects;

    public TraceSerializer(Trace trace) {
        this.myTrace = trace;
        this.myUnboundObjects = new ArrayList<EObject>(1);
        this.patch(this.myTrace);
    }

    public void saveTraceModel(URI traceUri) throws MdaException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        ExtendedEmfUtil.saveModel((EObject)this.myTrace, (URI)traceUri, options);
    }

    public void markUnboundObjects(URI traceUri) throws CoreException {
        IFile ifile = URIUtils.getFile((URI)traceUri);
        if (ifile == null) {
            return;
        }
        ifile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        for (EObject eObj : this.myUnboundObjects) {
            this.createQvtMarker((IResource)ifile, eObj);
        }
    }

    private void createQvtMarker(IResource iresource, EObject eObj) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", NLS.bind((String)"Trace contains unbounded object of type ''{0}''", (Object)QvtOperationalTypesUtil.getTypeFullName((EClassifier)eObj.eClass())));
        attributes.put("severity", 1);
        URI uri = EcoreUtil.getURI((EObject)eObj);
        if (uri != null) {
            attributes.put("uri", uri.fragment());
        }
        try {
            IMarker marker = iresource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.WARNING, "TraceSerializer: failed to create marker", e);
        }
    }

    private Trace patch(Trace trace) {
        for (TraceRecord traceRecord : trace.getTraceRecords()) {
            VarParameterValue context = traceRecord.getContext().getContext();
            if (context != null) {
                this.patch(context.getValue());
            }
            for (VarParameterValue param : traceRecord.getParameters().getParameters()) {
                this.patch(param.getValue());
            }
            for (VarParameterValue result : traceRecord.getResult().getResult()) {
                this.updateResult(result);
                this.patch(result.getValue());
            }
        }
        return trace;
    }

    private void updateResult(VarParameterValue varParamValue) {
        if (varParamValue.getValue() != null) {
            varParamValue.setValue(TraceUtil.createEValue((Object)varParamValue.getValue().getOclObject()));
        }
    }

    private void patch(EValue eValue) {
        if (eValue != null) {
            EObject modelElement = eValue.getModelElement();
            if (modelElement != null) {
                if (modelElement.eResource() == null && modelElement.eContainer() == null && !IntermediateClassFactory.isIntermediateClass((EClassifier)modelElement.eClass())) {
                    eValue.setIntermediateElement(modelElement);
                    this.myUnboundObjects.add(modelElement);
                }
            } else {
                for (EValue collectionElement : eValue.getCollection()) {
                    this.patch(collectionElement);
                }
            }
        }
    }
}

