/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResourceRepositoryContext;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.EPackageRegistryBasedURIResourceMap;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;

public class CompilerUtils {
    public static Diagnostic createProblemDiagnostic(URI uri, QvtMessage problem) {
        int qvtSeverity = problem.getSeverity();
        int diagnosticSeverity = qvtSeverity == 2 ? 4 : 2;
        String source = uri.toString();
        String message = problem.getMessage();
        if (problem.getLineNum() >= 0) {
            message = String.valueOf(message) + " (at:" + problem.getLineNum() + ")";
        }
        return new BasicDiagnostic(diagnosticSeverity, source, 0, message, null);
    }

    public static Diagnostic createUnitProblemDiagnostic(CompiledUnit unit) {
        if (unit.getProblems().isEmpty()) {
            return Diagnostic.OK_INSTANCE;
        }
        URI uri = unit.getURI();
        List<QvtMessage> problems = unit.getProblems();
        ArrayList<Diagnostic> children = new ArrayList<Diagnostic>(problems.size());
        int errorCount = 0;
        int warnCount = 0;
        for (QvtMessage problem : unit.getProblems()) {
            if (problem.getSeverity() == 2) {
                ++errorCount;
            } else if (problem.getSeverity() == 1) {
                ++warnCount;
            }
            children.add(CompilerUtils.createProblemDiagnostic(uri, problem));
        }
        String mainMessage = NLS.bind(CompilerMessages.unitDiagnostic, errorCount, warnCount);
        BasicDiagnostic unitDiagnostic = new BasicDiagnostic(uri.toString(), 0, children, mainMessage, null);
        return unitDiagnostic;
    }

    public static Monitor createMonitor(Monitor monitor, int ticks) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return Eclipse.createMonitor(monitor, ticks);
        }
        return monitor;
    }

    public static void throwOperationCanceled() throws RuntimeException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            throw new RuntimeException("Operation canceled");
        }
        Eclipse.throwOperationCanceled();
    }

    public static Monitor createNullMonitor() {
        return new BasicMonitor();
    }

    static EPackage.Registry getEPackageRegistry(URI context, IMetamodelRegistryProvider metamodelRegistryProvider) {
        MetamodelRegistry metamodelRegistry = metamodelRegistryProvider.getRegistry((IMetamodelRegistryProvider.IRepositoryContext)new CResourceRepositoryContext(context));
        Object packageRegistry = metamodelRegistry != null ? metamodelRegistry.toEPackageRegistry() : new EPackageRegistryImpl();
        return packageRegistry;
    }

    static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIResourceMap((Map)new EPackageRegistryBasedURIResourceMap(resourceSet.getURIConverter()));
        return resourceSet;
    }

    public static QVTOCompiler createCompiler() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return Eclipse.createCompiler();
        }
        return QVTOCompiler.createCompiler(EPackage.Registry.INSTANCE);
    }

    static class Eclipse {
        Eclipse() {
        }

        static QVTOCompiler createCompiler() {
            return new QVTOCompiler((IMetamodelRegistryProvider)new WorkspaceMetamodelRegistryProvider(CompilerUtils.createResourceSet()));
        }

        static Monitor createMonitor(Monitor monitor, int ticks) {
            return new BasicMonitor.EclipseSubProgress(BasicMonitor.toIProgressMonitor((Monitor)monitor), ticks, 4);
        }

        static void throwOperationCanceled() throws RuntimeException {
            throw new OperationCanceledException();
        }

        static WorkspaceMetamodelRegistryProvider createMetamodelRegistryProvider(ResourceSet metamodelResourceSet) {
            return metamodelResourceSet != null ? new WorkspaceMetamodelRegistryProvider(metamodelResourceSet) : new WorkspaceMetamodelRegistryProvider();
        }

        static WorkspaceMetamodelRegistryProvider createMetamodelRegistryProvider(EPackage.Registry packageRegistry, ResourceSet metamodelResourceSet) {
            return new WorkspaceMetamodelRegistryProvider(metamodelResourceSet, packageRegistry){
                IMetamodelProvider registry;
                {
                    this.registry = new EmfStandaloneMetamodelProvider(registry);
                }

                public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
                    MetamodelRegistry result = super.getRegistry(context);
                    if (result == MetamodelRegistry.getInstance()) {
                        result = new MetamodelRegistry(this.registry);
                    } else if (result != null) {
                        MetamodelRegistry customRegistry = new MetamodelRegistry(this.registry);
                        customRegistry.merge(result);
                        result = customRegistry;
                    }
                    return result;
                }
            };
        }
    }
}

