/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ImageInstanceDescriptor {
    private String imageName = "";
    private String imageTag = "";
    private String imageId = "";
    private String imageAuthor = "";
    private String imageArch = "";
    private long imageSize = 0L;
    private Map<String, String> imageLabels = new HashMap<String, String>();

    private ImageInstanceDescriptor() {
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImageAuthor() {
        return this.imageAuthor;
    }

    public String getImageArch() {
        return this.imageArch;
    }

    public long getImageSize() {
        return this.imageSize;
    }

    public Map<String, String> getImageLabels() {
        return this.imageLabels;
    }

    public static ImageInstanceDescriptorBuilder builder() {
        return new ImageInstanceDescriptorBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.imageName, this.imageTag, this.imageId, this.imageAuthor, this.imageArch, this.imageSize, this.imageLabels);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImageInstanceDescriptor)) {
            return false;
        }
        ImageInstanceDescriptor other = (ImageInstanceDescriptor)obj;
        return Objects.equals(this.imageName, other.imageName) && Objects.equals(this.imageTag, other.imageTag) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.imageAuthor, other.imageAuthor) && Objects.equals(this.imageArch, other.imageArch) && Objects.equals(this.imageSize, other.imageSize) && Objects.equals(this.imageLabels, other.imageLabels);
    }

    /* synthetic */ ImageInstanceDescriptor(ImageInstanceDescriptor imageInstanceDescriptor) {
        this();
    }

    public static final class ImageInstanceDescriptorBuilder {
        private String imageName;
        private String imageTag;
        private String imageId;
        private String imageAuthor;
        private String imageArch;
        private long imageSize;
        private Map<String, String> imageLabels = new HashMap<String, String>();

        public ImageInstanceDescriptorBuilder setImageName(String imageName) {
            this.imageName = this.nullToEmpty(imageName);
            return this;
        }

        public ImageInstanceDescriptorBuilder setImageTag(String imageTag) {
            this.imageTag = this.nullToEmpty(imageTag);
            return this;
        }

        public ImageInstanceDescriptorBuilder setImageId(String imageId) {
            this.imageId = this.nullToEmpty(imageId);
            return this;
        }

        public ImageInstanceDescriptorBuilder setImageAuthor(String imageAuthor) {
            this.imageAuthor = this.nullToEmpty(imageAuthor);
            return this;
        }

        public ImageInstanceDescriptorBuilder setImageArch(String imageArch) {
            this.imageArch = this.nullToEmpty(imageArch);
            return this;
        }

        public ImageInstanceDescriptorBuilder setimageSize(long imageSize) {
            this.imageSize = imageSize;
            return this;
        }

        public ImageInstanceDescriptorBuilder setImageLabels(Map<String, String> imageLabels) {
            this.imageLabels = imageLabels;
            return this;
        }

        public ImageInstanceDescriptor build() {
            ImageInstanceDescriptor result = new ImageInstanceDescriptor(null);
            result.imageName = this.imageName;
            result.imageTag = this.imageTag;
            result.imageId = Objects.requireNonNull(this.imageId, "Image ID cannot be null");
            result.imageAuthor = this.imageAuthor;
            result.imageArch = this.imageArch;
            result.imageSize = this.imageSize;
            result.imageLabels = Objects.requireNonNull(this.imageLabels, "ImageLabels must not be null");
            return result;
        }

        private String nullToEmpty(String input) {
            if (input == null) {
                return "";
            }
            return input;
        }
    }
}

