/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.eclipse.kura.camel.cloud.KuraCloudComponent;
import org.eclipse.kura.camel.runner.BeforeStart;
import org.eclipse.kura.camel.runner.BuilderRoutesProvider;
import org.eclipse.kura.camel.runner.ContextFactory;
import org.eclipse.kura.camel.runner.ContextLifecycleListener;
import org.eclipse.kura.camel.runner.DefaultServiceDependency;
import org.eclipse.kura.camel.runner.DependencyRunner;
import org.eclipse.kura.camel.runner.EmptyRoutesProvider;
import org.eclipse.kura.camel.runner.RegistryFactory;
import org.eclipse.kura.camel.runner.RoutesProvider;
import org.eclipse.kura.camel.runner.ServiceConsumer;
import org.eclipse.kura.camel.runner.ServiceDependency;
import org.eclipse.kura.camel.runner.SimpleRoutesProvider;
import org.eclipse.kura.camel.runner.XmlRoutesProvider;
import org.eclipse.kura.cloud.CloudService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRunner {
    private static final Logger logger = LoggerFactory.getLogger(CamelRunner.class);
    private final RegistryFactory registryFactory;
    private final ContextFactory contextFactory;
    private final List<BeforeStart> beforeStarts;
    private final List<ContextLifecycleListener> lifecycleListeners;
    private final List<ServiceDependency<?, CamelContext>> dependencies;
    private CamelContext context;
    private RoutesProvider routes = EmptyRoutesProvider.INSTANCE;
    private DependencyRunner<CamelContext> dependencyRunner;

    public static ContextFactory createOsgiFactory(BundleContext bundleContext) {
        Objects.requireNonNull(bundleContext);
        return registry -> new OsgiDefaultCamelContext(bundleContext, registry);
    }

    public static RegistryFactory createOsgiRegistry(BundleContext bundleContext) {
        Objects.requireNonNull(bundleContext);
        return () -> new OsgiServiceRegistry(bundleContext);
    }

    public static RegistryFactory createOsgiRegistry(BundleContext bundleContext, Map<String, Object> services) {
        Objects.requireNonNull(bundleContext);
        if (services == null || services.isEmpty()) {
            return CamelRunner.createOsgiRegistry(bundleContext);
        }
        return () -> {
            LinkedList<Object> registries = new LinkedList<Object>();
            SimpleRegistry simple = new SimpleRegistry();
            simple.putAll(services);
            registries.add(simple);
            registries.add(new OsgiServiceRegistry(bundleContext));
            return new CompositeRegistry(registries);
        };
    }

    private CamelRunner(RegistryFactory registryFactory, ContextFactory contextFactory, List<BeforeStart> beforeStarts, List<ContextLifecycleListener> lifecycleListeners, List<ServiceDependency<?, CamelContext>> dependencies) {
        this.registryFactory = registryFactory;
        this.contextFactory = contextFactory;
        this.beforeStarts = beforeStarts;
        this.lifecycleListeners = lifecycleListeners;
        this.dependencies = dependencies;
    }

    private Registry createRegistry() {
        return this.registryFactory.createRegistry();
    }

    private CamelContext createContext(Registry registry) {
        return this.contextFactory.createContext(registry);
    }

    public void start() {
        this.stop();
        logger.info("Starting...");
        this.dependencyRunner = new DependencyRunner<CamelContext>(this.dependencies, new DependencyRunner.Listener<CamelContext>(){

            @Override
            public void ready(List<ServiceDependency.Handle<CamelContext>> dependencies) {
                try {
                    CamelRunner.this.startCamel(dependencies);
                }
                catch (Exception e) {
                    logger.warn("Failed to start context", (Throwable)e);
                }
            }

            @Override
            public void notReady() {
                try {
                    CamelRunner.this.stopCamel();
                }
                catch (Exception e) {
                    logger.warn("Failed to stop context", (Throwable)e);
                }
            }
        });
        this.dependencyRunner.start();
    }

    public void stop() {
        if (this.dependencyRunner != null) {
            logger.info("Stopping...");
            this.dependencyRunner.stop();
            this.dependencyRunner = null;
        }
    }

    protected void startCamel(List<ServiceDependency.Handle<CamelContext>> dependencies) throws Exception {
        if (this.context != null) {
            logger.warn("Camel already running");
            return;
        }
        Registry registry = this.createRegistry();
        CamelContext camelContext = this.createContext(registry);
        this.beforeStart(camelContext);
        for (ServiceDependency.Handle<CamelContext> dep : dependencies) {
            dep.consume(camelContext);
        }
        this.context = camelContext;
        this.routes.applyRoutes(this.context);
        this.context.start();
        this.fireLifecycle(this.context, (ThrowingBiConsumer<ContextLifecycleListener, CamelContext, Exception>)((ThrowingBiConsumer)ContextLifecycleListener::started));
    }

    protected void stopCamel() throws Exception {
        if (this.context != null) {
            this.fireLifecycle(this.context, (ThrowingBiConsumer<ContextLifecycleListener, CamelContext, Exception>)((ThrowingBiConsumer)ContextLifecycleListener::stopping));
            this.context.stop();
            this.context = null;
        }
    }

    private void beforeStart(CamelContext context) throws Exception {
        logger.debug("Running before starts...");
        for (BeforeStart beforeStart : this.beforeStarts) {
            beforeStart.beforeStart(context);
        }
    }

    private void fireLifecycle(CamelContext context, ThrowingBiConsumer<ContextLifecycleListener, CamelContext, Exception> consumer) {
        for (ContextLifecycleListener listener : this.lifecycleListeners) {
            try {
                consumer.accept((Object)listener, (Object)context);
            }
            catch (Exception e) {
                logger.warn("Failed to call listener", (Throwable)e);
            }
        }
    }

    public static void removeRoutes(CamelContext context, Set<String> removedRouteIds) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(removedRouteIds);
        for (String id : removedRouteIds) {
            try {
                logger.debug("Stopping route: {}", (Object)id);
                context.stopRoute(id);
                logger.debug("Removing route: {}", (Object)id);
                context.removeRoute(id);
            }
            catch (Exception e) {
                logger.warn("Failed to remove route: {}", (Object)id, (Object)e);
            }
        }
    }

    public static void removeMissingRoutes(CamelContext context, Collection<RouteDefinition> routes) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(routes);
        Set<String> newRouteIds = CamelRunner.fromDefs(routes);
        HashSet<String> removedRouteIds = new HashSet<String>(CamelRunner.fromRoutes(context.getRoutes()));
        removedRouteIds.removeAll(newRouteIds);
        CamelRunner.removeRoutes(context, removedRouteIds);
    }

    public static void removeAllRoutes(CamelContext context) {
        Objects.requireNonNull(context);
        CamelRunner.removeRoutes(context, CamelRunner.fromDefs(context.getRouteDefinitions()));
    }

    public void clearRoutes() {
        this.setRoutes(EmptyRoutesProvider.INSTANCE);
    }

    public void setRoutes(RoutesProvider routes) {
        if (routes == null) {
            this.clearRoutes();
            return;
        }
        this.routes = routes;
        CamelContext camelContext = this.context;
        if (camelContext != null) {
            try {
                this.routes.applyRoutes(camelContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setRoutes(String xml) throws Exception {
        logger.info("Setting routes...");
        if (xml == null || xml.trim().isEmpty()) {
            this.clearRoutes();
        } else {
            this.setRoutes(new XmlRoutesProvider(xml));
        }
    }

    public void setRoutes(RoutesDefinition routes) throws Exception {
        logger.info("Setting routes...");
        if (routes == null) {
            this.clearRoutes();
            return;
        }
        this.setRoutes(new SimpleRoutesProvider(routes));
    }

    public void setRoutes(RouteBuilder routeBuilder) throws Exception {
        logger.info("Setting routes...");
        if (routeBuilder == null) {
            this.clearRoutes();
            return;
        }
        this.setRoutes(new BuilderRoutesProvider(routeBuilder));
    }

    static Set<String> fromRoutes(Collection<Route> routes) {
        HashSet<String> result = new HashSet<String>(routes.size());
        for (Route route : routes) {
            result.add(route.getId());
        }
        return result;
    }

    private static <T extends OptionalIdentifiedDefinition<T>> Set<String> fromDefs(Collection<T> defs) {
        Objects.requireNonNull(defs);
        HashSet<String> result = new HashSet<String>(defs.size());
        for (OptionalIdentifiedDefinition def : defs) {
            String id = def.getId();
            if (id == null) continue;
            result.add(def.getId());
        }
        return result;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    /* synthetic */ CamelRunner(RegistryFactory registryFactory, ContextFactory contextFactory, List list, List list2, List list3, CamelRunner camelRunner) {
        this(registryFactory, contextFactory, list, list2, list3);
    }

    public static final class Builder {
        private final BundleContext bundleContext;
        private RegistryFactory registryFactory;
        private ContextFactory contextFactory;
        private final List<ServiceDependency<?, CamelContext>> dependencies;
        private final List<BeforeStart> beforeStarts;
        private final List<ContextLifecycleListener> lifecycleListeners;
        private boolean disableJmx = true;
        private int shutdownTimeout = 5;

        public Builder() {
            this(FrameworkUtil.getBundle(CamelRunner.class).getBundleContext());
        }

        public Builder(BundleContext bundleContext) {
            Objects.requireNonNull(bundleContext);
            this.bundleContext = bundleContext;
            this.registryFactory = CamelRunner.createOsgiRegistry(bundleContext);
            this.contextFactory = CamelRunner.createOsgiFactory(bundleContext);
            this.dependencies = new LinkedList();
            this.beforeStarts = new LinkedList<BeforeStart>();
            this.lifecycleListeners = new LinkedList<ContextLifecycleListener>();
        }

        public Builder(Builder other) {
            Objects.requireNonNull(other);
            this.bundleContext = other.bundleContext;
            this.registryFactory = other.registryFactory;
            this.contextFactory = other.contextFactory;
            this.dependencies = new LinkedList(other.dependencies);
            this.beforeStarts = new LinkedList<BeforeStart>(other.beforeStarts);
            this.lifecycleListeners = new LinkedList<ContextLifecycleListener>(other.lifecycleListeners);
            this.disableJmx = other.disableJmx;
            this.shutdownTimeout = other.shutdownTimeout;
        }

        public Builder disableJmx(boolean disableJmx) {
            this.disableJmx = disableJmx;
            return this;
        }

        public Builder shutdownTimeout(int shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public Builder osgiContext(BundleContext bundleContext) {
            Objects.requireNonNull(bundleContext);
            return this.contextFactory(CamelRunner.createOsgiFactory(bundleContext));
        }

        public Builder registryFactory(RegistryFactory registryFactory) {
            Objects.requireNonNull(registryFactory);
            this.registryFactory = registryFactory;
            return this;
        }

        public Builder contextFactory(ContextFactory contextFactory) {
            Objects.requireNonNull(contextFactory);
            this.contextFactory = contextFactory;
            return this;
        }

        public <T> Builder dependOn(Filter filter, ServiceConsumer<T, CamelContext> consumer) {
            return this.dependOn(null, filter, consumer);
        }

        public <T> Builder dependOn(BundleContext bundleContext, Filter filter, ServiceConsumer<T, CamelContext> consumer) {
            Objects.requireNonNull(filter);
            Objects.requireNonNull(consumer);
            if (bundleContext == null) {
                bundleContext = this.bundleContext;
            }
            this.dependencies.add(new DefaultServiceDependency<T, CamelContext>(bundleContext, filter, consumer));
            return this;
        }

        public Builder cloudService(BundleContext bundleContext, String filter, ServiceConsumer<CloudService, CamelContext> consumer) {
            String baseFilter = String.format("(%s=%s)", "objectClass", CloudService.class.getName());
            try {
                if (filter != null && !filter.trim().isEmpty()) {
                    Filter f = FrameworkUtil.createFilter((String)String.format("(&%s%s)", baseFilter, filter));
                    return this.dependOn(bundleContext, f, consumer);
                }
                return this.dependOn(bundleContext, FrameworkUtil.createFilter((String)baseFilter), consumer);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Failed to parse filter", e);
            }
        }

        public Builder cloudService(String filter) {
            return this.cloudService(null, filter, Builder.addAsCloudComponent("kura-cloud"));
        }

        public Builder cloudService(String attribute, String value) {
            Objects.requireNonNull(attribute);
            Objects.requireNonNull(value);
            return this.cloudService(String.format("(%s=%s)", attribute, value));
        }

        public Builder requireComponent(String componentName) {
            try {
                String filterString = String.format("(&(%s=%s)(%s=%s))", "objectClass", ComponentResolver.class.getName(), "component", componentName);
                Filter filter = FrameworkUtil.createFilter((String)filterString);
                this.dependOn(filter, (context, service) -> {});
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(String.format("Illegal component name: '%s'", componentName), e);
            }
            return this;
        }

        public Builder requireLanguage(String languageName) {
            try {
                String filterString = String.format("(&(%s=%s)(%s=%s))", "objectClass", LanguageResolver.class.getName(), "language", languageName);
                Filter filter = FrameworkUtil.createFilter((String)filterString);
                this.dependOn(filter, (context, service) -> {});
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(String.format("Illegal languageName name: '%s'", languageName), e);
            }
            return this;
        }

        public static ServiceConsumer<CloudService, CamelContext> addAsCloudComponent(String componentName) {
            return (context, service) -> context.addComponent(componentName, (Component)new KuraCloudComponent((CamelContext)context, (CloudService)service));
        }

        public Builder addBeforeStart(BeforeStart beforeStart) {
            Objects.requireNonNull(beforeStart);
            this.beforeStarts.add(beforeStart);
            return this;
        }

        public Builder addLifecycleListener(ContextLifecycleListener listener) {
            Objects.requireNonNull(listener);
            this.lifecycleListeners.add(listener);
            return this;
        }

        public CamelRunner build() {
            ArrayList<BeforeStart> beforeStartsTemp = new ArrayList<BeforeStart>(this.beforeStarts);
            ArrayList dependenciesTemp = new ArrayList(this.dependencies);
            if (this.disableJmx) {
                beforeStartsTemp.add(CamelContext::disableJMX);
            }
            if (this.shutdownTimeout > 0) {
                int shutdownTimeoutTemp = this.shutdownTimeout;
                beforeStartsTemp.add(camelContext -> {
                    camelContext.getShutdownStrategy().setTimeUnit(TimeUnit.SECONDS);
                    camelContext.getShutdownStrategy().setTimeout((long)shutdownTimeoutTemp);
                });
            }
            return new CamelRunner(this.registryFactory, this.contextFactory, beforeStartsTemp, this.lifecycleListeners, dependenciesTemp, null);
        }
    }
}

