/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;

public class ClientContext
implements IClientContext {
    private final String id;
    private final IElementMatcher matcher;
    private final Set typeIdBindings = new HashSet();
    private final Set patternBindings = new HashSet();

    public ClientContext(String id, IElementMatcher matcher) {
        this.id = id;
        this.matcher = matcher;
    }

    public final String getId() {
        return this.id;
    }

    public final IElementMatcher getMatcher() {
        return this.matcher;
    }

    public boolean includes(IEditHelperAdviceDescriptor adviceDescriptor) {
        return this.includes(adviceDescriptor.getId());
    }

    public boolean includes(IElementTypeDescriptor elementTypeDescriptor) {
        return this.includes(elementTypeDescriptor.getId());
    }

    public boolean includes(IElementType elementType) {
        return this.includes(elementType.getId());
    }

    private boolean includes(String _id) {
        boolean result = false;
        result = this.typeIdBindings.contains(_id);
        if (!result && !this.patternBindings.isEmpty() && (result = this.hasPatternBindingFor(_id))) {
            this.bindId(_id);
        }
        return result;
    }

    private boolean hasPatternBindingFor(String toMatch) {
        for (Pattern pattern : this.patternBindings) {
            if (!pattern.matcher(toMatch).matches()) continue;
            return true;
        }
        return false;
    }

    public void bindId(String typeId) {
        this.typeIdBindings.add(typeId);
    }

    public void bindPattern(Pattern pattern) {
        this.patternBindings.add(pattern);
    }

    public Collection getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isMultiClientContext() {
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientContext && ((ClientContext)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "ClientContext[" + this.getId() + ']';
    }
}

