/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MimeType {
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    private static final Map<String, String> type2extension = MimeType.buildMap();

    public static boolean isJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String mimeTypeLC = mimeType.toLowerCase(Locale.ROOT);
        return "application/ecmascript".equals(mimeTypeLC) || APPLICATION_JAVASCRIPT.equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "text/javascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    private static Map<String, String> buildMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("application/pdf", "pdf");
        map.put("application/x-javascript", "js");
        map.put(IMAGE_GIF, "gif");
        map.put("image/jpg", "jpeg");
        map.put(IMAGE_JPEG, "jpeg");
        map.put(IMAGE_PNG, "png");
        map.put("image/svg+xml", "svg");
        map.put(TEXT_CSS, "css");
        map.put(TEXT_HTML, "html");
        map.put(TEXT_PLAIN, "txt");
        map.put("image/x-icon", "ico");
        return map;
    }

    private MimeType() {
    }

    public static String getFileExtension(String contentType) {
        String value = type2extension.get(contentType.toLowerCase(Locale.ROOT));
        if (value == null) {
            return "unknown";
        }
        return value;
    }
}

