/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.crypto;

import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.crypto.SubtleCrypto;
import java.security.SecureRandom;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayView;

@JsxClass
public class Crypto
extends HtmlUnitScriptable {
    static final SecureRandom RANDOM = new SecureRandom();

    public Crypto() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        throw Context.reportRuntimeError((String)"Illegal constructor.");
    }

    public Crypto(Window window) {
        this.setParentScope((Scriptable)window);
        this.setPrototype(window.getPrototype(Crypto.class));
    }

    @JsxFunction
    public NativeTypedArrayView<?> getRandomValues(NativeTypedArrayView<?> array) {
        if (array == null) {
            throw ScriptRuntime.typeError((String)"Argument 1 of Crypto.getRandomValues is not an object.");
        }
        if (array.getByteLength() > 65536) {
            throw Context.reportRuntimeError((String)("Error: Failed to execute 'getRandomValues' on 'Crypto': The ArrayBufferView's byte length (" + array.getByteLength() + ") exceeds the number of bytes of entropy available via this API (65536)."));
        }
        for (int i = 0; i < array.getByteLength() / array.getBytesPerElement(); ++i) {
            array.put(i, array, (Object)RANDOM.nextInt());
        }
        return array;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public SubtleCrypto getSubtle() {
        SubtleCrypto stuble = new SubtleCrypto();
        Window window = this.getWindow();
        stuble.setParentScope((Scriptable)window);
        stuble.setPrototype(window.getPrototype(SubtleCrypto.class));
        return stuble;
    }

    @JsxFunction
    public String randomUUID() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[6] = (byte)(bytes[6] & 0x4F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        bytes[8] = (byte)(bytes[6] & 0xBF);
        StringBuilder result = new StringBuilder().append(Crypto.toHex(bytes[0])).append(Crypto.toHex(bytes[1])).append(Crypto.toHex(bytes[2])).append(Crypto.toHex(bytes[3])).append('-').append(Crypto.toHex(bytes[4])).append(Crypto.toHex(bytes[5])).append('-').append(Crypto.toHex(bytes[6])).append(Crypto.toHex(bytes[7])).append('-').append(Crypto.toHex(bytes[8])).append(Crypto.toHex(bytes[9])).append('-').append(Crypto.toHex(bytes[10])).append(Crypto.toHex(bytes[11])).append(Crypto.toHex(bytes[12])).append(Crypto.toHex(bytes[13])).append(Crypto.toHex(bytes[14])).append(Crypto.toHex(bytes[15]));
        return result.toString();
    }

    private static String toHex(byte b) {
        return String.format("%02X ", b).trim().toLowerCase(Locale.ROOT);
    }
}

