/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.controller.annotation;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.controller.annotation.ClassController;
import ee.jakarta.tck.mvc.tests.mvc.controller.annotation.HybridController;
import ee.jakarta.tck.mvc.tests.mvc.controller.annotation.MethodController;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class ControllerAnnotationTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(MethodController.class).addClass(ClassController.class).addClass(HybridController.class).addView("<h1>Rendered view #1</h1>", "view1.jsp").addView("<h1>Rendered view #2</h1>", "view2.jsp").build();
    }

    @Test
    @SpecAssertion(section="controllers", id="ctrl-method")
    public void controllerMethod() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/method/view1").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view #1"));
    }

    @Test
    @SpecAssertion(section="controllers", id="ctrl-class")
    public void controllerClass() throws IOException {
        WebClient client = new WebClient();
        WebResponse response1 = client.getPage(this.baseUrl.toString() + "mvc/class/view1").getWebResponse();
        Assert.assertThat((Object)response1.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response1.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view #1"));
        WebResponse response2 = client.getPage(this.baseUrl.toString() + "mvc/class/view2").getWebResponse();
        Assert.assertThat((Object)response2.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response2.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view #2"));
    }

    @Test
    @SpecAssertion(section="controllers", id="ctrl-hybrid")
    public void controllerHybrid() throws IOException {
        WebClient client = new WebClient();
        WebResponse response1 = client.getPage(this.baseUrl.toString() + "mvc/hybrid/view1").getWebResponse();
        Assert.assertThat((Object)response1.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response1.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view #1"));
        WebResponse response2 = client.getPage(this.baseUrl.toString() + "mvc/hybrid/view2").getWebResponse();
        Assert.assertThat((Object)response2.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response2.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"view2.jsp"));
    }
}

