/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.validation.constraints;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.validation.constraints.ConstraintsUtil;

public class MDCHK_D_PhysicalLink_Components
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)eObj;
            PhysicalPort target = physicalLink.getTargetPhysicalPort();
            PhysicalPort source = physicalLink.getSourcePhysicalPort();
            EObject outputObject = target.eContainer();
            EObject inputObject = source.eContainer();
            List feFeatures = FilteringUtils.getAssociatedCriteria((EObject)physicalLink);
            List outputFunctionFeatures = FilteringUtils.getAssociatedCriteria((EObject)outputObject);
            List<FilteringCriterion> missingOutputFeatures = ConstraintsUtil.missingFilteringCriteria(feFeatures, outputFunctionFeatures);
            List inputFunctionFeatures = FilteringUtils.getAssociatedCriteria((EObject)inputObject);
            List<FilteringCriterion> missingInputFeatures = ConstraintsUtil.missingFilteringCriteria(feFeatures, inputFunctionFeatures);
            String message = "";
            if (!missingOutputFeatures.isEmpty()) {
                message = String.valueOf(ConstraintsUtil.getNameForMessage(outputObject)) + " is missing " + "[" + FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingOutputFeatures) + "]";
            }
            if (!missingInputFeatures.isEmpty()) {
                if (!message.isEmpty()) {
                    message = String.valueOf(message) + " and ";
                }
                message = String.valueOf(message) + ConstraintsUtil.getNameForMessage(inputObject) + " is missing " + "[" + FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingInputFeatures) + "]";
            }
            if (!message.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{ConstraintsUtil.getNameForMessage((EObject)physicalLink), FilteringUtils.getCommaSeparatedFilteringCriteriaList((List)feFeatures), message});
            }
        }
        return ctx.createSuccessStatus();
    }
}

