/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.CreationDefaultFilteringCriterionSet;
import org.polarsys.capella.filtering.ExclusionFilteringResultSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringCriterionPkg;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringFactory;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.FilteringPackage;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.FilteringResultPkg;
import org.polarsys.capella.filtering.FilteringResultSet;
import org.polarsys.capella.filtering.FilteringResults;
import org.polarsys.capella.filtering.IntersectionFilteringResultSet;
import org.polarsys.capella.filtering.UnionFilteringResultSet;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.ModelOnlyFilteringDeleteCommand;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class FilteringUtils {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");

    public static Set<EObject> computeDerivation(AbstractFilteringResult abstractFResult, EObject root) {
        Predicate<EObject> predicate = FilteringUtils.computePredicate(abstractFResult);
        Set<EObject> derivation = FilteringUtils.computeDerivation(predicate, root);
        return derivation;
    }

    private static Set<EObject> computeDerivation(Predicate<EObject> predicate, EObject root) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (root != null) {
            if (predicate.test(root)) {
                result.add(root);
            }
            TreeIterator it = root.eAllContents();
            EObject current = null;
            while (it.hasNext()) {
                current = (EObject)it.next();
                if (!predicate.test(current)) continue;
                result.add(current);
            }
        }
        return result;
    }

    public static Predicate<EObject> computePredicate(FilteringResult filteringResult) {
        HashSet filteringCriteria = new HashSet(filteringResult.getFilteringCriteria());
        Predicate<EObject> predicate = elt -> FilteringUtils.isAssociatedWithAtLeastOneCriterionInclundingImplicits(elt, filteringCriteria);
        return predicate;
    }

    private static boolean isAssociatedWithAtLeastOneCriterionInclundingImplicits(EObject eObj, Set<FilteringCriterion> criterionSet) {
        List<FilteringCriterion> explicitCriteria = FilteringUtils.getAssociatedCriteria(eObj);
        Set<EObject> intersectionOf = FilteringUtils.intersectionOf(new HashSet<FilteringCriterion>(explicitCriteria), new HashSet<FilteringCriterion>(criterionSet));
        return !intersectionOf.isEmpty();
    }

    public static Predicate<EObject> computePredicate(ComposedFilteringResult composedFResult) {
        Predicate<EObject> predicate = elt -> true;
        UnionFilteringResultSet unionResultSet = composedFResult.getUnionFilteringResultSet();
        IntersectionFilteringResultSet intersectionResultSet = composedFResult.getIntersectionFilteringResultSet();
        ExclusionFilteringResultSet exclusionResultSet = composedFResult.getExclusionFilteringResultSet();
        Predicate<EObject> unionResultSetPredicate = FilteringUtils.computePredicate(unionResultSet);
        Predicate<EObject> intersectionResultSetPredicate = FilteringUtils.computePredicate(intersectionResultSet);
        Predicate<EObject> exclusionResultSetPredicate = FilteringUtils.computePredicate(exclusionResultSet);
        predicate = predicate.and(unionResultSetPredicate).and(intersectionResultSetPredicate).and(exclusionResultSetPredicate);
        return predicate;
    }

    private static Predicate<EObject> computePredicate(UnionFilteringResultSet unionResultSet) {
        if (unionResultSet == null) {
            return elt -> true;
        }
        Predicate<EObject> predicate = elt -> false;
        for (AbstractFilteringResult fR : unionResultSet.getFilteringResults()) {
            predicate = predicate.or(FilteringUtils.computePredicate(fR));
        }
        return predicate;
    }

    private static Predicate<EObject> computePredicate(ExclusionFilteringResultSet exclusionResultSet) {
        if (exclusionResultSet == null) {
            return elt -> true;
        }
        Predicate<EObject> predicate = elt -> true;
        for (AbstractFilteringResult fR : exclusionResultSet.getFilteringResults()) {
            predicate = predicate.and(FilteringUtils.computePredicate(fR));
        }
        return predicate.negate();
    }

    private static Predicate<EObject> computePredicate(IntersectionFilteringResultSet intersectionResultSet) {
        if (intersectionResultSet == null) {
            return elt -> true;
        }
        Predicate<EObject> predicate = elt -> true;
        for (AbstractFilteringResult fR : intersectionResultSet.getFilteringResults()) {
            predicate = predicate.and(FilteringUtils.computePredicate(fR));
        }
        return predicate;
    }

    public static Predicate<EObject> computePredicate(AbstractFilteringResult abstractFilteringResult) {
        Predicate<EObject> predicate = eObj -> FilteringUtils.notInstanceOfFilteringPackageMetaclass(eObj);
        if (abstractFilteringResult == null) {
            return predicate;
        }
        if (abstractFilteringResult instanceof FilteringResult) {
            return predicate.and(FilteringUtils.computePredicate((FilteringResult)abstractFilteringResult));
        }
        if (abstractFilteringResult instanceof ComposedFilteringResult) {
            return predicate.and(FilteringUtils.computePredicate((ComposedFilteringResult)abstractFilteringResult));
        }
        return elt -> true;
    }

    private static Set<EObject> unionOf(List<Set<EObject>> derivations) {
        HashSet<EObject> union = new HashSet<EObject>();
        derivations.forEach(union::addAll);
        return union;
    }

    private static Set<EObject> intersectionOf(List<Set<EObject>> derivations) {
        HashSet<EObject> intersection = new HashSet<EObject>();
        if (derivations.size() == 0) {
            return Collections.emptySet();
        }
        if (derivations.size() == 1) {
            return derivations.get(0);
        }
        if (derivations.size() > 1) {
            return FilteringUtils.intersectionOf(derivations.get(0), FilteringUtils.intersectionOf(derivations.subList(1, derivations.size())));
        }
        derivations.forEach(intersection::addAll);
        return intersection;
    }

    private static Set<EObject> intersectionOf(Set<EObject> set1, Set<EObject> set2) {
        return set1.stream().filter(set2::contains).collect(Collectors.toSet());
    }

    public static boolean isVariantModel(EObject modelObject, boolean includeReferencedLibraries) {
        List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels(modelObject, includeReferencedLibraries);
        return !filteringModels.isEmpty() && FilteringUtils.hasFilteringFeatures(filteringModels);
    }

    public static Session openSession(IFile aird, final IProgressMonitor monitor) {
        OpenSessionAction openSessionAction = new OpenSessionAction(){

            public void run() {
                this.doOpenSessions(monitor);
            }
        };
        openSessionAction.setRunInProgressService(false);
        openSessionAction.setOpenActivityExplorer(false);
        openSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)aird));
        openSessionAction.run();
        return SessionHelper.getSession((IFile)aird);
    }

    public static FilteringResultPkg getFilteringResultPkg(SystemEngineering systemEngineering) {
        if (systemEngineering != null) {
            for (ElementExtension elementExtension : systemEngineering.getOwnedExtensions()) {
                if (!(elementExtension instanceof CreationDefaultFilteringCriterionSet)) continue;
                return (FilteringResultPkg)elementExtension;
            }
        }
        return null;
    }

    public static Collection<Project> getMainAndReferencedVariantProjects(EObject object) {
        HashSet<Project> result = new HashSet<Project>();
        Project mainPrj = CapellaProjectHelper.getProject((EObject)object);
        if (mainPrj != null) {
            List<Project> projects = FilteringUtils.getReferencedProjects(mainPrj);
            projects.add(mainPrj);
            for (Project prj : projects) {
                if (!FilteringUtils.isVariantModel((EObject)prj, false)) continue;
                result.add(prj);
            }
        }
        return result;
    }

    public static List<Project> getReferencedProjects(Project project) {
        ArrayList<Project> res = new ArrayList<Project>();
        Session session = SessionManager.INSTANCE.getSession((EObject)project);
        if (session != null) {
            TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
            IModel model = ILibraryManager.INSTANCE.getModel((EObject)project);
            Collection allReferences = LibraryManagerExt.getAllReferences((IModel)model);
            for (IModel lib : allReferences) {
                if (!(lib instanceof ICapellaModel)) continue;
                res.add(((ICapellaModel)lib).getProject(transactionalEditingDomain));
            }
        }
        return res;
    }

    public static List<Project> getReferencedProjects(Session session) {
        ArrayList<Project> res = new ArrayList<Project>();
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        IModel abstractModel = ILibraryManager.INSTANCE.getModel(transactionalEditingDomain);
        Collection referencedLibraries = LibraryManagerExt.getAllReferences((IModel)abstractModel);
        for (IModel lib : referencedLibraries) {
            if (!(lib instanceof ICapellaModel)) continue;
            res.add(((ICapellaModel)lib).getProject(transactionalEditingDomain));
        }
        return res;
    }

    public static List<Resource> getReferencedLibraries(Session session) {
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (Project project : FilteringUtils.getReferencedProjects(session)) {
            res.add(project.eResource());
        }
        return res;
    }

    public static List<Resource> getReferencedLibraries(Project project) {
        return FilteringUtils.getReferencedLibraries(SessionManager.INSTANCE.getSession((EObject)project));
    }

    public static AssociatedFilteringCriterionSet getAssociatedFilteringCriterionSet(EObject melodyElement) {
        if (melodyElement instanceof ExtensibleElement) {
            EList ownedExtensions = ((ExtensibleElement)melodyElement).getOwnedExtensions();
            for (ElementExtension elementExtension : ownedExtensions) {
                if (!(elementExtension instanceof AssociatedFilteringCriterionSet)) continue;
                return (AssociatedFilteringCriterionSet)elementExtension;
            }
        }
        return null;
    }

    public static List<FilteringCriterion> getAssociatedCriteria(EObject element, List<EObject> visitedElements) {
        ArrayList<FilteringCriterion> featureList = new ArrayList<FilteringCriterion>();
        if (element instanceof CapellaElement) {
            CapellaElement capellaElement = (CapellaElement)CapellaAdapterHelper.resolveBusinessObject((Object)element);
            featureList.addAll(FilteringUtils.getExplicitAssociatedCriteria((EObject)capellaElement));
            if (featureList.isEmpty()) {
                Set<FilteringCriterion> features = FilteringUtils.getImplicitAssociatedCriteria((EObject)capellaElement, visitedElements);
                for (FilteringCriterion feature : features) {
                    if (featureList.contains(feature)) continue;
                    featureList.add(feature);
                }
            }
        }
        return featureList;
    }

    public static List<FilteringCriterion> getAssociatedCriteria(EObject element) {
        return FilteringUtils.getAssociatedCriteria(element, new ArrayList<EObject>());
    }

    public static List<FilteringCriterion> getExplicitAssociatedCriteria(EObject element) {
        ArrayList<FilteringCriterion> featureList = new ArrayList<FilteringCriterion>();
        if (element instanceof CapellaElement) {
            AssociatedFilteringCriterionSet featureSet = FilteringUtils.getAssociatedFilteringCriterionSet((EObject)((CapellaElement)element));
            if (featureSet == null) {
                return featureList;
            }
            for (FilteringCriterion feature : featureSet.getFilteringCriteria()) {
                if (featureList.contains(feature)) continue;
                featureList.add(feature);
            }
        }
        return featureList;
    }

    public static Set<FilteringCriterion> getImplicitAssociatedCriteria(EObject element) {
        return FilteringUtils.getImplicitAssociatedCriteria(element, new ArrayList<EObject>());
    }

    public static Set<FilteringCriterion> getImplicitAssociatedCriteria(EObject element, List<EObject> visitedElements) {
        HashSet<FilteringCriterion> res = new HashSet<FilteringCriterion>();
        List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels(element, true);
        if (!FilteringUtils.hasFilteringFeatures(filteringModels)) {
            return res;
        }
        for (FilteringCriterion currentFeature : FilteringUtils.getOwnedFilteringCriteria(filteringModels)) {
            if (FilteringToolsPlugin.getImplicitImpactCache().containsKey(currentFeature)) {
                logger.debug((Object)("Cache hit: " + currentFeature.hashCode() + " on " + FilteringToolsPlugin.getImplicitImpactCache().size() + " elements"));
                Collection<?> expanded = FilteringToolsPlugin.getImplicitImpactCache().get(currentFeature);
                if (!expanded.contains(element)) continue;
                res.add(currentFeature);
                continue;
            }
            List referencedElements = CrossReferencerHelper.getReferencingElements((EObject)currentFeature);
            ArrayList<CapellaElement> explictlyReferencedElements = new ArrayList<CapellaElement>();
            for (EObject referencedElement : referencedElements) {
                if (!(referencedElement instanceof AssociatedFilteringCriterionSet) || !(referencedElement.eContainer() instanceof CapellaElement)) continue;
                explictlyReferencedElements.add((CapellaElement)referencedElement.eContainer());
            }
            if (explictlyReferencedElements.contains(element)) continue;
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)element);
            ModelOnlyFilteringDeleteCommand deleteCmd = new ModelOnlyFilteringDeleteCommand(executionManager, explictlyReferencedElements, true, false, false);
            Set expandedElements = deleteCmd.getAllElementsToDelete();
            if (expandedElements.contains(element)) {
                res.add(currentFeature);
            }
            FilteringToolsPlugin.getImplicitImpactCache().put(currentFeature, expandedElements);
        }
        return res;
    }

    public static Set<EObject> getImpactedElements(Collection<EObject> element) {
        HashSet<EObject> relatedElements = new HashSet<EObject>();
        if (element == null || element.isEmpty()) {
            return relatedElements;
        }
        ExecutionManager executionManager = TransactionHelper.getExecutionManager(element);
        ModelOnlyFilteringDeleteCommand mdc = new ModelOnlyFilteringDeleteCommand(executionManager, element, true, false, false);
        Set impactedElements = mdc.getAllElementsToDelete();
        for (Object impactedElem : impactedElements) {
            if (!(impactedElem instanceof EObject)) continue;
            relatedElements.add((EObject)impactedElem);
        }
        return relatedElements;
    }

    public static FilteringModel getFilteringModel(EObject eObject) {
        List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels(eObject, false);
        return !filteringModels.isEmpty() ? filteringModels.get(0) : null;
    }

    public static Collection<FilteringModel> getCommonFilteringModels(Collection<EObject> eObjects, boolean includeReferencedLibraries) {
        Set<FilteringModel> filteringModels = null;
        for (EObject element : eObjects) {
            List<FilteringModel> currentElementFilteringModels = FilteringUtils.getFilteringModels(element, includeReferencedLibraries);
            if (filteringModels == null) {
                filteringModels = new HashSet<FilteringModel>();
                filteringModels.addAll(currentElementFilteringModels);
                continue;
            }
            filteringModels.retainAll(currentElementFilteringModels);
        }
        return filteringModels != null ? filteringModels : Collections.emptySet();
    }

    public static List<FilteringModel> getFilteringModels(EObject eObject, boolean includeReferencedLibraries) {
        ArrayList<FilteringModel> result = new ArrayList<FilteringModel>();
        if (eObject != null) {
            if (!includeReferencedLibraries) {
                SystemEngineering systemEngineering = FilteringUtils.getSystemEngineering(eObject);
                FilteringModel filteringModel = FilteringUtils.getFilteringModel(systemEngineering);
                if (filteringModel != null) {
                    result.add(filteringModel);
                }
            } else {
                for (Project prj : FilteringUtils.getMainAndReferencedVariantProjects(eObject)) {
                    FilteringModel filteringModel = FilteringUtils.getFilteringModel((EObject)prj);
                    if (filteringModel == null) continue;
                    result.add(filteringModel);
                }
            }
        }
        return result;
    }

    public static List<FilteringCriterion> getOwnedFilteringCriteria(Collection<FilteringModel> filteringModels) {
        ArrayList<FilteringCriterion> result = new ArrayList<FilteringCriterion>();
        for (FilteringModel filteringModel : filteringModels) {
            filteringModel.eAllContents().forEachRemaining(eObj -> {
                if (eObj instanceof FilteringCriterion) {
                    result.add((FilteringCriterion)eObj);
                }
            });
        }
        return result;
    }

    public static Collection<FilteringCriterion> getAllFilteringCriteria(EObject modelElement) {
        List<FilteringModel> filteringModels = FilteringUtils.getFilteringModels(modelElement, true);
        return FilteringUtils.getOwnedFilteringCriteria(filteringModels);
    }

    public static boolean hasFilteringFeatures(List<FilteringModel> filteringModels) {
        return !FilteringUtils.getOwnedFilteringCriteria(filteringModels).isEmpty();
    }

    public static List<EObject> getOwnedFilteringCriteriaAndPkgs(Collection<FilteringModel> filteringModels) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (FilteringModel filteringModel : filteringModels) {
            EList ownedCriteria = filteringModel.getOwnedFilteringCriteria();
            EList ownedCriteriaPkgs = filteringModel.getOwnedFilteringCriterionPkgs();
            if (ownedCriteria != null) {
                result.addAll((Collection<EObject>)ownedCriteria);
            }
            if (ownedCriteriaPkgs == null) continue;
            result.addAll((Collection<EObject>)ownedCriteriaPkgs);
        }
        return result;
    }

    public static List<EObject> getOwnedFilteringCriteriaAndPkgs(FilteringCriterionPkg criterionPkg) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EList ownedCriteria = criterionPkg.getOwnedFilteringCriteria();
        EList ownedCriteriaPkgs = criterionPkg.getOwnedFilteringCriterionPkgs();
        if (ownedCriteria != null) {
            result.addAll((Collection<EObject>)ownedCriteria);
        }
        if (ownedCriteriaPkgs != null) {
            result.addAll((Collection<EObject>)ownedCriteriaPkgs);
        }
        return result;
    }

    public static String formatFilteringItemName(NamedElement filteringItem) {
        Stack<String> stack = new Stack<String>();
        EObject parentPkg = filteringItem.eContainer();
        while (parentPkg instanceof Namespace) {
            stack.push(((NamedElement)parentPkg).getName());
            parentPkg = parentPkg.eContainer();
        }
        if (stack.isEmpty()) {
            return filteringItem.getName();
        }
        StringBuilder sb = new StringBuilder();
        while (!stack.isEmpty()) {
            sb.append(String.valueOf((String)stack.pop()) + "/");
        }
        sb.append(filteringItem.getName());
        return sb.toString();
    }

    public static FilteringModel getFilteringModel(SystemEngineering systemEngineering) {
        if (systemEngineering != null) {
            for (ElementExtension elementExtension : systemEngineering.getOwnedExtensions()) {
                if (!(elementExtension instanceof FilteringModel)) continue;
                return (FilteringModel)elementExtension;
            }
        }
        return null;
    }

    public static FilteringResults getFilteringResults(EObject eObject) {
        if (eObject != null) {
            SystemEngineering systemEngineering = FilteringUtils.getSystemEngineering(eObject);
            return FilteringUtils.getFilteringResults(systemEngineering);
        }
        return null;
    }

    public static List<AbstractFilteringResult> getFilteringResults(Collection<Project> projects) {
        if (projects == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractFilteringResult> result = new ArrayList<AbstractFilteringResult>();
        for (Project prj : projects) {
            FilteringResults filteringResults = FilteringUtils.getFilteringResults((EObject)prj);
            if (filteringResults == null) continue;
            result.addAll(FilteringUtils.getAllFilteringResults(filteringResults));
        }
        return result;
    }

    public static List<AbstractFilteringResult> getAllFilteringResults(FilteringResults filteringResults) {
        ArrayList<AbstractFilteringResult> filteringResultList = new ArrayList<AbstractFilteringResult>();
        if (filteringResults != null) {
            filteringResults.eAllContents().forEachRemaining(eObj -> {
                if (eObj instanceof AbstractFilteringResult) {
                    filteringResultList.add((AbstractFilteringResult)eObj);
                }
            });
        }
        return filteringResultList;
    }

    public static FilteringResults getFilteringResults(SystemEngineering systemEngineering) {
        if (systemEngineering != null) {
            for (ElementExtension elementExtension : systemEngineering.getOwnedExtensions()) {
                if (!(elementExtension instanceof FilteringResults)) continue;
                return (FilteringResults)elementExtension;
            }
        }
        return null;
    }

    public static CreationDefaultFilteringCriterionSet getCreationDefaultFeatureSet(EObject eObject) {
        if (eObject != null) {
            SystemEngineering systemEngineering = FilteringUtils.getSystemEngineering(eObject);
            return FilteringUtils.getCreationDefaultFeatureSet(systemEngineering);
        }
        return null;
    }

    public static CreationDefaultFilteringCriterionSet getCreationDefaultFeatureSet(SystemEngineering systemEngineering) {
        if (systemEngineering != null) {
            for (ElementExtension elementExtension : systemEngineering.getOwnedExtensions()) {
                if (!(elementExtension instanceof CreationDefaultFilteringCriterionSet)) continue;
                return (CreationDefaultFilteringCriterionSet)elementExtension;
            }
        }
        return null;
    }

    public static SystemEngineering getSystemEngineering(EObject eObject) {
        Project project;
        if (eObject != null && (project = CapellaProjectHelper.getProject((EObject)eObject)) != null && project.getOwnedModelRoots() != null) {
            for (EObject modelRoot : project.getOwnedModelRoots()) {
                if (!(modelRoot instanceof SystemEngineering)) continue;
                return (SystemEngineering)modelRoot;
            }
        }
        return null;
    }

    public static String getCommaSeparatedExplicitFeatures(EObject element) {
        List<FilteringCriterion> featureList = FilteringUtils.getExplicitAssociatedCriteria(element);
        return FilteringUtils.getCommaSeparatedFilteringCriteriaList(featureList);
    }

    public static String getCommaSeparatedFilteringCriteriaList(List<FilteringCriterion> featureList) {
        if (featureList == null || featureList.isEmpty()) {
            return null;
        }
        String features = "";
        for (FilteringCriterion feature : featureList) {
            features = String.valueOf(features) + feature.getName() + ", ";
        }
        if (features.length() > 0) {
            features = features.substring(0, features.length() - ", ".length());
        }
        return features;
    }

    public static void addAssociatedCriteria(EObject capellaElement, Collection<FilteringCriterion> filteringCriterions) {
        AssociatedFilteringCriterionSet featureSet = FilteringUtils.getAssociatedFilteringCriterionSet(capellaElement);
        if (featureSet == null && !filteringCriterions.isEmpty()) {
            featureSet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
            ((ExtensibleElement)capellaElement).getOwnedExtensions().add((Object)featureSet);
        }
        for (FilteringCriterion filteringCriterion : filteringCriterions) {
            if (featureSet.getFilteringCriteria().contains((Object)filteringCriterion)) continue;
            featureSet.getFilteringCriteria().add((Object)filteringCriterion);
        }
    }

    public static void removeAssociatedCriteria(EObject melodyElement, Collection<FilteringCriterion> filteringCriterions) {
        AssociatedFilteringCriterionSet featureSet = FilteringUtils.getAssociatedFilteringCriterionSet(melodyElement);
        if (featureSet != null && !filteringCriterions.isEmpty()) {
            featureSet.getFilteringCriteria().removeAll(filteringCriterions);
        }
        if (featureSet != null && featureSet.getFilteringCriteria().isEmpty()) {
            FilteringUtils.removeAssociatedFeatureSet(melodyElement);
        }
    }

    public static void removeAssociatedFeatureSet(EObject melodyElement) {
        AssociatedFilteringCriterionSet featureSet = FilteringUtils.getAssociatedFilteringCriterionSet(melodyElement);
        if (featureSet != null) {
            ArrayList<AssociatedFilteringCriterionSet> list = new ArrayList<AssociatedFilteringCriterionSet>();
            list.add(featureSet);
            CapellaDeleteCommand mdc = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)melodyElement), list, true, false, true);
            if (mdc.canExecute()) {
                mdc.execute();
            }
        }
    }

    public static IProject getEclipseProject(EObject eObject) {
        Session session = SessionManager.INSTANCE.getSession(eObject);
        URI resURI = session.getSessionResource().getURI();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resURI.toPlatformString(true)));
        return file.getProject();
    }

    public static Set<EObject> computeDerivation(FilteringResult filteringResult, ModelElement root) {
        Set<Object> allElementsWithAssociatedCriteria = FilteringUtils.getAllElementsWithAssociatedCriteria(root, new HashSet<FilteringCriterion>((Collection<FilteringCriterion>)filteringResult.getFilteringCriteria()));
        allElementsWithAssociatedCriteria = allElementsWithAssociatedCriteria.stream().filter(elt -> FilteringUtils.notInstanceOfFilteringPackageMetaclass(elt)).collect(Collectors.toSet());
        return allElementsWithAssociatedCriteria;
    }

    public static Set<EObject> getAllElementsWithAssociatedCriteria(ModelElement root, Set<FilteringCriterion> criterionSet) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (root != null) {
            if (FilteringUtils.isAssociatedWithAtLeastOneCriterion((EObject)root, criterionSet)) {
                result.add((EObject)root);
            }
            TreeIterator it = root.eAllContents();
            EObject current = null;
            while (it.hasNext()) {
                current = (EObject)it.next();
                if (!FilteringUtils.isAssociatedWithAtLeastOneCriterion(current, criterionSet)) continue;
                result.add(current);
            }
        }
        return result;
    }

    public static Set<EObject> getAllElementsWithAssociatedCriteria(EObject root) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (root != null) {
            if (FilteringUtils.hasAssociatedCriteria(root)) {
                result.add(root);
            }
            TreeIterator it = root.eAllContents();
            EObject current = null;
            while (it.hasNext()) {
                current = (EObject)it.next();
                if (!FilteringUtils.hasAssociatedCriteria(current)) continue;
                result.add(current);
            }
        }
        return result;
    }

    private static boolean isAssociatedWithAtLeastOneCriterion(EObject eObj, Set<FilteringCriterion> criterionSet) {
        List<FilteringCriterion> explicitCriteria = FilteringUtils.getExplicitAssociatedCriteria(eObj);
        Set<EObject> intersectionOf = FilteringUtils.intersectionOf(new HashSet<FilteringCriterion>(explicitCriteria), new HashSet<FilteringCriterion>(criterionSet));
        return !intersectionOf.isEmpty();
    }

    public static boolean hasAssociatedCriteria(EObject eObject) {
        return !FilteringUtils.getAssociatedCriteria(eObject).isEmpty();
    }

    public static void executeCommand(ICommand command, TransactionalEditingDomain editingDomain) {
        ExecutionManager executionManager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)editingDomain);
        if (executionManager != null && editingDomain instanceof InternalTransactionalEditingDomain) {
            InternalTransaction activeTransaction = ((InternalTransactionalEditingDomain)editingDomain).getActiveTransaction();
            if (activeTransaction != null && activeTransaction.isActive()) {
                command.run();
            } else {
                executionManager.execute(command);
            }
        }
    }

    public static void executeCommand(ICommand command, EObject eObject) {
        FilteringUtils.executeCommand(command, TransactionHelper.getEditingDomain((EObject)eObject));
    }

    public static void executeCommand(AbstractReadWriteCommand command, Session session) {
        FilteringUtils.executeCommand((ICommand)command, session.getTransactionalEditingDomain());
    }

    public static void executeCommand(AbstractReadWriteCommand command, Collection<EObject> elements) {
        FilteringUtils.executeCommand((ICommand)command, TransactionHelper.getEditingDomain(elements));
    }

    public static boolean isInstanceOfFilteringExcludedElements(Object obj) {
        return obj instanceof EObject && FilteringPackage.eINSTANCE.equals(((EObject)obj).eClass().getEPackage());
    }

    public static boolean notInstanceOfFilteringPackageMetaclass(Object obj) {
        return obj instanceof EObject && !FilteringUtils.isInstanceOfFilteringExcludedElements((EObject)obj);
    }

    public static List<IFile> getSemanticModels(IProject project) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String ext = resource.getFileExtension();
            if ("melodymodeller".equals(ext)) {
                result.add((IFile)resource);
            }
            ++n2;
        }
        return result;
    }

    public static List<IFile> getAirdModels(IProject project) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String ext = resource.getFileExtension();
            if ("aird".equals(ext)) {
                result.add((IFile)resource);
            }
            ++n2;
        }
        return result;
    }

    public static Set<FilteringCriterion> getSuperSet(List<EObject> featureSets) {
        HashSet<FilteringCriterion> featureList = new HashSet<FilteringCriterion>();
        for (EObject featureSet : featureSets) {
            if (!(featureSet instanceof FilteringCriterionSet)) continue;
            for (FilteringCriterion feature : ((FilteringCriterionSet)featureSet).getFilteringCriteria()) {
                if (featureList.contains(feature)) continue;
                featureList.add(feature);
            }
        }
        return featureList;
    }

    public static boolean isCriterionInResult(AbstractFilteringResult filteringResult, FilteringCriterion filteringCriterion) {
        if (filteringResult == null || filteringCriterion == null) {
            return false;
        }
        FilteringCriterionSet criterionSet = filteringResult.computeFilteringCriterionSet();
        if (criterionSet != null) {
            return criterionSet.getFilteringCriteria().contains((Object)filteringCriterion);
        }
        return false;
    }

    public static void forceRefreshDiagram(GraphicalEditor graphicalEditor) {
        graphicalEditor.setFocus();
        Object adaptation = graphicalEditor.getAdapter(GraphicalViewer.class);
        if (adaptation != null) {
            GraphicalViewer gv = (GraphicalViewer)adaptation;
            for (EditPart editpart : gv.getEditPartRegistry().values()) {
                if (!(editpart instanceof ConnectionEditPart)) continue;
                editpart.refresh();
            }
        }
    }

    public static void forceRefreshAllDiagrams() {
        IEditorReference[] editors;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && (editors = window.getActivePage().getEditorReferences()) != null) {
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                IEditorPart editorPart = editor.getEditor(true);
                if (editorPart.getEditorSite() != null && editorPart.getEditorSite().getId().equals("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")) {
                    FilteringUtils.forceRefreshDiagram((GraphicalEditor)editorPart);
                }
                ++n2;
            }
        }
    }

    public static void forceRefreshActiveDiagram() {
        IEditorPart editorPart;
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (workbenchPage = window.getActivePage()) != null && (editorPart = workbenchPage.getActiveEditor()) instanceof GraphicalEditor) {
            FilteringUtils.forceRefreshDiagram((GraphicalEditor)editorPart);
        }
    }

    public static void refreshAllRepresentations(final Session session, ExecutionManager executionManager) {
        Collection representationsToRefresh = DialectManager.INSTANCE.getAllRepresentations(session);
        for (final DRepresentation representation : representationsToRefresh) {
            if (!DialectManager.INSTANCE.canRefresh(representation)) continue;
            executionManager.execute((ICommand)new AbstractNonDirtyingCommand(){

                public void run() {
                    DialectManager.INSTANCE.refresh(representation, true, (IProgressMonitor)new NullProgressMonitor());
                    if (representation instanceof DDiagram) {
                        FilteringUtils.synchronizeGMFModel(session, (DDiagram)representation);
                    }
                }
            });
        }
    }

    private static void synchronizeGMFModel(Session session, DDiagram dDiagram) {
        Diagram gmfDiagram = SiriusGMFHelper.getGmfDiagram((DDiagram)dDiagram, (Session)session);
        CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiagram);
        canonicalSynchronizer.synchronize();
    }

    public static boolean resourceExists(IResource resource) {
        if (resource.exists()) {
            return true;
        }
        File file = resource.getWorkspace().getRoot().getLocation().append(resource.getName()).toFile();
        return file != null && file.exists();
    }

    public static boolean projectExists(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return true;
        }
        File file = project.getFullPath().toFile();
        return file != null && file.exists();
    }

    public static Collection<FilteringResultSet> getComposedResultChildren(ComposedFilteringResult composedResult) {
        HashSet<FilteringResultSet> children = new HashSet<FilteringResultSet>();
        Optional.ofNullable(composedResult.getIntersectionFilteringResultSet()).ifPresent(children::add);
        Optional.ofNullable(composedResult.getUnionFilteringResultSet()).ifPresent(children::add);
        Optional.ofNullable(composedResult.getExclusionFilteringResultSet()).ifPresent(children::add);
        return children;
    }
}

