/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.dialogs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.dialogs.SiriusCriteriaSelectionDialog;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;

public class DiagramElementsSelectionDialog {
    private static final Function<Object, Void> DO_NOTHING = new Function<Object, Void>(){

        public Void apply(Object from) {
            return null;
        }
    };
    protected SiriusCriteriaSelectionDialog dialog;
    protected DDiagram diagram;
    private final String title;
    private final String message;
    private Predicate<Object> isSelected = Predicates.alwaysTrue();
    private Predicate<Object> isGrayed = Predicates.alwaysFalse();
    private Function<Object, Void> selectedAction = DO_NOTHING;
    private Function<Object, Void> deselectedAction = DO_NOTHING;
    protected CriteriaContentProvider contentProvider;

    public DiagramElementsSelectionDialog(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public void setSelectionPredicate(Predicate<Object> isSelectedPredicate) {
        this.isSelected = isSelectedPredicate;
    }

    public void setGrayedPredicate(Predicate<Object> isGrayedPredicate) {
        this.isGrayed = isGrayedPredicate != null ? isGrayedPredicate : Predicates.alwaysFalse();
    }

    public void setSelectedAction(Function<Object, Void> selectedAction) {
        this.selectedAction = selectedAction;
    }

    public void setDeselectedAction(Function<Object, Void> deselectedAction) {
        this.deselectedAction = deselectedAction;
    }

    public boolean open(Shell parent, DDiagram ddiagram, boolean includeNodeLabel) {
        boolean result = false;
        this.diagram = ddiagram;
        this.contentProvider = new CriteriaContentProvider();
        Set<Object> allSelectedElements = Collections.unmodifiableSet(this.getAllSelectedElements());
        Option<Set<Object>> response = this.askUserForNewSelection(parent, allSelectedElements);
        if (response.some()) {
            Set selectedAfter = (Set)response.get();
            this.applyRequestedChanges(allSelectedElements, selectedAfter);
            assert (selectedAfter.equals(allSelectedElements));
            result = true;
        }
        this.diagram = null;
        this.dialog = null;
        this.contentProvider = null;
        return result;
    }

    protected Set<Object> getAllSelectedElements() {
        HashSet set = Sets.newHashSet();
        EList treeElements = this.diagram.getDiagramElements();
        for (DDiagramElement element : treeElements) {
            if (!Predicates.and(this.isSelected, (Predicate)Predicates.not(this.isGrayed)).apply((Object)element) || !FilteringSiriusUtils.hasAssociatedCriteria(element)) continue;
            set.add(element);
        }
        return set;
    }

    protected Option<Set<Object>> askUserForNewSelection(Shell parent, Set<Object> initialSelection) {
        this.setupDialog(parent, initialSelection);
        int result = this.dialog.open();
        if (result == 0) {
            Set<Object> selectedAfter = this.getElementsSelectedAfter();
            return Options.newSome(selectedAfter);
        }
        return Options.newNone();
    }

    public SiriusCriteriaSelectionDialog createCustomTreeSelectionDialog(Shell parent, EObject diagram) {
        Project project = CapellaProjectHelper.getProject((EObject)((DSemanticDiagram)diagram).getTarget());
        return new SiriusCriteriaSelectionDialog(parent, (ILabelProvider)new AdvancedFeatureLabelProvider(), this.contentProvider, project, diagram);
    }

    protected void setupDialog(Shell parent, Set<Object> initialSelection) {
        this.dialog = this.createCustomTreeSelectionDialog(parent, (EObject)this.diagram);
        this.dialog.setTitle(this.title);
        String msg = this.message;
        if (!Predicates.alwaysFalse().equals(this.isGrayed)) {
            StringBuilder sb = new StringBuilder(this.message);
            sb.append("\n");
            sb.append("The wizard will have no effect on grayed elements.");
            msg = sb.toString();
        }
        this.dialog.setMessage(msg);
        this.dialog.setInput(this.diagram);
        this.dialog.setInitialElementSelections(new ArrayList<Object>(initialSelection));
    }

    protected Set<Object> getElementsSelectedAfter() {
        HashSet selectedElements = Sets.newHashSet();
        for (DDiagramElement diagramElement : this.diagram.getDiagramElements()) {
            List<EObject> semantics = FilteringSiriusUtils.getRealSemanticElements(diagramElement);
            for (EObject eObject : semantics) {
                List featureList = FilteringUtils.getAssociatedCriteria((EObject)eObject);
                if (featureList.isEmpty()) continue;
                for (FilteringCriterion feature : featureList) {
                    if (!this.dialog.getCheckedElements().contains(feature) || selectedElements.contains(diagramElement)) continue;
                    selectedElements.add(diagramElement);
                }
            }
        }
        return selectedElements;
    }

    protected void applyRequestedChanges(Set<Object> selectedBefore, Set<Object> selectedAfter) {
        for (Object dde : Sets.difference(selectedBefore, selectedAfter)) {
            this.deselectedAction.apply(dde);
        }
        for (Object dde : Sets.difference(selectedAfter, selectedBefore)) {
            this.selectedAction.apply(dde);
        }
    }

    class AdvancedFeatureLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        AdvancedFeatureLabelProvider() {
        }

        public Color getForeground(Object element) {
            Color foreground = null;
            if (DiagramElementsSelectionDialog.this.isGrayed.apply(element)) {
                foreground = VisualBindingManager.getDefault().getColorFromName("light_gray");
            }
            return foreground;
        }

        public String getText(Object element) {
            if (element instanceof NamedElement) {
                return ((NamedElement)element).getName();
            }
            return element == null ? "" : element.toString();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            EnumerationPropertyLiteral feature;
            Font result = JFaceResources.getDefaultFont();
            if (element instanceof EnumerationPropertyLiteral && !FilteringSiriusUtils.allElementsAssociatedToAFeatureAreVisible(DiagramElementsSelectionDialog.this.diagram, feature = (EnumerationPropertyLiteral)element)) {
                result = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
            return result;
        }
    }
}

