/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.dialogs;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;

public class FilteringCriteriaSelectionDialog
extends CheckedTreeSelectionDialog {
    CriteriaContentProvider contentProvider;
    private Collection<Project> projects = null;
    private Collection<Object> checkedElements = null;
    private Collection<Object> uncheckedElements = null;
    private Collection<Object> initialCheckedElements = null;
    private Collection<Object> initialUndefinedElements = null;
    private Collection<Object> undefinedElements = null;

    public FilteringCriteriaSelectionDialog(Shell parent, ILabelProvider labelProvider, CriteriaContentProvider contentProvider, Project project) {
        this(parent, labelProvider, contentProvider, Arrays.asList(project));
    }

    public FilteringCriteriaSelectionDialog(Shell parent, ILabelProvider labelProvider, CriteriaContentProvider contentProvider, Collection<Project> projects) {
        super(parent, labelProvider, (ITreeContentProvider)contentProvider);
        this.contentProvider = contentProvider;
        this.projects = projects;
        this.checkedElements = new HashSet<Object>();
        this.uncheckedElements = new HashSet<Object>();
        this.initialCheckedElements = new HashSet<Object>();
        this.initialUndefinedElements = new HashSet<Object>();
        this.undefinedElements = new HashSet<Object>();
        this.setComparator(new ViewerComparator());
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.setInput(treeViewer.getInput());
        return treeViewer;
    }

    protected Label createMessageArea(Composite composite) {
        Label createMessageArea = super.createMessageArea(composite);
        this.createSelectionButtonsAfterMessageArea(composite);
        return createMessageArea;
    }

    protected Composite createSelectionButtonsAfterMessageArea(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        boolean enabledButtons = this.projects != null && !this.projects.isEmpty();
        this.addButton(buttonComposite, "Check All", ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/checkAll.gif").createImage(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = FilteringCriteriaSelectionDialog.this.contentProvider.getElements(FilteringCriteriaSelectionDialog.this.getTreeViewer().getInput());
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    FilteringCriteriaSelectionDialog.this.setTreeChecked(element, true);
                    FilteringCriteriaSelectionDialog.this.undefinedElements.remove(element);
                    ++n2;
                }
            }
        }, enabledButtons).setLayoutData((Object)data);
        this.addButton(buttonComposite, "Uncheck All", ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/uncheckAll.gif").createImage(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = FilteringCriteriaSelectionDialog.this.contentProvider.getElements(FilteringCriteriaSelectionDialog.this.getTreeViewer().getInput());
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    FilteringCriteriaSelectionDialog.this.setTreeChecked(element, false);
                    FilteringCriteriaSelectionDialog.this.undefinedElements.remove(element);
                    ++n2;
                }
            }
        }, enabledButtons).setLayoutData((Object)data);
        Label configLabel = new Label(buttonComposite, 0);
        configLabel.setImage(ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/selectCriteriaFromResult.png").createImage());
        configLabel.setEnabled(enabledButtons);
        final Combo configCombo = new Combo(buttonComposite, 14);
        final List<AbstractFilteringResult> filteringResults = FilteringUtils.getFilteringResults(this.projects);
        if (filteringResults.isEmpty()) {
            configCombo.add("No FilteringResults");
            configLabel.setEnabled(false);
            configCombo.setEnabled(false);
        } else {
            configCombo.add("Select a FilteringResult");
            for (AbstractFilteringResult filteringResult : filteringResults) {
                configCombo.add(FilteringUtils.formatFilteringItemName((NamedElement)filteringResult));
            }
            configCombo.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (configCombo.getSelectionIndex() == 0) {
                        return;
                    }
                    int realIndex = configCombo.getSelectionIndex() - 1;
                    AbstractFilteringResult selectedFilteringResult = (AbstractFilteringResult)filteringResults.get(realIndex);
                    Object[] objectArray = FilteringCriteriaSelectionDialog.this.contentProvider.getElements(FilteringCriteriaSelectionDialog.this.projects);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        FilteringCriteriaSelectionDialog.this.treeItemChecked(element, false);
                        ++n2;
                    }
                    for (FilteringCriterion vf : selectedFilteringResult.computeFilteringCriterionSet().getFilteringCriteria()) {
                        FilteringCriteriaSelectionDialog.this.treeItemChecked(vf, true);
                        FilteringCriteriaSelectionDialog.this.undefinedElements.remove(vf);
                    }
                }
            });
        }
        configCombo.select(0);
        return buttonComposite;
    }

    private Button addButton(Composite parent, String toolTipText, Image image, SelectionListener action, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setImage(image);
        button.addSelectionListener(action);
        button.setEnabled(enabled);
        return button;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072){

            public Point computeSize(int wHint, int hHint, boolean b) {
                return super.computeSize(0, 0, b);
            }
        };
        buttonComposite.setVisible(false);
        return buttonComposite;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.setInitialElementSelections(Arrays.asList(selectedElements));
    }

    public void setInitialElementSelections(List selectedElements) {
        HashSet<Project> prjts = new HashSet<Project>();
        for (Object selected : selectedElements) {
            if (!(selected instanceof FilteringCriterion)) continue;
            prjts.add(CapellaProjectHelper.getProject((EObject)((FilteringCriterion)selected)));
        }
        selectedElements.addAll(prjts);
        super.setInitialElementSelections(selectedElements);
        this.checkedElements.addAll(selectedElements);
    }

    public Collection<Object> getCheckedElements() {
        return Collections2.filter(this.checkedElements, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof FilteringCriterion;
            }
        });
    }

    public Collection<Object> getUnCheckedElements() {
        return Collections2.filter(this.uncheckedElements, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof FilteringCriterion;
            }
        });
    }

    public Collection<Object> getInitialUndefinedElements() {
        return Collections2.filter(this.initialUndefinedElements, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof FilteringCriterion;
            }
        });
    }

    public Collection<Object> getUndefinedElements() {
        return Collections2.filter(this.undefinedElements, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof FilteringCriterion;
            }
        });
    }

    public void setInitialUndefinedElements(Collection<Object> undefinedElements) {
        this.initialUndefinedElements = undefinedElements;
        this.undefinedElements = undefinedElements;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.initialCheckedElements.addAll(this.getInitialElementSelections());
        this.getTreeViewer().setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return FilteringCriteriaSelectionDialog.this.initialUndefinedElements.contains(element) || FilteringCriteriaSelectionDialog.this.determineShouldBeAtLeastGrayChecked(element);
            }

            public boolean isChecked(Object element) {
                return FilteringCriteriaSelectionDialog.this.initialCheckedElements.contains(element);
            }
        });
        this.getTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (FilteringCriteriaSelectionDialog.this.getTreeViewer().getGrayed(event.getElement())) {
                    FilteringCriteriaSelectionDialog.this.undefinedElements.remove(event.getElement());
                    FilteringCriteriaSelectionDialog.this.getTreeViewer().setGrayed(event.getElement(), false);
                }
                FilteringCriteriaSelectionDialog.this.treeItemChecked(event.getElement(), event.getChecked());
            }
        });
        return result;
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.updateCheckUncheckedElements(treeElement, state);
        this.setTreeChecked(treeElement, state);
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.grayUpdateHierarchy(parent);
    }

    protected void updateCheckUncheckedElements(Object element, boolean state) {
        if (state) {
            this.checkedElements.add(element);
            this.uncheckedElements.remove(element);
        } else {
            this.checkedElements.remove(element);
            this.uncheckedElements.add(element);
        }
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        this.getTreeViewer().setChecked(treeElement, state);
        this.getTreeViewer().setGrayed(treeElement, false);
        this.updateCheckUncheckedElements(treeElement, state);
        if (this.contentProvider.hasChildren(treeElement)) {
            Object[] children = this.contentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                this.setTreeChecked(children[i], state);
                ++i;
            }
        }
    }

    protected void grayCheckHierarchy(Object treeElement) {
        if (this.checkedElements.contains(treeElement)) {
            return;
        }
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedElements.remove(treeElement);
            this.uncheckedElements.add(treeElement);
        }
        if ((parent = this.contentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    private void grayUpdateHierarchy(Object treeElement) {
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.updateCheckUncheckedElements(treeElement, shouldBeAtLeastGray);
        this.getTreeViewer().setGrayChecked(treeElement, shouldBeAtLeastGray);
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        if (this.contentProvider.hasChildren(treeElement)) {
            Object[] children = this.contentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                if (this.checkedElements.contains(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void refresh() {
        this.getTreeViewer().refresh();
    }
}

