/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ImageDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ImageDataSource.class.getName());
    public static final String CONTENT_TYPE = "image/jpeg";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayOutputStream os;

    public ImageDataSource(String name, Image data) {
        this(name, CONTENT_TYPE, data);
    }

    public ImageDataSource(String name, String contentType, Image data) {
        this.name = name;
        this.contentType = contentType == null ? CONTENT_TYPE : contentType;
        this.os = new ByteArrayOutputStream();
        try {
            if (data != null) {
                ImageWriter writer = null;
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(contentType);
                if (iter.hasNext()) {
                    writer = iter.next();
                }
                writer.setOutput(ImageIO.createImageOutputStream(this.os));
                BufferedImage rendImage = null;
                if (data instanceof BufferedImage) {
                    rendImage = (BufferedImage)data;
                } else {
                    MediaTracker tracker = new MediaTracker(new Component(){});
                    tracker.addImage(data, 0);
                    tracker.waitForAll();
                    rendImage = new BufferedImage(data.getWidth(null), data.getHeight(null), 1);
                    Graphics2D g = rendImage.createGraphics();
                    g.drawImage(data, 0, 0, null);
                }
                writer.write(new IIOImage(rendImage, null, null));
                writer.dispose();
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

