/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.HashMap;
import java.util.Map;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableConsistencyLevel
implements ConsistencyLevelPolicy {
    private final Logger log = LoggerFactory.getLogger(ConfigurableConsistencyLevel.class);
    private Map<String, HConsistencyLevel> readCfConsistencyLevels = new HashMap<String, HConsistencyLevel>();
    private Map<String, HConsistencyLevel> writeCfConsistencyLevels = new HashMap<String, HConsistencyLevel>();
    private HConsistencyLevel defaultReadConsistencyLevel = HConsistencyLevel.QUORUM;
    private HConsistencyLevel defaultWriteConsistencyLevel = HConsistencyLevel.QUORUM;

    @Override
    public HConsistencyLevel get(OperationType op) {
        return op == OperationType.READ ? this.defaultReadConsistencyLevel : this.defaultWriteConsistencyLevel;
    }

    @Override
    public HConsistencyLevel get(OperationType op, String cfName) {
        if (op == OperationType.READ) {
            HConsistencyLevel rcf = this.readCfConsistencyLevels.get(cfName);
            return rcf != null ? rcf : this.defaultReadConsistencyLevel;
        }
        HConsistencyLevel wcf = this.writeCfConsistencyLevels.get(cfName);
        return wcf != null ? wcf : this.defaultWriteConsistencyLevel;
    }

    public void setReadCfConsistencyLevels(Map<String, HConsistencyLevel> columnFamilyConsistencyLevels) {
        this.readCfConsistencyLevels = columnFamilyConsistencyLevels;
    }

    public void setWriteCfConsistencyLevels(Map<String, HConsistencyLevel> columnFamilyConsistencyLevels) {
        this.writeCfConsistencyLevels = columnFamilyConsistencyLevels;
    }

    public void setConsistencyLevelForCfOperation(HConsistencyLevel consistencyLevel, String columnFamily, OperationType operationType) {
        if (operationType == OperationType.READ) {
            this.readCfConsistencyLevels.put(columnFamily, consistencyLevel);
        } else {
            this.writeCfConsistencyLevels.put(columnFamily, consistencyLevel);
        }
        this.log.info("{} ConsistencyLevel set to {} for ColumnFamily {}", new Object[]{operationType.toString(), consistencyLevel.toString(), columnFamily});
    }

    public void setDefaultReadConsistencyLevel(HConsistencyLevel defaultReadConsistencyLevel) {
        this.defaultReadConsistencyLevel = defaultReadConsistencyLevel;
    }

    public void setDefaultWriteConsistencyLevel(HConsistencyLevel defaultWriteConsistencyLevel) {
        this.defaultWriteConsistencyLevel = defaultWriteConsistencyLevel;
    }
}

