/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.factory;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.client.HKerberosThriftClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.security.KerberosHelper;
import me.prettyprint.cassandra.connection.security.SSLHelper;
import me.prettyprint.cassandra.service.CassandraHost;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HKerberosSecuredThriftClientFactoryImpl
implements HClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HKerberosSecuredThriftClientFactoryImpl.class);
    public static final String JAAS_CONFIG = "jaas.conf";
    public static final String KRB5_CONFIG = "krb5.conf";
    private final Subject kerberosTicket;
    private String krbServicePrincipalName;
    private TSSLTransportFactory.TSSLTransportParameters params = SSLHelper.getTSSLTransportParameters();

    public HKerberosSecuredThriftClientFactoryImpl() {
        log.info("SSL enabled for client<->server communications.");
        log.info("Properties:");
        log.info("  ssl.truststore = {}", (Object)System.getProperty("ssl.truststore"));
        log.info("  ssl.protocol = {}", (Object)System.getProperty("ssl.protocol"));
        log.info("  ssl.store.type = {}", (Object)System.getProperty("ssl.store.type"));
        log.info("  ssl.cipher.suites = {}", (Object)System.getProperty("ssl.cipher.suites"));
        String jaasConf = System.getProperty("java.security.auth.login.config");
        String krb5Conf = System.getProperty("java.security.krb5.conf");
        String krbDebug = System.getProperty("sun.security.krb5.debug");
        String krbClientReferenceName = System.getProperty("kerberos.client.reference.name");
        String krbClientUsername = System.getProperty("kerberos.client.principal.name");
        String krbClientPassword = System.getProperty("kerberos.client.password");
        this.krbServicePrincipalName = System.getProperty("kerberos.service.principal.name");
        if (krbDebug == null) {
            System.setProperty("sun.security.krb5.debug", "false");
        }
        if (jaasConf == null) {
            System.setProperty("java.security.auth.login.config", JAAS_CONFIG);
        }
        if (krb5Conf == null) {
            System.setProperty("java.security.krb5.conf", KRB5_CONFIG);
        }
        if (krbClientReferenceName == null) {
            krbClientReferenceName = "Client";
        }
        if (this.krbServicePrincipalName == null) {
            this.krbServicePrincipalName = "cassandra";
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        log.info("Kerberos V5 was enabled for client<->server communications.");
        log.info("Properties:");
        log.info("  sun.security.krb5.debug = {}", (Object)System.getProperty("sun.security.krb5.debug"));
        log.info("  java.security.auth.login.config = {}", (Object)System.getProperty("java.security.auth.login.config"));
        log.info("  java.security.krb5.conf = {}", (Object)System.getProperty("java.security.krb5.conf"));
        log.info("  kerberos.client.reference.name = {}", (Object)System.getProperty("kerberos.client.reference.name", krbClientReferenceName));
        log.info("  kerberos.service.principal.name = {}", (Object)System.getProperty("kerberos.service.principal.name", this.krbServicePrincipalName));
        log.info("  kerberos.client.principal.name = {}", (Object)System.getProperty("kerberos.client.principal.name"));
        log.info("  kerberos.client.password = {}", (Object)System.getProperty("kerberos.client.password"));
        log.info("  javax.security.auth.useSubjectCredsOnly = true");
        log.info("Trying to login to the KDC...");
        try {
            this.kerberosTicket = krbClientUsername != null && krbClientPassword != null ? KerberosHelper.loginService(krbClientReferenceName, krbClientUsername, krbClientPassword) : KerberosHelper.loginService(krbClientReferenceName);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
        log.info("Kerberos authenticated successfully against KDC");
    }

    @Override
    public HClient createClient(CassandraHost ch) {
        if (log.isDebugEnabled()) {
            log.debug("Creation of new client");
        }
        return this.params == null ? new HKerberosThriftClient(this.kerberosTicket, ch, this.krbServicePrincipalName) : new HKerberosThriftClient(this.kerberosTicket, ch, this.krbServicePrincipalName, this.params);
    }
}

