/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.transport.http.AxisServlet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BaseReportEngineServlet
extends AxisServlet {
    private static final long serialVersionUID = 1L;
    protected static boolean openSource = true;
    protected IFragment engine = null;
    protected IFragment requester = null;

    protected abstract void __init(ServletConfig var1);

    protected abstract boolean __authenticate(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract IContext __getContext(HttpServletRequest var1, HttpServletResponse var2) throws BirtException;

    protected abstract void __doGet(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __handleNonSoapException(HttpServletRequest var1, HttpServletResponse var2, Exception var3) throws ServletException, IOException;

    public static boolean isOpenSource() {
        return openSource;
    }

    public void init(ServletConfig config) throws ServletException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        super.init(config);
        ParameterAccessor.initParameters(config);
        BirtResources.setLocale(ParameterAccessor.getWebAppLocale());
        this.__init(config);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        req.setAttribute("ServletPath", (Object)((HttpServletRequest)req).getServletPath());
        super.service(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            if (!this.__authenticate(request, response)) {
                return;
            }
            try {
                IContext context;
                String requestType = request.getHeader("request-type");
                boolean isSoapRequest = "soap".equalsIgnoreCase(requestType);
                IViewingSession session = ViewingSessionUtil.getSession(request);
                if (session == null && !isSoapRequest && !ParameterAccessor.isGetImageOperator(request)) {
                    if (ViewingSessionUtil.getSessionId(request) == null) {
                        session = ViewingSessionUtil.createSession(request);
                    } else {
                        throw new ViewerException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
                    }
                }
                if ((context = this.__getContext(request, response)).getBean().getException() != null) {
                    this.__handleNonSoapException(request, response, context.getBean().getException());
                    break block13;
                }
                if (session == null) break block13;
                session.lock();
                try {
                    if (isSoapRequest) {
                        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                        super.doPost(request, response);
                    } else {
                        this.__doGet(context);
                    }
                }
                finally {
                    session.unlock();
                    if (!session.isLocked() && !context.getBean().isShowParameterPage() && ParameterAccessor.isServlet(request, "/document")) {
                        session.invalidate();
                    }
                }
            }
            catch (BirtException e) {
                this.__handleNonSoapException(request, response, (Exception)((Object)e));
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

