/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;

public class ContentEvent
extends NotificationEvent {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int SHIFT = 3;
    private int action;
    private DesignElement content;
    protected ContainerContext focus = null;

    public ContentEvent(DesignElement theContainer, DesignElement theContent, int theSlot, int theAction) {
        super(theContainer);
        this.action = theAction;
        this.content = theContent;
        this.focus = new ContainerContext(theContainer, theSlot);
    }

    public ContentEvent(ContainerContext containerInfo, DesignElement theContent, int theAction) {
        super(containerInfo.getElement());
        this.action = theAction;
        this.content = theContent;
        this.focus = containerInfo;
    }

    @Override
    public int getEventType() {
        return 0;
    }

    public int getAction() {
        return this.action;
    }

    public int getSlot() {
        return this.focus.getSlotID();
    }

    public IDesignElement getContent() {
        return this.content;
    }

    @Override
    public boolean isSame(NotificationEvent event) {
        if (!super.isSame(event)) {
            return false;
        }
        ContentEvent contentEvent = (ContentEvent)event;
        return this.action == contentEvent.getAction() && this.focus.equals(contentEvent.focus) && this.content == contentEvent.getContent();
    }
}

