/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AbstractDocumentRangeCommand {
    protected boolean isSameBlock(AcceleoTextDocument acceleoTextDocument, int startIndex, int endIndex) {
        ASTNode start = acceleoTextDocument.getAcceleoAstResult().getAstNode(startIndex);
        ASTNode end = acceleoTextDocument.getAcceleoAstResult().getAstNode(endIndex);
        return start.eContainer() instanceof Block && start.eContainer() == end.eContainer() || start instanceof Block && start == end.eContainer();
    }

    protected List<Variable> getVariablesDeclaredOutSide(AcceleoTextDocument acceleoTextDocument, int startIndex, int endIndex) {
        ArrayList<Variable> res = new ArrayList<Variable>();
        ASTNode start = acceleoTextDocument.getAcceleoAstResult().getAstNode(startIndex);
        ASTNode end = acceleoTextDocument.getAcceleoAstResult().getAstNode(endIndex);
        AcceleoAstResult astResult = acceleoTextDocument.getAcceleoAstResult();
        Block parentBlock = start instanceof Block ? (Block)start : (Block)start.eContainer();
        ArrayList<Statement> statementsInRange = new ArrayList<Statement>();
        for (Statement statement : parentBlock.getStatements()) {
            int statementStart = astResult.getStartPosition((ASTNode)statement);
            int statementEnd = astResult.getEndPosition((ASTNode)statement);
            if (statementStart >= startIndex && statementEnd <= endIndex) {
                statementsInRange.add(statement);
                continue;
            }
            if (statementEnd > endIndex) break;
        }
        ArrayList<VarRef> varRefs = new ArrayList<VarRef>();
        for (Statement statement : statementsInRange) {
            TreeIterator contentsIt = statement.eAllContents();
            while (contentsIt.hasNext()) {
                EObject current = (EObject)contentsIt.next();
                if (!(current instanceof VarRef)) continue;
                varRefs.add((VarRef)current);
            }
        }
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        IAcceleoValidationResult validationResult = acceleoTextDocument.getAcceleoValidationResults();
        for (VarRef varRef : varRefs) {
            Variable variable = validationResult.getDeclarationVariable(varRef);
            if (variable == null || astResult.getStartPosition((ASTNode)variable) >= startIndex) continue;
            variables.add(variable);
        }
        for (Variable variable : variables) {
            if (variable instanceof Binding) {
                Variable var = this.getVariable(acceleoTextDocument, (Binding)variable);
                res.add(var);
                continue;
            }
            res.add((Variable)EcoreUtil.copy((EObject)variable));
        }
        return res;
    }

    private Variable getVariable(AcceleoTextDocument acceleoTextDocument, Binding binding) {
        Variable var = AcceleoPackage.eINSTANCE.getAcceleoFactory().createVariable();
        var.setName(binding.getName());
        if (binding.getType() != null) {
            var.setTypeAql((org.eclipse.acceleo.query.ast.Expression)EcoreUtil.copy((EObject)binding.getTypeAql()));
            var.setType(binding.getType());
        } else {
            TypeLiteral type;
            Set possibleTypes = acceleoTextDocument.getAcceleoValidationResults().getPossibleTypes(binding.getInitExpression().getAql());
            if (!possibleTypes.isEmpty()) {
                IType possibleType = (IType)possibleTypes.iterator().next();
                type = this.getType(possibleType);
            } else {
                type = null;
            }
            if (type != null) {
                var.setTypeAql(type);
                var.setType(new AstResult((org.eclipse.acceleo.query.ast.Expression)type, new Positions(), Collections.emptyList(), (Diagnostic)new BasicDiagnostic()));
            }
        }
        return var;
    }

    private TypeLiteral getType(IType possibleType) {
        EClassifierTypeLiteral type;
        if (possibleType instanceof EClassifierType) {
            type = AstPackage.eINSTANCE.getAstFactory().createEClassifierTypeLiteral();
            type.setEPackageName(((EClassifierType)possibleType).getType().getEPackage().getName());
            type.setEClassifierName(((EClassifierType)possibleType).getType().getName());
        } else if (possibleType instanceof SequenceType) {
            type = AstPackage.eINSTANCE.getAstFactory().createCollectionTypeLiteral();
            ((CollectionTypeLiteral)type).setValue(List.class);
            ((CollectionTypeLiteral)type).setElementType(this.getType(((SequenceType)possibleType).getCollectionType()));
        } else if (possibleType instanceof SetType) {
            type = AstPackage.eINSTANCE.getAstFactory().createCollectionTypeLiteral();
            ((CollectionTypeLiteral)type).setValue(Set.class);
            ((CollectionTypeLiteral)type).setElementType(this.getType(((SetType)possibleType).getCollectionType()));
        } else if (possibleType instanceof IJavaType) {
            type = AstPackage.eINSTANCE.getAstFactory().createClassTypeLiteral();
            ((ClassTypeLiteral)type).setValue(((IJavaType)possibleType).getType());
        } else {
            type = null;
        }
        return type;
    }

    protected int getBlockStartIndex(AcceleoTextDocument acceleoTextDocument, Statement startStatement, int start) {
        int res = startStatement instanceof TextStatement ? start : acceleoTextDocument.getAcceleoAstResult().getStartPosition((ASTNode)startStatement);
        return res;
    }

    protected int getBlockEndIndex(AcceleoTextDocument acceleoTextDocument, Statement endStatement, int end) {
        int res = endStatement instanceof TextStatement ? end : acceleoTextDocument.getAcceleoAstResult().getEndPosition((ASTNode)endStatement);
        return res;
    }

    protected Block createBlock(String text, String blockIndentation, String indentation, String lineDelimiter, boolean removeBlockIndent) {
        Block res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
        res.setInlined(false);
        TextStatement textStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
        textStatement.setValue(this.indentText(text, blockIndentation, indentation, lineDelimiter, removeBlockIndent));
        textStatement.setNewLineNeeded(false);
        res.getStatements().add((Object)textStatement);
        return res;
    }

    private String indentText(String text, String blockIndentation, String indentation, String lineDelimiter, boolean removeBlockIndent) {
        String res;
        String outputBlockIndentation;
        if (removeBlockIndent) {
            outputBlockIndentation = "";
            res = text.substring(blockIndentation.length());
        } else {
            outputBlockIndentation = blockIndentation;
            res = text;
        }
        String emptyLineReplacement = UUID.randomUUID().toString() + UUID.randomUUID().toString() + UUID.randomUUID().toString();
        res = StringServices.EMPTY_LINE_PATTERN.matcher(res).replaceAll(emptyLineReplacement);
        res = res.replaceAll(StringServices.NEW_LINE_PATTERN.pattern() + blockIndentation, lineDelimiter + outputBlockIndentation + indentation);
        res = res.replace(emptyLineReplacement, lineDelimiter + lineDelimiter + outputBlockIndentation + indentation);
        return res + outputBlockIndentation;
    }

    protected String getBlockIndentation(String text) {
        int offset = 0;
        while (offset < text.length()) {
            char charAt = text.charAt(offset);
            if (charAt != ' ' && charAt != '\t') break;
            ++offset;
        }
        return text.substring(0, offset);
    }

    protected ExpressionStatement createCall(String name, List<Variable> parameters) {
        ExpressionStatement res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpressionStatement();
        Expression expression = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
        res.setExpression(expression);
        Call call = AstPackage.eINSTANCE.getAstFactory().createCall();
        expression.setAql((org.eclipse.acceleo.query.ast.Expression)call);
        expression.setAst(new AstResult((org.eclipse.acceleo.query.ast.Expression)call, new Positions(), Collections.emptyList(), (Diagnostic)new BasicDiagnostic()));
        call.setServiceName(name);
        if (parameters.get(0).getTypeAql() instanceof CollectionTypeLiteral) {
            call.setType(CallType.COLLECTIONCALL);
        } else {
            call.setType(CallType.CALLORAPPLY);
        }
        for (Variable var : parameters) {
            VarRef varRef = AstPackage.eINSTANCE.getAstFactory().createVarRef();
            varRef.setVariableName(var.getName());
            call.getArguments().add((Object)varRef);
        }
        return res;
    }
}

