/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.common.LocationUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocumentService;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.DeclarationSwitch;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.aql.validation.quickfixes.AcceleoQuickFixesSwitch;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.quickfixes.CreateResource;
import org.eclipse.acceleo.query.parser.quickfixes.DeleteResource;
import org.eclipse.acceleo.query.parser.quickfixes.IAstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.IAstResourceChange;
import org.eclipse.acceleo.query.parser.quickfixes.IAstTextReplacement;
import org.eclipse.acceleo.query.parser.quickfixes.MoveResource;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class AcceleoTextDocument {
    private static final String VALIDATION_NAMESPACE = "_reserved_::to::validate";
    private final URI uri;
    private AcceleoProject ownerProject;
    private IQualifiedNameQueryEnvironment queryEnvironment;
    private ResourceSet resourceSetForModels;
    private String contents;
    private AcceleoAstResult acceleoAstResult;
    private IAcceleoValidationResult acceleoValidationResult;
    private String qualifiedName;
    private boolean isOpened;

    public AcceleoTextDocument(AcceleoProject project, URI textDocumentUri, String qualifiedName, String textDocumentContents, Module module) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(textDocumentUri);
        Objects.requireNonNull(textDocumentContents);
        Objects.requireNonNull(qualifiedName);
        this.ownerProject = project;
        this.uri = textDocumentUri;
        this.qualifiedName = qualifiedName;
        this.contents = textDocumentContents;
        this.acceleoAstResult = module.getAst();
    }

    public AcceleoProject getProject() {
        return this.ownerProject;
    }

    public String getFileNameWithoutExtension() {
        return this.uri.toString().substring(this.uri.toString().lastIndexOf(47) + 1, this.uri.toString().lastIndexOf(46));
    }

    public void parseContents() {
        AcceleoAstResult parsingResult = null;
        if (this.isOpened()) {
            AcceleoParser acceleoParser = new AcceleoParser();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(this.contents.getBytes());){
                    String encoding = acceleoParser.parseEncoding((InputStream)is);
                    parsingResult = acceleoParser.parse(this.contents, encoding, this.getModuleQualifiedName());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Module resolvedModule = (Module)this.getProject().getResolver().resolve(this.qualifiedName);
            parsingResult = resolvedModule.getAst();
        }
        this.acceleoAstResult = parsingResult;
    }

    private void validateContents() {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getProject().getResolver();
        LinkedHashMap options = new LinkedHashMap();
        ArrayList exceptions = new ArrayList();
        this.resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)this, (ResourceSet)new ResourceSetImpl(), options);
        this.queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)this.resourceSetForModels, (boolean)true);
        for (Metamodel metamodel : this.getAcceleoAstResult().getModule().getMetamodels()) {
            EPackage ePkg;
            if (metamodel.getReferencedPackage() == null || (ePkg = resolver.getEPackage(metamodel.getReferencedPackage())) == null) continue;
            this.queryEnvironment.registerEPackage(ePkg);
        }
        try {
            IAcceleoValidationResult validationResults;
            if (this.isOpened()) {
                String moduleQualifiedNameForValidation = "_reserved_::to::validate::" + this.qualifiedName;
                resolver.register(moduleQualifiedNameForValidation, (Object)this.acceleoAstResult.getModule());
                try {
                    validationResults = AcceleoTextDocument.validate(this.queryEnvironment, this.acceleoAstResult, moduleQualifiedNameForValidation);
                }
                finally {
                    resolver.clear(Collections.singleton(moduleQualifiedNameForValidation));
                }
            } else {
                validationResults = AcceleoTextDocument.validate(this.queryEnvironment, this.acceleoAstResult, this.qualifiedName);
            }
            this.acceleoValidationResult = validationResults;
        }
        finally {
            AQLUtils.cleanResourceSetForModels((Object)this, (ResourceSet)this.resourceSetForModels);
            AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (ResourceSet)this.resourceSetForModels);
        }
    }

    public AcceleoLanguageServer getLanguageServer() {
        if (this.getProject() != null) {
            return this.getProject().getLanguageServer();
        }
        return null;
    }

    public AcceleoTextDocumentService getTextDocumentService() {
        AcceleoLanguageServer languageServer = this.getLanguageServer();
        if (languageServer != null) {
            return languageServer.getTextDocumentService();
        }
        return null;
    }

    public void validateAndPublishResults() {
        this.validateContents();
        AcceleoTextDocumentService service = this.getTextDocumentService();
        if (service != null) {
            service.publishValidationResults(this);
        }
    }

    public String getModuleQualifiedName() {
        return this.qualifiedName;
    }

    public List<LocationLink> getDefinitionLocations(int position) {
        return this.getDeclarationLocations(position, true);
    }

    public List<LocationLink> getDeclarationLocations(int position, boolean withCompatibleServices) {
        ArrayList<LocationLink> declarationLocations = new ArrayList<LocationLink>();
        ASTNode acceleoOrAqlNodeUnderCursor = this.acceleoAstResult.getAstNode(position);
        Object originSelectionRange = acceleoOrAqlNodeUnderCursor instanceof VarRef ? LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)((VarRef)acceleoOrAqlNodeUnderCursor)) : (acceleoOrAqlNodeUnderCursor instanceof Call ? LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)((Call)acceleoOrAqlNodeUnderCursor)) : (acceleoOrAqlNodeUnderCursor instanceof ModuleReference ? LocationUtils.range(this.acceleoValidationResult, (ASTNode)((ModuleReference)acceleoOrAqlNodeUnderCursor)) : null));
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        List<Object> declarations = this.getDeclaration((EObject)acceleoOrAqlNodeUnderCursor, withCompatibleServices);
        for (Object declaration : declarations) {
            LocationLink locationLink;
            URI sourceURI;
            ISourceLocation sourceLocation;
            if (declaration instanceof Declaration) {
                Declaration aqlDeclaration = (Declaration)declaration;
                declarationLocations.add(this.getDeclarationLocation((Range)originSelectionRange, aqlDeclaration));
                continue;
            }
            if (declaration instanceof Variable) {
                Variable variable = (Variable)declaration;
                declarationLocations.add(this.getDeclarationLocation((Range)originSelectionRange, variable));
                continue;
            }
            if (declaration instanceof IService) {
                IService service = (IService)declaration;
                sourceLocation = resolver.getSourceLocation(service);
                if (sourceLocation == null) continue;
                sourceURI = this.getProject().getResolver().getSourceURI(this.getModuleQualifiedName());
                locationLink = new LocationLink(sourceURI.toASCIIString(), LocationUtils.range(sourceLocation), LocationUtils.identifierRange(sourceLocation));
                locationLink.setOriginSelectionRange(originSelectionRange);
                locationLink.setTargetUri(sourceLocation.getSourceURI().toASCIIString());
                declarationLocations.add(locationLink);
                continue;
            }
            String declarationQualifiedName = declaration instanceof Module ? ((Module)declaration).eResource().getURI().toString().substring("acceleoenv::".length()) : resolver.getQualifiedName(declaration);
            sourceLocation = resolver.getSourceLocation(declarationQualifiedName);
            sourceURI = this.getProject().getResolver().getSourceURI(this.getModuleQualifiedName());
            locationLink = new LocationLink(sourceURI.toASCIIString(), LocationUtils.range(sourceLocation), LocationUtils.identifierRange(sourceLocation));
            locationLink.setOriginSelectionRange(originSelectionRange);
            locationLink.setTargetUri(sourceLocation.getSourceURI().toASCIIString());
            declarationLocations.add(locationLink);
        }
        return declarationLocations;
    }

    private LocationLink getDeclarationLocation(Range originSelectionRange, Variable variable) {
        Range identifierRange = LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)variable);
        Range range = LocationUtils.range(this.acceleoValidationResult, (ASTNode)variable);
        URI sourceURI = this.getProject().getResolver().getSourceURI(this.getModuleQualifiedName());
        LocationLink locationLink = new LocationLink(sourceURI.toASCIIString(), range, identifierRange);
        locationLink.setOriginSelectionRange(originSelectionRange);
        locationLink.setTargetUri(sourceURI.toASCIIString());
        return locationLink;
    }

    private LocationLink getDeclarationLocation(Range originSelectionRange, Declaration declaration) {
        Range identifierRange = LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)declaration);
        Range range = LocationUtils.range(this.acceleoValidationResult, (ASTNode)declaration);
        URI sourceURI = this.getProject().getResolver().getSourceURI(this.getModuleQualifiedName());
        LocationLink locationLink = new LocationLink(sourceURI.toASCIIString(), range, identifierRange);
        locationLink.setOriginSelectionRange(originSelectionRange);
        locationLink.setTargetUri(sourceURI.toASCIIString());
        return locationLink;
    }

    private List<Object> getDeclaration(EObject eObject, boolean withCompatibleServices) {
        DeclarationSwitch declarationSwitch = new DeclarationSwitch(this.acceleoValidationResult, this.queryEnvironment, withCompatibleServices);
        return declarationSwitch.getDeclarations(this.getModuleQualifiedName(), eObject);
    }

    public List<Location> getReferencesLocations(int position, boolean withCompatibleServices) {
        ArrayList<Location> referencesLocations = new ArrayList<Location>();
        ASTNode acceleoOrAqlNodeUnderCursor = this.acceleoAstResult.getAstNode(position);
        List<Object> firstDeclarations = this.getDeclaration((EObject)acceleoOrAqlNodeUnderCursor, withCompatibleServices);
        AcceleoWorkspace workspace = this.getProject().getWorkspace();
        boolean needDeclarationsRefesh = false;
        for (Object declaration : firstDeclarations) {
            String serviceContextQualifiedName;
            IQueryWorkspaceQualifiedNameResolver resolver;
            Iterator serviceContextURI;
            AcceleoTextDocument document;
            if (!(declaration instanceof IService) || (document = workspace.getDocument((URI)((Object)(serviceContextURI = (resolver = this.getProject().getResolver()).getURI(serviceContextQualifiedName = resolver.getContextQualifiedName((IService)declaration)))))) == null || !document.isOpened()) continue;
            workspace.registerAndPropagateChanges(document.getProject(), serviceContextQualifiedName, document.getAcceleoAstResult().getModule());
            needDeclarationsRefesh = true;
        }
        List<Object> declarations = needDeclarationsRefesh ? this.getDeclaration((EObject)acceleoOrAqlNodeUnderCursor, withCompatibleServices) : firstDeclarations;
        for (Object declaration : declarations) {
            Location location;
            if (declaration instanceof Declaration) {
                for (VarRef varRef : this.acceleoValidationResult.getResolvedVarRef((Declaration)declaration)) {
                    location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)varRef);
                    referencesLocations.add(location);
                }
                continue;
            }
            if (declaration instanceof Variable) {
                for (VarRef varRef : this.acceleoValidationResult.getResolvedVarRef((Variable)declaration)) {
                    location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)varRef);
                    referencesLocations.add(location);
                }
                continue;
            }
            if (declaration instanceof IService) {
                IService service = (IService)declaration;
                referencesLocations.addAll(this.getServiceReferenceLocations(acceleoOrAqlNodeUnderCursor, service));
                continue;
            }
            IQueryWorkspaceQualifiedNameResolver resolver = this.getProject().getResolver();
            String declarationQualifiedName = declaration instanceof Module ? ((Module)declaration).eResource().getURI().toString().substring("acceleoenv::".length()) : resolver.getQualifiedName(declaration);
            if (declarationQualifiedName == null) continue;
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            IQueryWorkspaceQualifiedNameResolver declarationResolver = resolver.getDeclarationResolver(declarationQualifiedName);
            for (String dependentQualifiedName : declarationResolver.getDependOn(declarationQualifiedName)) {
                uris.add(declarationResolver.getSourceURI(dependentQualifiedName));
            }
            for (IQueryWorkspaceQualifiedNameResolver dependentResolver : declarationResolver.getResolversDependOn()) {
                for (String dependOn : dependentResolver.getDependOn(declarationQualifiedName)) {
                    uris.add(dependentResolver.getSourceURI(dependOn));
                }
            }
            for (URI uri : uris) {
                AcceleoTextDocument document = workspace.getDocument(uri);
                if (document == null) continue;
                Module module = document.getAcceleoAstResult().getModule();
                if (module.getExtends() != null && declarationQualifiedName.equals(module.getExtends().getQualifiedName())) {
                    Location location2 = LocationUtils.location(document.getQueryEnvironment(), document.getModuleQualifiedName(), document.getAcceleoValidationResults(), (ASTNode)module.getExtends());
                    referencesLocations.add(location2);
                    continue;
                }
                for (Import imported : module.getImports()) {
                    if (!declarationQualifiedName.equals(imported.getModule().getQualifiedName())) continue;
                    Location location3 = LocationUtils.location(document.getQueryEnvironment(), document.getModuleQualifiedName(), document.getAcceleoValidationResults(), (ASTNode)imported.getModule());
                    referencesLocations.add(location3);
                }
            }
        }
        return referencesLocations;
    }

    private final List<Location> getServiceReferenceLocations(ASTNode acceleoOrAqlNodeUnderCursor, IService<?> service) {
        String featureName;
        Set featuresPossibleTypes;
        ArrayList<Location> res = new ArrayList<Location>();
        IQueryWorkspaceQualifiedNameResolver resolver = this.getProject().getResolver();
        AcceleoWorkspace workspace = this.getProject().getWorkspace();
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        String serviceContextQualifiedName = resolver.getContextQualifiedName(service);
        if ("aqlFeatureAccess".equals(service.getName())) {
            Call originalCall = (Call)acceleoOrAqlNodeUnderCursor.eContainer();
            Expression receiver = (Expression)originalCall.getArguments().get(0);
            featuresPossibleTypes = this.acceleoValidationResult.getPossibleTypes(receiver);
            featureName = ((StringLiteral)originalCall.getArguments().get(1)).getValue();
        } else {
            featuresPossibleTypes = null;
            featureName = null;
        }
        if (serviceContextQualifiedName != null) {
            if (serviceContextQualifiedName.startsWith("_reserved_::to::validate::")) {
                serviceContextQualifiedName = serviceContextQualifiedName.substring("_reserved_::to::validate::".length());
            }
            IQueryWorkspaceQualifiedNameResolver declarationResolver = resolver.getDeclarationResolver(serviceContextQualifiedName);
            URI declarationContextSourceURI = declarationResolver.getSourceURI(serviceContextQualifiedName);
            uris.add(declarationContextSourceURI);
            for (String dependOn : declarationResolver.getDependOn(serviceContextQualifiedName)) {
                uris.add(resolver.getSourceURI(dependOn));
            }
            for (IQueryWorkspaceQualifiedNameResolver dependentResolver : declarationResolver.getResolversDependOn()) {
                for (String dependOn : dependentResolver.getDependOn(serviceContextQualifiedName)) {
                    uris.add(dependentResolver.getSourceURI(dependOn));
                }
            }
        } else {
            uris.addAll(workspace.getAllTextDocuments().stream().map(d -> d.getUri()).collect(Collectors.toList()));
        }
        for (URI uri : uris) {
            AcceleoTextDocument document = workspace.getDocument(uri);
            if (document == null) continue;
            res.addAll(document.getLocalCallLocations(featuresPossibleTypes, featureName, service));
        }
        return res;
    }

    private boolean isCompatibleAqlFeatureAccess(Set<IType> featuresPossibleTypes, String featureName, Call call) {
        boolean res = false;
        Expression receiver = (Expression)call.getArguments().get(0);
        Set receiverTypes = this.acceleoValidationResult.getPossibleTypes(receiver);
        if (call.getArguments().size() == 2 && featureName.equals(((StringLiteral)call.getArguments().get(1)).getValue())) {
            block0: for (IType featuresPossibleType : featuresPossibleTypes) {
                for (IType receiverType : receiverTypes) {
                    if (!featuresPossibleType.isAssignableFrom(receiverType)) continue;
                    res = true;
                    break block0;
                }
            }
        }
        return res;
    }

    public List<Location> getLocalCallLocations(Set<IType> featuresPossibleTypes, String featureName, IService<?> service) {
        ArrayList<Location> referencesLocations = new ArrayList<Location>();
        List resolvedCalls = this.acceleoValidationResult.getResolvedCalls(service);
        for (Call call : resolvedCalls) {
            Location location;
            if (featureName != null && featuresPossibleTypes != null) {
                if (!this.isCompatibleAqlFeatureAccess(featuresPossibleTypes, featureName, call)) continue;
                location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)call);
                referencesLocations.add(location);
                continue;
            }
            location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)call);
            referencesLocations.add(location);
        }
        return referencesLocations;
    }

    public URI getUri() {
        return this.uri;
    }

    public AcceleoTextDocument applyChanges(Iterable<TextDocumentContentChangeEvent> textDocumentContentchangeEvents) {
        String newTextDocumentContents = this.contents;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : textDocumentContentchangeEvents) {
            newTextDocumentContents = AcceleoTextDocument.apply(textDocumentContentChangeEvent, newTextDocumentContents);
        }
        this.setContents(newTextDocumentContents);
        return this;
    }

    public void setContents(String newTextDocumentContents) {
        Objects.requireNonNull(newTextDocumentContents);
        this.contents = newTextDocumentContents;
        this.parseContents();
        this.validateAndPublishResults();
    }

    public AcceleoAstResult getAcceleoAstResult() {
        return this.acceleoAstResult;
    }

    public IAcceleoValidationResult getAcceleoValidationResults() {
        return this.acceleoValidationResult;
    }

    public IQualifiedNameQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    public String getContents() {
        return this.contents;
    }

    private static synchronized IAcceleoValidationResult validate(IQualifiedNameQueryEnvironment queryEnvironment, AcceleoAstResult acceleoAstResult, String moduleQualifiedNameForValidation) {
        AcceleoValidator acceleoValidator = new AcceleoValidator(queryEnvironment);
        IAcceleoValidationResult validationResults = acceleoValidator.validate(acceleoAstResult, moduleQualifiedNameForValidation);
        return validationResults;
    }

    private static String apply(TextDocumentContentChangeEvent textDocumentContentChangeEvent, String inText) {
        String newTextExcerpt = textDocumentContentChangeEvent.getText();
        Range changeRange = textDocumentContentChangeEvent.getRange();
        if (changeRange == null) {
            return newTextExcerpt;
        }
        return AcceleoLanguageServerPositionUtils.replace(inText, changeRange.getStart(), changeRange.getEnd(), newTextExcerpt);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void open(String contents) {
        this.isOpened = true;
        this.setContents(contents);
    }

    public void close() {
        this.isOpened = false;
        this.parseContents();
        this.validateAndPublishResults();
    }

    public PrepareRenameResult getPrepareRenameResult(int position) {
        PrepareRenameResult res;
        ASTNode astNode = this.acceleoAstResult.getAstNode(position);
        if (astNode != null) {
            int start = this.acceleoAstResult.getIdentifierStartPosition(astNode);
            int end = this.acceleoAstResult.getIdentifierEndPosition(astNode);
            if (start <= position && position <= end) {
                Range range = LocationUtils.identifierRange(this.acceleoValidationResult, astNode);
                res = new PrepareRenameResult(range, this.contents.substring(start, end));
            } else {
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    public Map<String, List<TextEdit>> getRenames(int position, String newName) {
        List edits;
        HashMap<String, List<TextEdit>> res = new HashMap<String, List<TextEdit>>();
        for (LocationLink locationLink : this.getDeclarationLocations(position, true)) {
            edits = res.computeIfAbsent(locationLink.getTargetUri(), uri -> new ArrayList());
            edits.add(new TextEdit(locationLink.getTargetSelectionRange(), newName));
        }
        for (Location location : this.getReferencesLocations(position, true)) {
            edits = res.computeIfAbsent(location.getUri(), uri -> new ArrayList());
            edits.add(new TextEdit(location.getRange(), newName));
        }
        return res;
    }

    public List<Either<Command, CodeAction>> getCodeActions(int atStartIndex, int atEndIndex, CodeActionContext context) {
        List<Object> res;
        ASTNode astNode = this.acceleoAstResult.getAstNode(atEndIndex);
        if (astNode != null) {
            AcceleoQuickFixesSwitch quickFixesSwitch = new AcceleoQuickFixesSwitch(this.getQueryEnvironment(), this.acceleoValidationResult, this.getModuleQualifiedName(), this.getContents(), System.lineSeparator());
            List quickFixes = quickFixesSwitch.getQuickFixes(astNode);
            res = quickFixes.stream().map(qf -> this.transform((IAstQuickFix)qf)).collect(Collectors.toList());
        } else {
            res = Collections.emptyList();
        }
        return res;
    }

    private Either<Command, CodeAction> transform(IAstQuickFix quickFix) {
        CodeAction res = new CodeAction(quickFix.getName());
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        res.setEdit(workspaceEdit);
        ArrayList<Either> documentChanges = new ArrayList<Either>();
        workspaceEdit.setDocumentChanges(documentChanges);
        for (IAstResourceChange change : quickFix.getResourceChanges()) {
            CreateFile resourceOperation;
            if (change instanceof CreateResource) {
                resourceOperation = new CreateFile(((CreateResource)change).getUri().toString());
            } else if (change instanceof DeleteResource) {
                resourceOperation = new DeleteFile(((DeleteResource)change).getUri().toString());
            } else if (change instanceof MoveResource) {
                resourceOperation = new RenameFile(((MoveResource)change).getSource().toString(), ((MoveResource)change).getTarget().toString());
            } else {
                throw new IllegalStateException("unknown resource change.");
            }
            documentChanges.add(Either.forRight((Object)resourceOperation));
        }
        for (IAstTextReplacement replacement : quickFix.getTextReplacements()) {
            TextEdit textEdit = new TextEdit(this.getRange(replacement), replacement.getReplacement());
            VersionedTextDocumentIdentifier version = new VersionedTextDocumentIdentifier(replacement.getURI().toString(), null);
            TextDocumentEdit textDocumentEdit = new TextDocumentEdit(version, new ArrayList());
            textDocumentEdit.getEdits().add(textEdit);
            documentChanges.add(Either.forLeft((Object)textDocumentEdit));
        }
        return Either.forRight((Object)res);
    }

    private Range getRange(IAstTextReplacement replacement) {
        Position start = new Position(replacement.getStartLine(), replacement.getStartColumn());
        Position end = new Position(replacement.getEndLine(), replacement.getEndColumn());
        return new Range(start, end);
    }
}

