/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.preferences;

import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.swt.graphics.Color;

public final class PreferenceGetter {
    public static Color getDataColor(String dataType) {
        if ("BOOL".equals(dataType)) {
            return UIPreferenceConstants.getBoolConnectorColor();
        }
        if (PreferenceGetter.isAnyBit(dataType)) {
            return UIPreferenceConstants.getAnyBitConnectorColor();
        }
        if (PreferenceGetter.isAnyInt(dataType)) {
            return UIPreferenceConstants.getAnyIntConnectorColor();
        }
        if (PreferenceGetter.isAnyReal(dataType)) {
            return UIPreferenceConstants.getAnyRealConnectorColor();
        }
        if (PreferenceGetter.isAnyString(dataType)) {
            return UIPreferenceConstants.getAnyStringConnectorColor();
        }
        return PreferenceGetter.getDefaultDataColor();
    }

    public static Color getDefaultDataColor() {
        return UIPreferenceConstants.getRemainingDataConnectorColor();
    }

    private static boolean isAnyBit(String dataType) {
        return "ANY_BIT".equals(dataType) || "BYTE".equals(dataType) || "WORD".equals(dataType) || "DWORD".equals(dataType) || "LWORD".equals(dataType);
    }

    private static boolean isAnyInt(String dataType) {
        return "ANY_INT".equals(dataType) || "SINT".equals(dataType) || "INT".equals(dataType) || "DINT".equals(dataType) || "LINT".equals(dataType) || "USINT".equals(dataType) || "UINT".equals(dataType) || "UDINT".equals(dataType) || "ULINT".equals(dataType);
    }

    private static boolean isAnyReal(String dataType) {
        return "ANY_REAL".equals(dataType) || "REAL".equals(dataType) || "LREAL".equals(dataType);
    }

    private static boolean isAnyString(String dataType) {
        return "ANY_STRING".equals(dataType) || "STRING".equals(dataType) || "WSTRING".equals(dataType);
    }

    private PreferenceGetter() {
        throw new UnsupportedOperationException("PreferenceGetter utility class should not be instantiated!");
    }
}

