/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.UpdateLeafContainerFileNameOperation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Display;

public class SafeResourceRefactoringChange
extends Change {
    private final RootLevel plantHierarchy;
    private final List<Leaf> leaves;
    private final String oldPath;
    private final String newPath;

    public SafeResourceRefactoringChange(RootLevel plantHierarchy, List<Leaf> leaves, String oldPath, String newPath) {
        this.plantHierarchy = plantHierarchy;
        this.leaves = leaves;
        this.oldPath = oldPath;
        this.newPath = newPath;
    }

    public String getName() {
        return "Update references on Plant Hierarchy";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        for (Leaf leaf : this.leaves) {
            Display.getDefault().asyncExec(() -> AbstractHierarchyHandler.executeOperation(new UpdateLeafContainerFileNameOperation(leaf, this.oldPath, this.newPath)));
        }
        return null;
    }

    public Object getModifiedElement() {
        return this.plantHierarchy;
    }
}

