/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// InactivePropertyHelper `cue-pseudo-element` test cases.

// "background",
// "background-attachment",
// "background-blend-mode",
// "background-clip",
// "background-color",
// "background-image",
// "background-origin",
// "background-position",
// "background-position-x",
// "background-position-y",
// "background-repeat",
// "background-size",
// "color",
// "font",
// "font-family",
// "font-size",
// "font-stretch",
// "font-style",
// "font-variant",
// "font-variant-alternates",
// "font-variant-caps",
// "font-variant-east-asian",
// "font-variant-ligatures",
// "font-variant-numeric",
// "font-variant-position",
// "font-weight",
// "line-height",
// "opacity",
// "outline",
// "outline-color",
// "outline-offset",
// "outline-style",
// "outline-width",
// "ruby-position",
// "text-combine-upright",
// "text-decoration",
// "text-decoration-color",
// "text-decoration-line",
// "text-decoration-style",
// "text-decoration-thickness",
// "text-shadow",
// "visibility",
// "white-space",

export default [
  {
    info: "background is active on ::cue",
    property: "background",
    tagName: "video",
    rules: ["video::cue { background: linear-gradient(white, black); }"],
    isActive: true,
  },
  {
    info: "background-attachment is active on ::cue",
    property: "background-attachment",
    tagName: "video",
    rules: ["video::cue { background-attachment: fixed; }"],
    isActive: true,
  },
  {
    info: "background-blend-mode is active on ::cue",
    property: "background-blend-mode",
    tagName: "video",
    rules: ["video::cue { background-blend-mode: difference; }"],
    isActive: true,
  },
  {
    info: "background-clip is active on ::cue",
    property: "background-clip",
    tagName: "video",
    rules: ["video::cue { background-clip: padding-box; }"],
    isActive: true,
  },
  {
    info: "background-color is active on ::cue",
    property: "background-color",
    tagName: "video",
    rules: ["video::cue { background-color: red; }"],
    isActive: true,
  },
  {
    info: "background-image is active on ::cue",
    property: "background-image",
    tagName: "video",
    rules: [
      "video::cue { background-image: url('https://example.com/image.png'); }",
    ],
    isActive: true,
  },
  {
    info: "background-origin is active on ::cue",
    property: "background-origin",
    tagName: "video",
    rules: ["video::cue { background-origin: padding-box; }"],
    isActive: true,
  },
  {
    info: "background-position is active on ::cue",
    property: "background-position",
    tagName: "video",
    rules: ["video::cue { background-position: 0 0; }"],
    isActive: true,
  },
  {
    info: "background-position-x is active on ::cue",
    property: "background-position-x",
    tagName: "video",
    rules: ["video::cue { background-position-x: 0; }"],
    isActive: true,
  },
  {
    info: "background-position-y is active on ::cue",
    property: "background-position-y",
    tagName: "video",
    rules: ["video::cue { background-position-y: 0; }"],
    isActive: true,
  },
  {
    info: "background-repeat is active on ::cue",
    property: "background-repeat",
    tagName: "video",
    rules: ["video::cue { background-repeat: repeat-y; }"],
    isActive: true,
  },
  {
    info: "background-size is active on ::cue",
    property: "background-size",
    tagName: "video",
    rules: ["video::cue { background-size: 100% 100%; }"],
    isActive: true,
  },
  {
    info: "color is active on ::cue",
    property: "color",
    tagName: "video",
    rules: ["video::cue { color: red; }"],
    isActive: true,
  },
  {
    info: "font is active on ::cue",
    property: "font",
    tagName: "video",
    rules: ["video::cue { font: 1em sans-serif; }"],
    isActive: true,
  },
  {
    info: "font-family is active on ::cue",
    property: "font-family",
    tagName: "video",
    rules: ["video::cue { font-family: sans-serif; }"],
    isActive: true,
  },
  {
    info: "font-size is active on ::cue",
    property: "font-size",
    tagName: "video",
    rules: ["video::cue { font-size: 1em; }"],
    isActive: true,
  },
  {
    info: "font-stretch is active on ::cue",
    property: "font-stretch",
    tagName: "video",
    rules: ["video::cue { font-stretch: ultra-condensed; }"],
    isActive: true,
  },
  {
    info: "font-style is active on ::cue",
    property: "font-style",
    tagName: "video",
    rules: ["video::cue { font-style: italic; }"],
    isActive: true,
  },
  {
    info: "font-variant is active on ::cue",
    property: "font-variant",
    tagName: "video",
    rules: ["video::cue { font-variant: small-caps; }"],
    isActive: true,
  },
  {
    info: "font-variant-alternates is active on ::cue",
    property: "font-variant-alternates",
    tagName: "video",
    rules: ["video::cue { font-variant-alternates: slashed-zero; }"],
    isActive: true,
  },
  {
    info: "font-variant-caps is active on ::cue",
    property: "font-variant-caps",
    tagName: "video",
    rules: ["video::cue { font-variant-caps: all-small-caps; }"],
    isActive: true,
  },
  {
    info: "font-variant-east-asian is active on ::cue",
    property: "font-variant-east-asian",
    tagName: "video",
    rules: ["video::cue { font-variant-east-asian: ruby; }"],
    isActive: true,
  },
  {
    info: "font-variant-ligatures is active on ::cue",
    property: "font-variant-ligatures",
    tagName: "video",
    rules: ["video::cue { font-variant-ligatures: common-ligatures; }"],
    isActive: true,
  },
  {
    info: "font-variant-numeric is active on ::cue",
    property: "font-variant-numeric",
    tagName: "video",
    rules: ["video::cue { font-variant-numeric: ordinal; }"],
    isActive: true,
  },
  {
    info: "font-variant-position is active on ::cue",
    property: "font-variant-position",
    tagName: "video",
    rules: ["video::cue { font-variant-position: sub; }"],
    isActive: true,
  },
  {
    info: "font-weight is active on ::cue",
    property: "font-weight",
    tagName: "video",
    rules: ["video::cue { font-weight: bold; }"],
    isActive: true,
  },
  {
    info: "line-height is active on ::cue",
    property: "line-height",
    tagName: "video",
    rules: ["video::cue { line-height: 1.2; }"],
    isActive: true,
  },
  {
    info: "opacity is active on ::cue",
    property: "opacity",
    tagName: "video",
    rules: ["video::cue { opacity: 0.8; }"],
    isActive: true,
  },
  {
    info: "outline is active on ::cue",
    property: "outline",
    tagName: "video",
    rules: ["video::cue { outline: 1px solid red; }"],
    isActive: true,
  },
  {
    info: "outline-color is active on ::cue",
    property: "outline-color",
    tagName: "video",
    rules: ["video::cue { outline-color: red; }"],
    isActive: true,
  },
  {
    info: "outline-offset is active on ::cue",
    property: "outline-offset",
    tagName: "video",
    rules: ["video::cue { outline-offset: 1px; }"],
    isActive: true,
  },
  {
    info: "outline-style is active on ::cue",
    property: "outline-style",
    tagName: "video",
    rules: ["video::cue { outline-style: solid; }"],
    isActive: true,
  },
  {
    info: "outline-width is active on ::cue",
    property: "outline-width",
    tagName: "video",
    rules: ["video::cue { outline-width: 1px; }"],
    isActive: true,
  },
  {
    info: "ruby-position is active on ::cue",
    property: "ruby-position",
    tagName: "video",
    rules: ["video::cue { ruby-position: over; }"],
    isActive: true,
  },
  {
    info: "text-combine-upright is active on ::cue",
    property: "text-combine-upright",
    tagName: "video",
    rules: ["video::cue { text-combine-upright: all; }"],
    isActive: true,
  },
  {
    info: "text-decoration is active on ::cue",
    property: "text-decoration",
    tagName: "video",
    rules: ["video::cue { text-decoration: 1px underline red; }"],
    isActive: true,
  },
  {
    info: "text-decoration-color is active on ::cue",
    property: "text-decoration-color",
    tagName: "video",
    rules: ["video::cue { text-decoration-color: red; }"],
    isActive: true,
  },
  {
    info: "text-decoration-line is active on ::cue",
    property: "text-decoration-line",
    tagName: "video",
    rules: ["video::cue { text-decoration-line: underline; }"],
    isActive: true,
  },
  {
    info: "text-decoration-style is active on ::cue",
    property: "text-decoration-style",
    tagName: "video",
    rules: ["video::cue { text-decoration-style: wavy; }"],
    isActive: true,
  },
  {
    info: "text-decoration-thickness is active on ::cue",
    property: "text-decoration-thickness",
    tagName: "video",
    rules: ["video::cue { text-decoration-thickness: 1px; }"],
    isActive: true,
  },
  {
    info: "text-shadow is active on ::cue",
    property: "text-shadow",
    tagName: "video",
    rules: ["video::cue { text-shadow: 1px 1px 1px red; }"],
    isActive: true,
  },
  {
    info: "visibility is active on ::cue",
    property: "visibility",
    tagName: "video",
    rules: ["video::cue { visibility: hidden; }"],
    isActive: true,
  },
  {
    info: "white-space is active on ::cue",
    property: "white-space",
    tagName: "video",
    rules: ["video::cue { white-space: nowrap; }"],
    isActive: true,
  },
  {
    info: "border is inactive on ::cue",
    property: "border",
    tagName: "video",
    rules: ["video::cue { border: 1px solid red; }"],
    isActive: false,
    expectedMsgId: "inactive-css-cue-pseudo-element-not-supported",
  },
  {
    info: "display is inactive on ::cue",
    property: "display",
    tagName: "video",
    rules: ["video::cue { display: grid; }"],
    isActive: false,
    expectedMsgId: "inactive-css-cue-pseudo-element-not-supported",
  },
  {
    info: "custom property is active on ::cue",
    property: "--my-var",
    tagName: "video",
    rules: ["video::cue { --my-var: red; }"],
    isActive: true,
  },
];
