% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/stopwatch.R
\name{get_stopwatch}
\alias{get_stopwatch}
\alias{elapsed_stopwatch}
\alias{format_stopwatch}
\alias{print.stopwatch}
\alias{format.stopwatch}
\title{R Accessor Functions for spdlog Stopwatch}
\usage{
get_stopwatch()

elapsed_stopwatch(sw)

format_stopwatch(sw)

\method{print}{stopwatch}(x, ...)

\method{format}{stopwatch}(x, ...)
}
\arguments{
\item{sw}{An S3 object of type \code{stopwatch}.}

\item{x}{An S3 object of type \code{stopwatch}.}

\item{...}{Dotted argument required by generic, unused here.}
}
\value{
The desired object is returned: respectively, a stopwatch object as an external pointer
in an S3 class, the elapsed time in seconds as a double, or formatted as a character variable.
}
\description{
A set of functions provides access to the \code{spdlog} stopwatch facilty. As \code{stopwatch}
object is a simple container around a C++ \code{std::chrono} object which (essentially) reports
elapsed-time since creation. The object is exported to R via an external pointer permitting use
from both R and C++.
}
\details{
Several functions are provided:
\describe{
   \item{\code{get_stopwatch}}{Returns a stopwatch object (as an S3 object).}
   \item{\code{elapsed_stopwatch}}{Returns elapsed time for stopwatch in seconds.}
   \item{\code{format_stopwatch}}{Returns elapsed time for stopwatch as character variable.}
}
The \code{stopwatch} object has \code{print} and \code{format} methods.
}
\examples{
w <- get_stopwatch()
Sys.sleep(0.2)
elapsed_stopwatch(w)
format_stopwatch(w)
}
