% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dates.R
\name{get_dates}
\alias{get_dates}
\alias{get_dates.default}
\alias{get_dates.incidence}
\title{Retrieve dates from an incidence object}
\usage{
get_dates(x, ...)

\method{get_dates}{default}(x, ...)

\method{get_dates}{incidence}(x, position = "left", count_days = FALSE, ...)
}
\arguments{
\item{x}{an \link{incidence} object}

\item{...}{Unused}

\item{position}{One of "left", "center", "middle", or "right" specifying what
side of the bin the date should be drawn from.}

\item{count_days}{If \code{TRUE}, the result will be represented as the number of
days from the first date.}
}
\value{
a vector of dates or numerics
}
\description{
Retrieve dates from an incidence object
}
\examples{

set.seed(999)
dat <- as.Date(Sys.Date()) + sample(-3:50, 100, replace = TRUE)
x <- incidence(dat, interval = "month")
get_dates(x)
get_dates(x, position = "middle")
set.seed(999)
dat <- as.Date(Sys.Date()) + sample(-3:50, 100, replace = TRUE)
x <- incidence(dat, interval = "month")
get_dates(x)
get_dates(x, "center")
get_dates(x, "right")

# Return dates by number of days from the first date
get_dates(x, count_days = TRUE)
get_dates(incidence(-5:5), count_days = TRUE)
}
\keyword{accessors}
