% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_substring}
\alias{ansi_substring}
\title{Substring(s) of an ANSI colored string}
\usage{
ansi_substring(text, first, last = 1000000L)
}
\arguments{
\item{text}{Character vector, potentially ANSI styled, or a vector to
coerced to character. It is recycled to the longest of \code{first}
and \code{last}.}

\item{first}{Starting index or indices, recycled to match the length
of \code{x}.}

\item{last}{Ending index or indices, recycled to match the length
of \code{x}.}
}
\value{
Character vector of the same length as \code{x}, containing
the requested substrings. ANSI styles are retained.
}
\description{
This is the color-aware counterpart of \code{\link[base:substr]{base::substring()}}.
It works exactly like the original, but keeps the colors in the
substrings. The ANSI escape sequences are ignored when
calculating the positions within the string.
}
\examples{
str <- paste(
  col_red("red"),
  "default",
  col_green("green")
)

cat(str, "\n")
cat(ansi_substring(str, 1, 5), "\n")
cat(ansi_substring(str, 1, 15), "\n")
cat(ansi_substring(str, 3, 7), "\n")

substring(ansi_strip(str), 1, 5)
substring(ansi_strip(str), 1, 15)
substring(ansi_strip(str), 3, 7)

str2 <- paste(
  "another",
  col_red("multi-", style_underline("style")),
  "text"
)

cat(str2, "\n")
cat(ansi_substring(str2, c(3,5), c(7, 18)), sep = "\n")
substring(ansi_strip(str2), c(3,5), c(7, 18))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
