# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Marketplace subscription status of the file system resource."""

    PENDING_FULFILLMENT_START = "PendingFulfillmentStart"
    """Fulfillment has not started"""
    SUBSCRIBED = "Subscribed"
    """Marketplace offer is subscribed"""
    SUSPENDED = "Suspended"
    """Marketplace offer is suspended because of non payment"""
    UNSUBSCRIBED = "Unsubscribed"
    """Marketplace offer is unsubscribed"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning State of the File system resource."""

    ACCEPTED = "Accepted"
    """File system resource creation request accepted"""
    CREATING = "Creating"
    """File system resource creation started"""
    UPDATING = "Updating"
    """File system resource is being updated"""
    DELETING = "Deleting"
    """File system resource deletion started"""
    SUCCEEDED = "Succeeded"
    """File system resource creation successful"""
    FAILED = "Failed"
    """File system resource creation failed"""
    CANCELED = "Canceled"
    """File system resource creation canceled"""
    DELETED = "Deleted"
    """File system resource is deleted"""
