# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementContainersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_containers_list_by_storage_account(self, resource_group):
        response = self.client.containers.list_by_storage_account(
            device_name="str",
            storage_account_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_containers_get(self, resource_group):
        response = self.client.containers.get(
            device_name="str",
            storage_account_name="str",
            container_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_containers_begin_create_or_update(self, resource_group):
        response = self.client.containers.begin_create_or_update(
            device_name="str",
            storage_account_name="str",
            container_name="str",
            resource_group_name=resource_group.name,
            container={
                "dataFormat": "str",
                "containerStatus": "str",
                "createdDateTime": "2020-02-20 00:00:00",
                "id": "str",
                "name": "str",
                "refreshDetails": {
                    "errorManifestFile": "str",
                    "inProgressRefreshJobId": "str",
                    "lastCompletedRefreshJobTimeInUTC": "2020-02-20 00:00:00",
                    "lastJob": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_containers_begin_delete(self, resource_group):
        response = self.client.containers.begin_delete(
            device_name="str",
            storage_account_name="str",
            container_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_containers_begin_refresh(self, resource_group):
        response = self.client.containers.begin_refresh(
            device_name="str",
            storage_account_name="str",
            container_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
