# Phosh Mobile Settings

Mobile Settings App for [phosh](https://gitlab.gnome.org/World/Phosh/phosh) and
related components.

Additionally, it supports the [conf-tweaks format](src/conf-tweaks/README.md)
for defining additional settings in YAML format.

## License

Phosh Mobile Settings is licensed under the GPLv3+.

## Getting the source

```sh
git clone https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings
cd phosh-mobile-settings
```

The [main][] branch has the current development version.

## Dependencies

On a Debian based system run

```sh
sudo apt-get -y install build-essential
sudo apt-get -y build-dep .
```

For an explicit list of dependencies check the `Build-Depends` entry in the
[debian/control][] file.

## Building

We use the meson (and thereby Ninja) build system for phosh. The quickest
way to get going is to do the following:

```sh
meson setup _build
meson compile -C _build
```

## Running

Phosh Mobile Settings needs to locate a few GSettings schema, if phosh is
already installed on your system, then it works out of box.

```sh
sudo apt-get -y install phosh
```

Then run Mobile Settings using `_build/run`.

```sh
_build/run
```

If you have the source code of phosh and would like to run Mobile Settings using
the schema generated by it, you need to set the `PHOSH_BUILD_DIR` to
phosh's build directory.

```sh
PHOSH_BUILD_DIR=/path/to/phosh/_build _build/run
```

By default, `_build/run` looks for phosh build directory at `../phosh/_build`.
If you have phosh source code in that location, then you can run `_build/run`
as it is without setting `PHOSH_BUILD_DIR`.

Note that the `run` script sets the GSettings backend to `memory` by default
so phosh or other apps don't see any changes made. This can be changed by
settings `GSETTINGS_BACKEND=dconf`.

The result should look something like this:

![Welcome screen](screenshots/panels.png)
![Feedback panel](screenshots/feedback.png)
![Compositor panel](screenshots/compositor.png)

## Getting in Touch

- Issue tracker: <https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings/issues>
- Matrix: <https://matrix.to/#/#phosh:phosh.mobi>

[main]: https://gitlab.gnome.org/World/Phosh/phosh-mobile-seettings/-/tree/main
[.gitlab-ci.yml]: https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings/-/blob/main/.gitlab-ci.yml
[debian/control]: https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings/-/blob/main/debian/control
