/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.app;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import java.util.StringTokenizer;
import org.chefproject.app.SSLSetup;
import org.chefproject.util.Blob;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;

public class Robot {
    Random m_random = new Random();
    public static long start = 0L;

    public static void main(String[] args) {
        new Robot().go(args);
    }

    private void go(String[] args) {
        SSLSetup.initializeForSSL();
        SSLSetup.overrideTrustManager();
        try {
            int len = 0;
            Client[] getters = null;
            Thread[] threads = null;
            try {
                String id;
                int i;
                int userNum;
                int i2;
                if (args[0].equals("-l")) {
                    len = args.length - 1;
                    getters = new RobotClient[len];
                    threads = new Thread[len];
                    i2 = 0;
                    while (i2 < len) {
                        getters[i2] = new RobotClient(args[i2 + 1], false, 1, 0L, false);
                        threads[i2] = new Thread(getters[i2]);
                        ++i2;
                    }
                } else if (args[0].equals("-s")) {
                    len = args.length - 1;
                    getters = new RobotClient[len];
                    threads = new Thread[len];
                    i2 = 0;
                    while (i2 < len) {
                        getters[i2] = new RobotClient(args[i2 + 1], true, 1, 0L, false);
                        threads[i2] = new Thread(getters[i2]);
                        ++i2;
                    }
                } else if (args[0].equals("-n")) {
                    len = Integer.parseInt(args[1]);
                    getters = new RobotClient[len];
                    threads = new Thread[len];
                    i2 = 0;
                    while (i2 < len) {
                        getters[i2] = new RobotClient(args[2], false, 1, 0L, false);
                        threads[i2] = new Thread(getters[i2]);
                        ++i2;
                    }
                } else if (args[0].equals("-lp")) {
                    len = 1;
                    getters = new RobotClient[len];
                    threads = new Thread[len];
                    i2 = 0;
                    while (i2 < len) {
                        getters[i2] = new RobotClient(args[1], false, Integer.parseInt(args[2]), Integer.parseInt(args[3]), false);
                        threads[i2] = new Thread(getters[i2]);
                        ++i2;
                    }
                } else if (args[0].equals("-lpc")) {
                    len = 1;
                    getters = new RobotClient[len];
                    threads = new Thread[len];
                    i2 = 0;
                    while (i2 < len) {
                        getters[i2] = new RobotClient(args[1], false, Integer.parseInt(args[2]), Integer.parseInt(args[3]), true);
                        threads[i2] = new Thread(getters[i2]);
                        ++i2;
                    }
                } else if (args[0].equals("-c1")) {
                    len = Integer.parseInt(args[1]);
                    userNum = Integer.parseInt(args[3]);
                    getters = new Client[len];
                    threads = new Thread[len];
                    i = 0;
                    while (i < len) {
                        id = "test" + Integer.toString(i + userNum);
                        getters[i] = new ChefClient1(args[2], id, id, Integer.parseInt(args[4]), args[5]);
                        threads[i] = new Thread(getters[i]);
                        ++i;
                    }
                } else if (args[0].equals("-c2")) {
                    len = Integer.parseInt(args[1]);
                    userNum = Integer.parseInt(args[3]);
                    getters = new Client[len];
                    threads = new Thread[len];
                    i = 0;
                    while (i < len) {
                        id = "test" + Integer.toString(i + userNum);
                        getters[i] = new ChefClient2(args[2], id, id, Integer.parseInt(args[4]), args[5]);
                        threads[i] = new Thread(getters[i]);
                        ++i;
                    }
                } else if (args[0].equals("-c3")) {
                    len = Integer.parseInt(args[1]);
                    userNum = Integer.parseInt(args[3]);
                    getters = new Client[len];
                    threads = new Thread[len];
                    i = 0;
                    while (i < len) {
                        id = "test" + Integer.toString(i + userNum);
                        getters[i] = new ChefClient3(args[2], id, id, Integer.parseInt(args[4]), args[5], false, true);
                        threads[i] = new Thread(getters[i]);
                        ++i;
                    }
                } else if (args[0].equals("-c3s")) {
                    len = Integer.parseInt(args[1]);
                    userNum = Integer.parseInt(args[3]);
                    getters = new Client[len];
                    threads = new Thread[len];
                    i = 0;
                    while (i < len) {
                        id = "test" + Integer.toString(i + userNum);
                        getters[i] = new ChefClient3(args[2], id, id, Integer.parseInt(args[4]), args[5], true, true);
                        threads[i] = new Thread(getters[i]);
                        ++i;
                    }
                } else if (args[0].equals("-c3q")) {
                    len = Integer.parseInt(args[1]);
                    userNum = Integer.parseInt(args[3]);
                    getters = new Client[len];
                    threads = new Thread[len];
                    i = 0;
                    while (i < len) {
                        id = "test" + Integer.toString(i + userNum);
                        getters[i] = new ChefClient3(args[2], id, id, Integer.parseInt(args[4]), args[5], false, false);
                        threads[i] = new Thread(getters[i]);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("usage: Robot -l url url url ... (for a list of urls - concurrent)");
                System.out.println("usage: Robot -n n url (for a single url n times - concurrent)");
                System.out.println("usage: Robot -lp url times sleep (for a single url n times - sequence)");
                System.out.println("usage: Robot -lpc url times sleep (for a single url n times - sequence w/cookie)");
                System.out.println("usage: Robot -s url url url ... (for a list of urls - showing the content returned)");
                System.out.println("usage: Robot -c1 n server userNum cycles group (for n chef1 (watcher) clients)");
                System.out.println("usage: Robot -c2 n server userNum cycles group (for n chef2 (fake/bulky watrcher) clients)");
                System.out.println("usage: Robot -c3 n server userNum cycles group (for n chef3 (chatter) clients)");
                System.out.println("usage: Robot -c3s n server userNum cycles group (for n chef3 (chatter) clients - show content returned)");
                System.out.println("usage: Robot -c3q n server userNum cycles group (for n chef3 (chatter) clients - no posts)");
                System.exit(0);
            }
            start = System.currentTimeMillis();
            int i = 0;
            while (i < len) {
                threads[i].start();
                ++i;
            }
            boolean allDone = false;
            while (!allDone) {
                allDone = true;
                int i3 = 0;
                while (i3 < len) {
                    if (!getters[i3].isDone()) {
                        allDone = false;
                        break;
                    }
                    ++i3;
                }
                if (allDone) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            long elapsed = System.currentTimeMillis() - start;
            long sum = 0L;
            int i4 = 0;
            while (i4 < len) {
                sum += getters[i4].getTimes().total();
                ++i4;
            }
            System.out.println("time\ti\taddr\tres\tlen\tstarted\tconnected\tended\ttotal\texception\tcookies");
            long average = 0L;
            long longest = 0L;
            int longestIndex = -1;
            long shortest = 0L;
            int shortestIndex = -1;
            int i5 = 0;
            while (i5 < len) {
                System.out.println(new Time().toStringLocalTime24() + "\t" + i5 + "\t" + getters[i5].getAddress() + "\t" + getters[i5].getResponse() + "\t" + getters[i5].getLength() + "\t" + (getters[i5].getTimes().started - start) + "\t" + (getters[i5].getTimes().connected - start) + "\t" + (getters[i5].getTimes().ended - start) + "\t" + getters[i5].getTimes().total() + (getters[i5].getException() != null ? "\t\"" + getters[i5].getException().toString() + "\"" : "\tok") + (getters[i5].getCookies() != null ? "\t\"" + getters[i5].getCookies() + "\"" : "\t<none>"));
                average += getters[i5].getTimes().total();
                if (longest < getters[i5].getTimes().total() || longestIndex == -1) {
                    longest = getters[i5].getTimes().total();
                    longestIndex = i5;
                }
                if (shortest > getters[i5].getTimes().total() || shortestIndex == -1) {
                    shortest = getters[i5].getTimes().total();
                    shortestIndex = i5;
                }
                ++i5;
            }
            System.out.println("\n\nLongest time: " + longest + " @ " + longestIndex);
            System.out.println("Shortest time: " + shortest + " @ " + shortestIndex);
            System.out.println("Average time: " + (average /= (long)len));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
    }

    class ChefClient3
    extends BaseClient {
        private String m_password = null;
        private int m_status = 0;
        private int m_count = 30;
        private String m_group = null;
        private boolean m_active = false;

        public boolean isDone() {
            return this.m_status == 1;
        }

        public ChefClient3(String server, String userid, String password, int duration, String group, boolean show, boolean active) {
            this.m_address = server;
            this.m_id = userid;
            this.m_password = password;
            this.m_count = duration;
            this.m_group = group;
            this.m_showContent = show;
            this.m_active = active;
        }

        public void run() {
            try {
                int count = 0;
                int loginCount = 0;
                while (true) {
                    boolean breakout;
                    this.getFull("", this.m_address);
                    this.getFull(this.m_address, "/portal/action/ChefLoginUser/username/" + this.m_id + "x" + ++loginCount + "/password/" + this.m_password + "x" + loginCount);
                    do {
                        this.chat(10, this.m_group, this.m_active);
                        if ((count += 10) >= this.m_count && this.m_count > 0) {
                            this.get(this.m_address, "/portal/action/ChefLogoutUser");
                            this.m_status = 1;
                            return;
                        }
                        breakout = false;
                        if (count % 30 == 0) {
                            this.get(this.m_address, "/portal/action/ChefLogoutUser");
                            this.m_cookie = null;
                            breakout = true;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    } while (!breakout);
                }
            }
            catch (Exception any) {
                this.m_exception = any;
                any.printStackTrace();
                this.m_status = 1;
                return;
            }
        }
    }

    class ChefClient2
    extends BaseClient {
        private String m_password = null;
        private int m_status = 0;
        private int m_count = 30;
        private String m_group = null;

        public boolean isDone() {
            return this.m_status == 1;
        }

        public ChefClient2(String server, String userid, String password, int duration, String group) {
            this.m_address = server + "/examples/bulky";
            this.m_id = userid;
            this.m_password = password;
            this.m_count = duration;
            this.m_group = group;
        }

        public void run() {
            try {
                this.get(this.m_address + "?size=10");
                this.get(this.m_address, "/portal/group/" + this.m_group + "/action/ChefLoginUser/username/" + this.m_id + "/password/" + this.m_password + "?size=10");
                boolean goOn = true;
                int count = 0;
                while (goOn) {
                    this.get(this.m_address, "/portal/group/" + this.m_group + "/action/Courier" + "?size=1");
                    if (count % 3 == 0) {
                        this.get(this.m_address, "/portal/group/" + this.m_group + "?size=10");
                    }
                    if (++count >= this.m_count && this.m_count > 0) {
                        this.get(this.m_address, "/portal/action/ChefLogoutUser?size=1");
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception any) {
                this.m_exception = any;
            }
            this.m_status = 1;
        }
    }

    class ChefClient1
    extends BaseClient {
        private String m_password = null;
        private int m_status = 0;
        private int m_count = 30;
        private String m_group = null;

        public boolean isDone() {
            return this.m_status == 1;
        }

        public ChefClient1(String server, String userid, String password, int duration, String group) {
            this.m_address = server;
            this.m_id = userid;
            this.m_password = password;
            this.m_count = duration;
            this.m_group = group;
        }

        public void run() {
            try {
                this.get(this.m_address);
                this.get(this.m_address, "/portal/group/" + this.m_group + "/action/ChefLoginUser/username/" + this.m_id + "/password/" + this.m_password);
                boolean goOn = true;
                int count = 0;
                while (goOn) {
                    this.get(this.m_address, "/portal/group/" + this.m_group + "/action/Courier");
                    if (count % 3 == 0) {
                        this.getFull(this.m_address, "/portal/group/" + this.m_group);
                    }
                    if (++count >= this.m_count && this.m_count > 0) {
                        this.get(this.m_address, "/portal/action/ChefLogoutUser");
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception any) {
                this.m_exception = any;
            }
            this.m_status = 1;
        }
    }

    class RobotClient
    extends BaseClient {
        private int m_status = 0;
        private int m_count = 0;
        private long m_sleep = 0L;

        public RobotClient(String address, boolean showContent, int count, long sleep, boolean useCookie) {
            this.m_address = address;
            this.m_showContent = showContent;
            this.m_count = count;
            this.m_sleep = sleep;
            this.m_useCookie = useCookie;
        }

        public boolean isDone() {
            return this.m_status == 2;
        }

        public void run() {
            this.m_status = 1;
            try {
                boolean goOn = true;
                int count = 0;
                while (goOn) {
                    this.m_response = this.get(this.m_address);
                    if (this.m_count <= 0 || ++count < this.m_count) {
                        try {
                            Thread.sleep(this.m_sleep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.m_exception = e;
            }
            this.m_status = 2;
        }
    }

    abstract class BaseClient
    implements Client {
        protected static final String ESCAPE_URL = "$&+,:;=?@ '\"<>#%{}|\\^~[]`";
        protected static final int HTTP_RESPONSE_OK = 200;
        protected static final int HTTP_RESPONSE_OK_NO_CONTENT = 204;
        protected static final int BLOB_SIZE = 32768;
        protected Times m_times;
        protected Blob m_content;
        protected String m_cookie;
        protected boolean m_showContent;
        protected String m_id;
        protected int m_response;
        protected Exception m_exception;
        protected String m_address;
        protected boolean m_useCookie;
        String[] m_quotes;

        BaseClient() {
            this.m_times = new Times();
            this.m_content = new Blob(32768);
            this.m_cookie = null;
            this.m_showContent = false;
            this.m_id = null;
            this.m_response = 0;
            this.m_exception = null;
            this.m_address = null;
            this.m_useCookie = true;
            this.m_quotes = null;
        }

        public int getLength() {
            return this.m_content.length();
        }

        public int getResponse() {
            return this.m_response;
        }

        public Exception getException() {
            return this.m_exception;
        }

        public Times getTimes() {
            return this.m_times;
        }

        public String getAddress() {
            return this.m_address;
        }

        public String getCookies() {
            return this.m_cookie;
        }

        protected int get(String address) throws Exception {
            return this.get("", address);
        }

        protected int get(String root, String rest) throws Exception {
            this.m_content.truncate(0);
            String address = root + rest;
            if (address.trim().length() == 0) {
                return 0;
            }
            Times times = this.m_times;
            times.started = System.currentTimeMillis();
            times.connected = this.m_times.started;
            times.ended = this.m_times.started;
            URL url = new URL(address);
            URLConnection connection = url.openConnection();
            if (this.m_cookie != null && this.m_useCookie) {
                connection.setRequestProperty("Cookie", this.m_cookie);
            }
            int responseCode = 200;
            connection.connect();
            times.connected = System.currentTimeMillis();
            try {
                responseCode = ((HttpURLConnection)connection).getResponseCode();
            }
            catch (ClassCastException ignore) {
                // empty catch block
            }
            InputStream in = connection.getInputStream();
            if (responseCode != 200 && responseCode != 204 && responseCode != 304) {
                throw new IOException("HTTP response code not OK.  response code: " + responseCode + " url: " + url);
            }
            if (in == null) {
                throw new IOException("InputStream is null.  url: " + url);
            }
            int result = 0;
            if (responseCode != 304) {
                result = this.m_content.read(in);
                if (this.m_showContent) {
                    this.m_content.write(System.out);
                }
            }
            if (result == -2) {
                throw new IOException("response too big to cache! url: " + url);
            }
            times.ended = System.currentTimeMillis();
            String cookieSent = this.m_cookie;
            this.setCookies(connection.getHeaderField("Set-Cookie"));
            System.out.println(new Time().toStringLocalTime24() + "  " + (times.total() > 5000L ? "*" : "") + times.total() + "  " + this.m_id + "  " + rest + "  " + responseCode + "  " + this.m_content.length() + "  " + (times.started - start) + "  " + (times.connected - start) + "  " + (times.ended - start) + (this.getException() != null ? "  \"" + this.getException().toString() + "\"" : "  ok") + "  " + (this.m_useCookie ? cookieSent : "<no cookie sent>") + "  " + this.m_cookie);
            return responseCode;
        }

        protected int getFull(String root, String address) throws Exception {
            int rv = 0;
            try {
                rv = this.get(root, address);
            }
            catch (Exception any) {
                return rv;
            }
            Blob content = this.m_content;
            this.m_content = new Blob(32768);
            String[] lines = StringUtil.split(content.getString(), "\n");
            int mode = 0;
            int i = 0;
            while (i < lines.length) {
                switch (mode) {
                    case 0: {
                        int pos = lines[i].indexOf("<iframe");
                        if (pos == -1) break;
                        int pos2 = lines[i].indexOf("src=\"", pos + 7);
                        if (pos2 != -1) {
                            int pos3 = lines[i].indexOf("\"", pos2 + 5);
                            String url = lines[i].substring(pos2 + 5, pos3);
                            this.getFull("", url);
                            break;
                        }
                        mode = 1;
                        break;
                    }
                    case 1: {
                        int pos = lines[i].indexOf("src=\"");
                        if (pos == -1) break;
                        int pos2 = lines[i].indexOf("\"", pos + 5);
                        String url = lines[i].substring(pos + 5, pos2);
                        this.getFull("", url);
                        mode = 0;
                    }
                }
                ++i;
            }
            this.m_content = content;
            return rv;
        }

        protected void setCookies(String cookies) {
            if (cookies == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cookies, "=;", false);
            String name = st.nextToken();
            String value = st.nextToken();
            this.m_cookie = name + "=" + value;
        }

        protected String escapeUrl(String id) {
            try {
                byte[] bytes = id.getBytes("UTF-8");
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < bytes.length) {
                    byte b = bytes[i];
                    if (ESCAPE_URL.indexOf((char)b) != -1 || b <= 31 || b == 127 || b >= 128) {
                        buf.append("%");
                        buf.append(Blob.toHex(b));
                    } else {
                        buf.append((char)b);
                    }
                    ++i;
                }
                String rv = buf.toString();
                return rv;
            }
            catch (Exception e) {
                return id;
            }
        }

        protected void chat(int cycles, String site, boolean active) throws Exception {
            this.getFull(this.m_address, "/portal/group/" + site);
            String pane = this.parseChatPane();
            this.getFull(this.m_address, "/portal/group/" + site + "/js_pane/" + pane);
            String peid = this.parsePeid();
            int count = 0;
            while (count < cycles) {
                this.get(this.m_address, "/portal/group/" + site + "/action/Courier");
                if (count % 2 == 0) {
                    this.get(this.m_address, "/portal/group/" + site + "/js_peid/" + peid + "/panel/List/template/content");
                }
                if (active && count % 6 == 0) {
                    this.get(this.m_address, "/portal/group/" + site + "/js_peid/" + peid + "/action/ChatAction/template/courier_content/panel/Control" + "?eventSubmit_doSend=x" + "&message=" + this.escapeUrl(this.getQuote()));
                }
                ++count;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getQuote() throws Exception {
            if (this.m_quotes == null) {
                Random random = Robot.this.m_random;
                synchronized (random) {
                    if (this.m_quotes == null) {
                        this.get("http://chefproject.org/project/src/quotes.txt");
                        this.m_quotes = StringUtil.split(this.m_content.getString(), "\n");
                    }
                }
            }
            int i = Robot.this.m_random.nextInt(this.m_quotes.length);
            return this.m_quotes[i];
        }

        private String parseChatPane() {
            String[] lines = StringUtil.split(this.m_content.getString(), "\n");
            int i = 0;
            while (i < lines.length) {
                int pos = lines[i].indexOf("\">Chat<");
                if (pos != -1) {
                    int pos2 = lines[i].indexOf("js_pane/");
                    int pos3 = lines[i].indexOf("/", pos2 + 8);
                    String paneId = lines[i].substring(pos2 + 8, pos3);
                    return paneId;
                }
                ++i;
            }
            return "none";
        }

        private String parsePeid() {
            String[] lines = StringUtil.split(this.m_content.getString(), "\n");
            int i = 0;
            while (i < lines.length) {
                int pos = lines[i].indexOf("js_peid/");
                if (pos != -1) {
                    int pos2 = lines[i].indexOf("/", pos + 8);
                    String peid = lines[i].substring(pos + 8, pos2);
                    return peid;
                }
                ++i;
            }
            return "none";
        }

        static {
            ESCAPE_URL = ESCAPE_URL;
            HTTP_RESPONSE_OK = 200;
            HTTP_RESPONSE_OK_NO_CONTENT = 204;
            BLOB_SIZE = 32768;
        }
    }

    static interface Client
    extends Runnable {
        public boolean isDone();

        public Times getTimes();

        public String getAddress();

        public int getLength();

        public int getResponse();

        public Exception getException();

        public String getCookies();
    }

    class Times {
        long started;
        long connected;
        long ended;

        Times() {
        }

        long total() {
            return this.ended - this.started;
        }
    }
}

