/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <gtksourceview/gtksource.h>
#include "gtksourceview/file-loading-and-saving/gtksourceencodingconversion.h"

static void
test_try_convert_success (void)
{
	GtkSourceEncoding *utf8_encoding;
	gboolean ret;

	utf8_encoding = gtk_source_encoding_new_utf8 ();

	ret = _gtk_source_encoding_conversion_try_convert (utf8_encoding, "a", 1);
	g_assert_true (ret);

	gtk_source_encoding_free (utf8_encoding);
}

static void
test_try_convert_illegal_sequence (void)
{
	GtkSourceEncoding *utf8_encoding;
	guint8 input_buffer[1];
	gboolean ret;

	utf8_encoding = gtk_source_encoding_new_utf8 ();

	// 255, aka "1111 1111" in binary and 0xFF in hexadecimal.
	// In UTF-8, this is an invalid byte.
	// See https://en.wikipedia.org/wiki/UTF-8
	input_buffer[0] = 255;

	ret = _gtk_source_encoding_conversion_try_convert (utf8_encoding,
							   (const gchar *) input_buffer,
							   1);
	g_assert_false (ret);

	gtk_source_encoding_free (utf8_encoding);
}

int
main (int    argc,
      char **argv)
{
	int exit_status;

	gtk_source_init ();
	g_test_init (&argc, &argv, NULL);

	g_test_add_func ("/EncodingConversion/try_convert_success", test_try_convert_success);
	g_test_add_func ("/EncodingConversion/try_convert_illegal_sequence", test_try_convert_illegal_sequence);

	exit_status = g_test_run ();
	gtk_source_finalize ();

	return exit_status;
}
