/*
 *
 *  Copyright (C) 2000 Silicon Graphics, Inc.  All Rights Reserved. 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program with
 *  other software, or any other product whatsoever.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA  94043, or:
 * 
 *  http://www.sgi.com 
 * 
 *  For further information regarding this notice, see: 
 * 
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 *
 */

#include <cmath>
#include <cstdlib>
#include <Inventor/errors/SoDebugError.h>
#include "SoAddPrefix.h"
#include "SoPrimRender.h"
#include "clients/softcurvemaps.h"
#include "clients/softsurfacemaps.h"

_SoNurbsPrimRender::_SoNurbsPrimRender( SoAction *act, SoNurbsPrimCB *cb, void *data )
	: _SoNurbsNurbsTessellator( curveEvaluator, surfaceEvaluator )
{
    redefineMaps();
    defineMap( N_C4D, 0, 4 );
    defineMap( N_C4DR, 1, 5 );
    defineMap( N_T2D, 0, 2 );
    defineMap( N_T2DR, 1, 3 );
    defineMap( N_V3D, 0, 3 );
    defineMap( N_V3DR, 1, 4 );

    surfaceEvaluator.initialize(act, cb, data);
    curveEvaluator.initialize(act, cb, data);
}

_SoNurbsPrimRender::~_SoNurbsPrimRender()
{
}

void 
_SoNurbsPrimRender::loadMatrices( SbMatrix &vmat, const SbVec2s &vpSize ) 
{
    loadCullingMatrix( vmat );

    //
    // Check the method of sampling the NURBS surface.  If it is an
    // object space tessellation, then a sampling matrix does not 
    // need to be loaded.
    //
    INREAL samplingMethod;

    getnurbsproperty( N_V3D,  N_SAMPLINGMETHOD, &samplingMethod );
    if (samplingMethod != N_FIXEDRATE)
        loadSamplingMatrix( vmat, vpSize );
}


void
_SoNurbsPrimRender::loadSamplingMatrix( SbMatrix &vmat, const SbVec2s &vpSize )
{
    /* rescale the mapping to correspond to pixels in x/y */
    REAL xsize = 0.5 * (REAL) (vpSize[0]); 
    REAL ysize = 0.5 * (REAL) (vpSize[1]); 

    INREAL smat[4][4];
    smat[0][0] = vmat[0][0] * xsize;
    smat[1][0] = vmat[1][0] * xsize;
    smat[2][0] = vmat[2][0] * xsize;
    smat[3][0] = vmat[3][0] * xsize;

    smat[0][1] = vmat[0][1] * ysize;
    smat[1][1] = vmat[1][1] * ysize;
    smat[2][1] = vmat[2][1] * ysize;
    smat[3][1] = vmat[3][1] * ysize;

    smat[0][2] = 0.0;
    smat[1][2] = 0.0;
    smat[2][2] = 0.0;
    smat[3][2] = 0.0;

    smat[0][3] = vmat[0][3];
    smat[1][3] = vmat[1][3];
    smat[2][3] = vmat[2][3];
    smat[3][3] = vmat[3][3];

    setnurbsproperty( N_V3D, N_SAMPLINGMATRIX, &smat[0][0], 4, 1);
    setnurbsproperty( N_V3DR, N_SAMPLINGMATRIX, &smat[0][0], 4, 1);
}

void
_SoNurbsPrimRender::loadCullingMatrix( SbMatrix &vmat )
{
    INREAL cmat[4][4];

    cmat[0][0] = vmat[0][0];
    cmat[0][1] = vmat[0][1];
    cmat[0][2] = vmat[0][2];
    cmat[0][3] = vmat[0][3];

    cmat[1][0] = vmat[1][0];
    cmat[1][1] = vmat[1][1];
    cmat[1][2] = vmat[1][2];
    cmat[1][3] = vmat[1][3];

    cmat[2][0] = vmat[2][0];
    cmat[2][1] = vmat[2][1];
    cmat[2][2] = vmat[2][2];
    cmat[2][3] = vmat[2][3];

    cmat[3][0] = vmat[3][0];
    cmat[3][1] = vmat[3][1];
    cmat[3][2] = vmat[3][2];
    cmat[3][3] = vmat[3][3];

    setnurbsproperty( N_V3D, N_CULLINGMATRIX, &cmat[0][0], 4, 1);
    setnurbsproperty( N_V3DR, N_CULLINGMATRIX, &cmat[0][0], 4, 1);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Handle an error generated by bad input data.
//
// Use: public

void
_SoNurbsPrimRender::errorHandler( int msg )

//
////////////////////////////////////////////////////////////////////////
{
#ifdef DEBUG
#if     0       /* libnurbs doesn't support error messages any longer */
    SoDebugError::post("_SoNurbsPrimRender::errorHandler",
            "NURBS - %s", _SoNurbsNurbsTessellator::nurbserror[msg]);
#endif      
#endif      
}
