//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/listAutomationAccountKeys.json
func ExampleKeysClient_ListByAutomationAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKeysClient().ListByAutomationAccount(ctx, "rg", "MyAutomationAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KeyListResult = armautomation.KeyListResult{
	// 	Keys: []*armautomation.Key{
	// 		{
	// 			KeyName: to.Ptr(armautomation.AutomationKeyNamePrimary),
	// 			Permissions: to.Ptr(armautomation.AutomationKeyPermissionsFull),
	// 			Value: to.Ptr("**************************************************************"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr(armautomation.AutomationKeyNameSecondary),
	// 			Permissions: to.Ptr(armautomation.AutomationKeyPermissionsFull),
	// 			Value: to.Ptr("**************************************************************"),
	// 	}},
	// }
}
