<!--
SPDX-FileCopyrightText: Simon Schneegans <code@simonschneegans.de>
SPDX-License-Identifier: CC-BY-4.0
-->

<p align="center">
  <img src ="docs/pics/logo.gif" />
</p>

<p align="center">
  <a href="https://extensions.gnome.org/extension/3433/fly-pie"><img src="https://img.shields.io/badge/Download-extensions.gnome.org-e67f4d.svg?logo=gnome&logoColor=lightgrey&labelColor=303030" /></a>
  <br />
  <a href="https://github.com/Schneegans/Fly-Pie/actions"><img src="https://github.com/Schneegans/Fly-Pie/workflows/Checks/badge.svg?branch=main" /></a>
  <a href="https://api.reuse.software/info/github.com/Schneegans/Fly-Pie"><img src="https://api.reuse.software/badge/github.com/Schneegans/Fly-Pie" /></a>
  <a href="https://schneegans.github.io/sponsors/"><img src="https://gist.githubusercontent.com/Schneegans/2d06edf0937c480951feb86b9e719304/raw/weekly.svg" /></a>
  <a href="https://hosted.weblate.org/engage/fly-pie/"><img src="https://img.shields.io/weblate/progress/fly-pie?label=Translated&logo=weblate&logoColor=lightgray&labelColor=303030" /></a>
  <a href="scripts/cloc.sh"><img src="https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/Schneegans/8f6459c2417de7534f64d98360dde865/raw/loc.json" /></a>
  <a href="scripts/cloc.sh"><img src="https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/Schneegans/8f6459c2417de7534f64d98360dde865/raw/comments.json" /></a>
</p>

> [!IMPORTANT]
> Fly-Pie is currently in low-maintenance mode as I am working on my follow-up project [🌸 Kando](https://github.com/kando-menu/kando).

**Fly-Pie** is an extension for GNOME Shell which lets you open _marking menus_ via keyboard shortcuts.
You can use it to launch applications, simulate hotkeys, open URLs and much more.

After the installation, you can open the example menu by pressing <kbd>Ctrl</kbd>+<kbd>Space</kbd>.
Once you opened a marking menu, you can seamlessly transition between three alternative selection modes:

<a href="https://youtu.be/BGXtckqhEIk"><img align="right" width="350px" src ="docs/pics/player6.jpg" /></a>

- **Point-and-Click:** Select items by clicking on them or anywhere in the corresponding wedges.
- **Marking-Mode:** Select items by drawing gestures. To do this, click anywhere and drag your mouse. Pausing or making a turn selects the currently dragged item.
- **Turbo-Mode:** You can also "draw" gestures while holding <kbd>Ctrl</kbd>, <kbd>Shift</kbd>, or <kbd>Alt</kbd> _without having to press your mouse button_! This is especially useful when you opened the menu with a shortcut involving such a modifier.

Do you want to learn more? Have a look at the [usage guide](docs/first-steps.md)!

# :heart: Will you love Fly-Pie?

<p align="center">
  <img src ="docs/pics/banner-05.jpg" />
</p>

Fly-Pie is designed for you **if you have one hand at the mouse** most of the time.
It is _not_ designed to be used with a keyboard only; there are other
applications which work better in this case (for example [kupfer](https://github.com/kupferlauncher/kupfer)).
Fly-Pie also works nicely with **touch input**.

If you want to learn more, use the links below for much more information!

## Getting Started

- [Installation](docs/installation.md)
- [First Steps](docs/first-steps.md)
- [The D-Bus Interface](docs/dbus-interface.md)

## Contributing to Fly-Pie

- [Contributing Guidelines](docs/contributing.md)
- [Software Architecture](docs/software-architecture.md)
- [Translating Fly-Pie](docs/translating.md)
- [Creating New Action Types](docs/creating-actions.md)
- [Creating New Menu Types](docs/creating-menus.md)

## Additional Information

- [Changelog](docs/changelog.md)
- [Release Management](docs/release-management.md)
- [Continuous Integration](docs/continuous-integration.md)

# 💞 Show that you _do_ love Fly-Pie!

[![kofi](https://img.shields.io/badge/Donate-on_Ko--fi-ff5e5b?logo=ko-fi)](https://ko-fi.com/schneegans)
[![github](https://img.shields.io/badge/Donate-on_GitHub-purple?logo=github)](https://github.com/sponsors/Schneegans)
[![paypal](https://img.shields.io/badge/Donate-on_PayPal-009cde?logo=paypal)](https://www.paypal.com/donate/?hosted_button_id=3F7UFL8KLVPXE)
[![crypto](https://img.shields.io/badge/Donate-some_Crypto-f7931a?logo=bitcoin)](https://schneegans.cb.id)

While coding new features or translating Fly-Pie is the most awesome way to contribute, providing financial support will encourage me to invest my spare time for developing free and open-source software.

**These awesome people have already donated to the development of my open-source projects:**

<a href="https://schneegans.github.io/sponsors/">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://schneegans.github.io/sponsors/sponsors_dark_small.svg">
    <img alt="Sponsors List" src="https://schneegans.github.io/sponsors/sponsors_light_small.svg#gh-light-mode-only">
  </picture>
</a>

Do you want to show that you love it too? If you donate via [Ko-fi](https://ko-fi.com/schneegans), [GitHub](https://github.com/sponsors/Schneegans), or [PayPal](https://www.paypal.com/donate/?hosted_button_id=3F7UFL8KLVPXE), you will show up in this list as well!

<p align="center"><img src ="docs/pics/hr.svg" /></p>
