#!/bin/sh

# Copyright (c) 2008 Alexander Sack, Sasa Bodiroza
# Description: Script to pack indir to xpifile
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# The script searches indir for unpacked jar files, which must be located in
# ./input_dir/path/to/file.jar!/ dir. It will jar it up to
# ./input_dir/path/to/file.jar, and then remove the contents of unpacked dir.
# After that, it will zip up the contents of indir to xpi file.
# Example: xpi-pack ubufox.out ubufox-ver.xpi

INDIR=$1;
XPIFILE=$2;

usage() {
	echo "$0 - Script to produce XPI file from input directory."
	echo
	echo "The output XPI file is placed in top-level of the input directory.";
	echo "To place it somewhere else, provide relative or absolute path to the";
	echo "output XPI file."
	echo
	echo "To run it call:";
	echo "$ $0 input_directory output_xpi_file"
	echo
	echo " input_directory - directory with the XPI source tree";
	echo " output_xpi_file - name of the produced file";
	exit 1;
}

if [ "$1" = "--help" -o "$1" = "-h" ] ; then
	usage
fi;

if [ -z $INDIR ] ; then
	echo "Missing input directory."
	echo
	usage;
fi;
if [ -z $XPIFILE ] ; then
	echo "Missing XPI name."
	echo
	usage;
fi;
if [ ! -d $INDIR ] ; then
	echo "E: Input directory doesn't exist."
	echo
	usage;
fi;

START_DIR=`pwd`;
PACK_JAR_PATHS="";
cd $INDIR;
for JAR_DIR in `find . -type d -name '*.jar\!'` ; do
	JAR_FILE=`echo $JAR_DIR | sed "s/jar\!$/jar/"`;
	ABS_JAR_PATH=`cd $JAR_DIR ; pwd`;
	ABS_JAR_FILE=`echo $ABS_JAR_PATH | sed "s/jar\!$/jar/"`;
	ABS_CUR_DIR=`pwd`;
	cd $ABS_JAR_PATH;
	echo "Packing $JAR_FILE";
	TZ=UTC zip -q -X -r $ABS_JAR_FILE .;
	cd $ABS_CUR_DIR;
	PACK_JAR_PATHS="$ABS_JAR_FILE $PACK_JAR_PATHS";
	rm -rf $ABS_JAR_PATH;
done;
echo "Packing $XPIFILE";
TZ=UTC zip -q -X -r $START_DIR/$XPIFILE * -x debian/\* temp-*/\*;
[ -f $START_DIR/$XPIFILE ] && XPIDIR=`dirname $START_DIR/$XPIFILE`
ABS_XPIDIR=`cd $XPIDIR; pwd`;
echo "Packed XPI file. It is located in $ABS_XPIDIR";
for JAR_PATH in $PACK_JAR_PATHS ; do
        echo "Unpacking and removing $JAR_PATH";
        TZ=UTC unzip -q $JAR_PATH -d $JAR_PATH!;
        rm -f $JAR_PATH;
done;
cd $START_DIR;
