# -*- coding: utf-8 -*-

# warning.py
# This file is part of qarte-5
#    
# Author: Vincent Vande Vyvre <vincent.vandevyvre@oqapy.eu>
# Copyright: 2016-2022 Vincent Vande Vyvre
# Licence: GPL3
# Home page: https://launchpad.net/qarte


from PyQt5.QtWidgets import QMessageBox, QPushButton

class WarningBox(QMessageBox):
    def __init__(self, code, args, parent):
        super().__init__(parent)
        self.setModal(True)
        self.setWindowTitle("Qarte")
        self.resize(400, 150)
        if code == 4:
            # Error when loading video streams from arte TV Guide
            self.setIcon(QMessageBox.Warning)
            self.setText(_("Can't fetch the page from arte TV Guide"))
            self.setInformativeText(_("Page: %s\n\nReason: %s" % args))
        elif code == 5:
            # The key 'VSR' was not found into the streams json
            self.setIcon(QMessageBox.Warning)
            self.setText(_("Can't found the list of stream's urls"))
            self.setInformativeText(_("Reason: %s" % args))
        elif code == 8:
            # Downloading failed
            self.setIcon(QMessageBox.Warning)
            self.setText(_("Downloading Error"))
            self.setInformativeText(_("Reason: %s" % args[1]))
        elif code == 9:
            # Downloading incomplete
            self.setIcon(QMessageBox.Warning)
            self.setText(_("Downloading of %s incomplete" % args[0]))
            self.setInformativeText(_("Size expected: %s bytes"\
                                        "\n File size: %s bytes" 
                                        %(args[1], args[2])))
        elif code == 10:
            # Close the main window when a downloading is still active
            self.setIcon(QMessageBox.Question)
            self.setText(_("Download is not complete."))
            self.quit_btn = QPushButton("OK")
            self.addButton(self.quit_btn, QMessageBox.ActionRole)



